/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.GridInterruptedException;
import org.gridgain.grid.GridNode;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.GridCacheAtomicityMode;
import org.gridgain.grid.cache.GridCacheProjection;
import org.gridgain.grid.cache.GridCacheTx;
import org.gridgain.grid.cache.GridCacheTxConcurrency;
import org.gridgain.grid.cache.GridCacheTxIsolation;
import org.gridgain.grid.events.GridEvent;
import org.gridgain.grid.events.GridGgfsEvent;
import org.gridgain.grid.ggfs.GridGgfsConcurrentModificationException;
import org.gridgain.grid.ggfs.GridGgfsConfiguration;
import org.gridgain.grid.ggfs.GridGgfsException;
import org.gridgain.grid.ggfs.GridGgfsFileNotFoundException;
import org.gridgain.grid.ggfs.GridGgfsInvalidPathException;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.kernal.managers.eventstorage.GridEventStorageManager;
import org.gridgain.grid.kernal.processors.cache.GridCacheInternal;
import org.gridgain.grid.kernal.processors.cache.GridCacheProjectionEx;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDeleteWorker;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDirectoryNotEmptyException;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileInfo;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsHdfsProperties;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsListingEntry;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSamplingKey;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSecondaryInputStreamDescriptor;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSecondaryInputStreamWrapper;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSecondaryOutputStreamDescriptor;
import org.gridgain.grid.kernal.processors.task.GridInternal;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridInClosure;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.GridLeanMap;
import org.gridgain.grid.util.GridSpinBusyLock;
import org.gridgain.grid.util.lang.GridClosureException;
import org.gridgain.grid.util.typedef.CI1;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.LT;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridGgfsMetaManager
extends GridGgfsManager {
    private GridGgfsConfiguration cfg;
    private GridCache<Object, Object> metaCache;
    private GridCacheProjectionEx<GridUuid, GridGgfsFileInfo> id2InfoPrj;
    private GridCacheInternal sampling;
    private GridLogger log;
    private volatile GridGgfsDeleteWorker delWorker;
    private GridEventStorageManager evts;
    private GridNode locNode;
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();

    @Override
    protected void start0() throws GridException {
        this.cfg = this.ggfsCtx.configuration();
        this.metaCache = this.ggfsCtx.kernalContext().cache().cache(this.cfg.getMetaCacheName());
        if (this.metaCache.configuration().getAtomicityMode() != GridCacheAtomicityMode.TRANSACTIONAL) {
            throw new GridException("Meta cache should be transactional: " + this.cfg.getMetaCacheName());
        }
        this.evts = this.ggfsCtx.kernalContext().event();
        this.sampling = new GridGgfsSamplingKey(this.cfg.getName());
        assert (this.metaCache != null);
        this.id2InfoPrj = (GridCacheProjectionEx)this.metaCache.cache();
        this.log = this.ggfsCtx.kernalContext().log(GridGgfsMetaManager.class);
    }

    @Override
    protected void onKernalStart0() throws GridException {
        this.locNode = this.ggfsCtx.kernalContext().discovery().localNode();
        this.delWorker = new GridGgfsDeleteWorker(this.ggfsCtx);
        this.delWorker.start();
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        GridGgfsDeleteWorker delWorker0 = this.delWorker;
        if (delWorker0 != null) {
            delWorker0.cancel();
        }
        if (delWorker0 != null) {
            try {
                U.join((Thread)delWorker0);
            }
            catch (GridInterruptedException gridInterruptedException) {
                // empty catch block
            }
        }
        this.busyLock.block();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<GridNode> metaCacheNodes() {
        if (this.busyLock.enterBusy()) {
            try {
                Collection collection = this.ggfsCtx.kernalContext().discovery().cacheNodes(this.metaCache.name(), -1L);
                return collection;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get meta cache nodes because Grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridUuid fileId(GridGgfsPath path) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (this.validTxState(false));
                GridUuid gridUuid = this.fileId(path, false);
                return gridUuid;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file ID because Grid is stopping: " + path);
    }

    @Nullable
    private GridUuid fileId(GridGgfsPath path, boolean skipTx) throws GridException {
        List<GridUuid> ids = this.fileIds(path, skipTx);
        assert (ids != null && !ids.isEmpty()) : "Invalid file IDs [path=" + path + ", ids=" + ids + ']';
        return ids.get(ids.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridUuid fileId(GridUuid parentId, String fileName) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridUuid gridUuid = this.fileId(parentId, fileName, false);
                return gridUuid;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file ID because Grid is stopping [parentId=" + parentId + ", fileName=" + fileName + ']');
    }

    @Nullable
    private GridUuid fileId(GridUuid parentId, String fileName, boolean skipTx) throws GridException {
        GridGgfsListingEntry entry = this.directoryListing(parentId, skipTx).get(fileName);
        if (entry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Missing file ID [parentId=" + parentId + ", fileName=" + fileName + ']');
            }
            return null;
        }
        return entry.fileId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GridUuid> fileIds(GridGgfsPath path) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (this.validTxState(false));
                List<GridUuid> list = this.fileIds(path, false);
                return list;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file IDS because Grid is stopping: " + path);
    }

    private List<GridUuid> fileIds(GridGgfsPath path, boolean skipTx) throws GridException {
        assert (path != null);
        List components = path.components();
        ArrayList<GridUuid> ids = new ArrayList<GridUuid>(components.size() + 1);
        ids.add(GridGgfsFileInfo.ROOT_ID);
        GridUuid fileId = GridGgfsFileInfo.ROOT_ID;
        for (String s : components) {
            assert (!s.isEmpty());
            if (fileId != null) {
                fileId = this.fileId(fileId, s, skipTx);
            }
            ids.add(fileId);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(GridUuid fileId) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (fileId != null);
                boolean bl = this.info(fileId) != null;
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to check file system entry existence because Grid is stopping: " + fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridGgfsFileInfo info(@Nullable GridUuid fileId) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                if (fileId == null) {
                    GridGgfsFileInfo gridGgfsFileInfo = null;
                    return gridGgfsFileInfo;
                }
                GridGgfsFileInfo info = (GridGgfsFileInfo)this.id2InfoPrj.get((Object)fileId);
                if (info == null && GridGgfsFileInfo.ROOT_ID.equals((Object)fileId)) {
                    info = new GridGgfsFileInfo();
                    this.id2InfoPrj.putxIfAbsent((Object)GridGgfsFileInfo.ROOT_ID, (Object)info);
                }
                GridGgfsFileInfo gridGgfsFileInfo = info;
                return gridGgfsFileInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file info because Grid is stopping: " + fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<GridUuid, GridGgfsFileInfo> infos(Collection<GridUuid> fileIds) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (this.validTxState(false));
                assert (fileIds != null);
                if (F.isEmpty(fileIds)) {
                    Map<GridUuid, GridGgfsFileInfo> map = Collections.emptyMap();
                    return map;
                }
                Map map = this.id2InfoPrj.getAll(fileIds);
                if (fileIds.contains(GridGgfsFileInfo.ROOT_ID) && !map.containsKey(GridGgfsFileInfo.ROOT_ID)) {
                    GridGgfsFileInfo info = new GridGgfsFileInfo();
                    this.id2InfoPrj.putxIfAbsent((Object)GridGgfsFileInfo.ROOT_ID, (Object)info);
                    map = new GridLeanMap(map);
                    map.put(GridGgfsFileInfo.ROOT_ID, info);
                }
                Map map2 = map;
                return map2;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file infos because Grid is stopping: " + fileIds);
    }

    /*
     * Loose catch block
     */
    public GridGgfsFileInfo lock(GridUuid fileId) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (this.validTxState(false));
                assert (fileId != null);
                try (GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);){
                    GridGgfsFileInfo oldInfo = this.info(fileId);
                    if (oldInfo == null) {
                        throw new GridException("Failed to lock file (file not found): " + fileId);
                    }
                    GridGgfsFileInfo newInfo = this.lockInfo(oldInfo);
                    boolean put = this.metaCache.putx((Object)fileId, (Object)newInfo, new GridPredicate[0]);
                    assert (put) : "Value was not stored in cache [fileId=" + fileId + ", newInfo=" + newInfo + ']';
                    tx.commit();
                    GridGgfsFileInfo gridGgfsFileInfo = newInfo;
                    return gridGgfsFileInfo;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to obtain lock because Grid is stopping: " + fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsFileInfo lockInfo(GridGgfsFileInfo info) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (info != null);
                if (info.lockId() != null) {
                    throw new GridException("Failed to lock file (file is being concurrently written) [fileId=" + info.id() + ", lockId=" + info.lockId() + ']');
                }
                GridGgfsFileInfo gridGgfsFileInfo = new GridGgfsFileInfo(info, GridUuid.randomUuid(), info.modificationTime());
                return gridGgfsFileInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get lock info because Grid is stopping: " + info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(GridGgfsFileInfo info, long modificationTime) throws GridException {
        block18: {
            assert (this.validTxState(false));
            assert (info != null);
            if (this.busyLock.enterBusy()) {
                try {
                    GridUuid lockId = info.lockId();
                    if (lockId == null) {
                        return;
                    }
                    boolean interrupted = Thread.interrupted();
                    GridUuid fileId = info.id();
                    GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);
                    try {
                        GridGgfsFileInfo oldInfo = this.info(fileId);
                        if (oldInfo == null) {
                            throw new GridGgfsFileNotFoundException("Failed to unlock file (file not found): " + fileId);
                        }
                        if (!info.lockId().equals((Object)oldInfo.lockId())) {
                            throw new GridException("Failed to unlock file (inconsistent file lock ID) [fileId=" + fileId + ", lockId=" + info.lockId() + ", actualLockId=" + oldInfo.lockId() + ']');
                        }
                        GridGgfsFileInfo newInfo = new GridGgfsFileInfo(oldInfo, null, modificationTime);
                        boolean put = this.metaCache.putx((Object)fileId, (Object)newInfo, new GridPredicate[0]);
                        assert (put) : "Value was not stored in cache [fileId=" + fileId + ", newInfo=" + newInfo + ']';
                        tx.commit();
                        break block18;
                    }
                    catch (GridClosureException e) {
                        throw U.cast((Throwable)e);
                    }
                    finally {
                        tx.close();
                        assert (this.validTxState(false));
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            }
            throw new IllegalStateException("Failed to unlock file system entry because Grid is stopping: " + info);
        }
    }

    private Map<GridUuid, GridGgfsFileInfo> lockIds(GridUuid ... fileIds) throws GridException {
        assert (this.validTxState(true));
        assert (fileIds != null && fileIds.length > 0);
        Arrays.sort(fileIds);
        List<GridUuid> keys = Arrays.asList(fileIds);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Locking file ids: " + keys);
        }
        Map map = this.id2InfoPrj.getAll(keys);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Locked file ids: " + keys);
        }
        if (keys.contains(GridGgfsFileInfo.ROOT_ID) && !map.containsKey(GridGgfsFileInfo.ROOT_ID)) {
            GridGgfsFileInfo info = new GridGgfsFileInfo();
            this.id2InfoPrj.putxIfAbsent((Object)GridGgfsFileInfo.ROOT_ID, (Object)info);
            map = new GridLeanMap(map);
            map.put(GridGgfsFileInfo.ROOT_ID, info);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GridGgfsListingEntry> directoryListing(GridUuid fileId) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                Map<String, GridGgfsListingEntry> map = this.directoryListing(fileId, false);
                return map;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get directory listing because Grid is stopping: " + fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsFileInfo fileForFragmentizer(Collection<GridUuid> exclude) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsFileInfo gridGgfsFileInfo = this.fileForFragmentizer0(GridGgfsFileInfo.ROOT_ID, exclude);
                return gridGgfsFileInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get file for framentizer because Grid is stopping.");
    }

    private GridGgfsFileInfo fileForFragmentizer0(GridUuid parentId, Collection<GridUuid> exclude) throws GridException {
        GridGgfsFileInfo info = this.info(parentId);
        if (info == null) {
            return null;
        }
        assert (info.isDirectory());
        Map<String, GridGgfsListingEntry> listing = info.listing();
        for (GridGgfsListingEntry entry : listing.values()) {
            GridGgfsFileInfo fileInfo;
            if (!(entry.isFile() ? (fileInfo = this.info(entry.fileId())) != null && !exclude.contains(fileInfo.id()) && fileInfo.fileMap() != null && !fileInfo.fileMap().ranges().isEmpty() : (fileInfo = this.fileForFragmentizer0(entry.fileId(), exclude)) != null)) continue;
            return fileInfo;
        }
        return null;
    }

    private Map<String, GridGgfsListingEntry> directoryListing(GridUuid fileId, boolean skipTx) throws GridException {
        assert (fileId != null);
        GridGgfsFileInfo info = skipTx ? (GridGgfsFileInfo)this.id2InfoPrj.getAllOutTx(Collections.singletonList(fileId)).get(fileId) : (GridGgfsFileInfo)this.id2InfoPrj.get((Object)fileId);
        return info == null ? Collections.emptyMap() : info.listing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsFileInfo putIfAbsent(GridUuid parentId, String fileName, GridGgfsFileInfo newFileInfo) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (this.validTxState(false));
                assert (parentId != null);
                assert (fileName != null);
                assert (newFileInfo != null);
                GridGgfsFileInfo res = null;
                try (GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);){
                    res = this.putIfAbsentNonTx(parentId, fileName, newFileInfo);
                    tx.commit();
                }
                GridGgfsFileInfo gridGgfsFileInfo = res;
                return gridGgfsFileInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to put file because Grid is stopping [parentId=" + parentId + ", fileName=" + fileName + ", newFileInfo=" + newFileInfo + ']');
    }

    private GridGgfsFileInfo putIfAbsentNonTx(GridUuid parentId, String fileName, GridGgfsFileInfo newFileInfo) throws GridException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Locking parent id [parentId=" + parentId + ", fileName=" + fileName + ", newFileInfo=" + newFileInfo + ']');
        }
        this.validTxState(true);
        GridGgfsFileInfo parentInfo = this.info(parentId);
        assert (this.validTxState(true));
        if (parentInfo == null) {
            throw new GridGgfsFileNotFoundException("Failed to lock parent directory (not found): " + parentId);
        }
        if (!parentInfo.isDirectory()) {
            throw new GridGgfsInvalidPathException("Parent file is not a directory: " + parentInfo);
        }
        Map<String, GridGgfsListingEntry> parentListing = parentInfo.listing();
        assert (parentListing != null);
        GridGgfsListingEntry entry = parentListing.get(fileName);
        assert (this.validTxState(true));
        if (entry != null) {
            newFileInfo = this.info(entry.fileId());
            assert (newFileInfo != null) : "Expects file info exist: " + entry.fileId();
            return newFileInfo;
        }
        GridUuid fileId = newFileInfo.id();
        if (!this.id2InfoPrj.putxIfAbsent((Object)fileId, (Object)newFileInfo)) {
            throw new GridGgfsException("Failed to add file details into cache: " + newFileInfo);
        }
        assert (this.metaCache.get((Object)parentId) != null);
        this.id2InfoPrj.transform((Object)parentId, (GridClosure)new UpdateListing(fileName, new GridGgfsListingEntry(newFileInfo), false));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(GridUuid fileId, String srcFileName, GridUuid srcParentId, String destFileName, GridUuid destParentId) throws GridException {
        block8: {
            if (this.busyLock.enterBusy()) {
                try {
                    assert (this.validTxState(false));
                    try (GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);){
                        this.moveNonTx(fileId, srcFileName, srcParentId, destFileName, destParentId);
                        tx.commit();
                        break block8;
                    }
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            }
            throw new IllegalStateException("Failed to move file system entry because Grid is stopping [fileId=" + fileId + ", srcFileName=" + srcFileName + ", srcParentId=" + srcParentId + ", destFileName=" + destFileName + ", destParentId=" + destParentId + ']');
        }
    }

    private void moveNonTx(GridUuid fileId, @Nullable String srcFileName, GridUuid srcParentId, String destFileName, GridUuid destParentId) throws GridException {
        assert (this.validTxState(true));
        assert (fileId != null);
        assert (srcFileName != null);
        assert (srcParentId != null);
        assert (destFileName != null);
        assert (destParentId != null);
        if (srcParentId.equals((Object)destParentId) && srcFileName.equals(destFileName)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("File is moved to itself [fileId=" + fileId + ", fileName=" + srcFileName + ", parentId=" + srcParentId + ']');
            }
            return;
        }
        Map<GridUuid, GridGgfsFileInfo> infoMap = this.lockIds(srcParentId, fileId, destParentId);
        this.validTxState(true);
        GridGgfsFileInfo srcInfo = infoMap.get(srcParentId);
        if (srcInfo == null) {
            throw new GridGgfsFileNotFoundException("Failed to lock source directory (not found?) [srcParentId=" + srcParentId + ']');
        }
        if (!srcInfo.isDirectory()) {
            throw new GridGgfsInvalidPathException("Source is not a directory: " + srcInfo);
        }
        GridGgfsFileInfo destInfo = infoMap.get(destParentId);
        if (destInfo == null) {
            throw new GridGgfsFileNotFoundException("Failed to lock destination directory (not found?) [destParentId=" + destParentId + ']');
        }
        if (!destInfo.isDirectory()) {
            throw new GridGgfsInvalidPathException("Destination is not a directory: " + destInfo);
        }
        GridGgfsFileInfo fileInfo = infoMap.get(fileId);
        if (fileInfo == null) {
            throw new GridGgfsFileNotFoundException("Failed to lock target file (not found?) [fileId=" + fileId + ']');
        }
        GridGgfsListingEntry srcEntry = srcInfo.listing().get(srcFileName);
        GridGgfsListingEntry destEntry = destInfo.listing().get(destFileName);
        if (srcEntry == null || !srcEntry.fileId().equals((Object)fileId)) {
            throw new GridGgfsFileNotFoundException("Failed to remove file name from the source directory (file not found) [fileId=" + fileId + ", srcFileName=" + srcFileName + ", srcParentId=" + srcParentId + ", srcEntry=" + srcEntry + ']');
        }
        if (destEntry != null) {
            throw new GridGgfsInvalidPathException("Failed to add file name into the destination directory (file already exists) [fileId=" + fileId + ", destFileName=" + destFileName + ", destParentId=" + destParentId + ", destEntry=" + destEntry + ']');
        }
        assert (this.metaCache.get((Object)srcParentId) != null);
        assert (this.metaCache.get((Object)destParentId) != null);
        this.id2InfoPrj.transform((Object)srcParentId, (GridClosure)new UpdateListing(srcFileName, srcEntry, true));
        this.id2InfoPrj.transform((Object)destParentId, (GridClosure)new UpdateListing(destFileName, srcEntry, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridGgfsFileInfo removeIfEmpty(GridUuid parentId, String fileName, GridUuid fileId, GridGgfsPath path, boolean rmvLocked) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsFileInfo gridGgfsFileInfo;
                assert (this.validTxState(false));
                GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);
                try {
                    if (parentId != null) {
                        this.lockIds(parentId, fileId, GridGgfsFileInfo.TRASH_ID);
                    } else {
                        this.lockIds(fileId, GridGgfsFileInfo.TRASH_ID);
                    }
                    GridGgfsFileInfo fileInfo = this.removeIfEmptyNonTx(parentId, fileName, fileId, path, rmvLocked);
                    tx.commit();
                    this.delWorker.signal();
                    gridGgfsFileInfo = fileInfo;
                }
                catch (Throwable throwable) {
                    tx.close();
                    throw throwable;
                }
                tx.close();
                return gridGgfsFileInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to remove file system entry because Grid is stopping [parentId=" + parentId + ", fileName=" + fileName + ", fileId=" + fileId + ", path=" + path + ']');
    }

    @Nullable
    private GridGgfsFileInfo removeIfEmptyNonTx(@Nullable GridUuid parentId, String fileName, GridUuid fileId, GridGgfsPath path, boolean rmvLocked) throws GridException {
        Map<String, GridGgfsListingEntry> listing;
        assert (this.validTxState(true));
        assert (parentId != null);
        assert (fileName != null);
        assert (fileId != null);
        assert (!GridGgfsFileInfo.ROOT_ID.equals((Object)fileId));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove file: [parentId=" + parentId + ", fileName= " + fileName + ", fileId=" + fileId + ']');
        }
        GridGgfsFileInfo fileInfo = (GridGgfsFileInfo)this.id2InfoPrj.get((Object)fileId);
        GridGgfsFileInfo parentInfo = (GridGgfsFileInfo)this.id2InfoPrj.get((Object)parentId);
        if (fileInfo == null || parentInfo == null) {
            GridGgfsListingEntry entry;
            if (parentInfo != null && (entry = parentInfo.listing().get(fileName)) != null && entry.fileId().equals((Object)fileId)) {
                throw new GridException("Failed to remove file (file system is in inconsistent state) [fileInfo=" + fileInfo + ", fileName=" + fileName + ", fileId=" + fileId + ']');
            }
            return null;
        }
        assert (parentInfo.isDirectory());
        if (!rmvLocked && fileInfo.lockId() != null) {
            throw new GridGgfsException("Failed to remove file (file is opened for writing) [fileName=" + fileName + ", fileId=" + fileId + ", lockId=" + fileInfo.lockId() + ']');
        }
        if (fileInfo.isDirectory() && !F.isEmpty(listing = fileInfo.listing())) {
            throw new GridGgfsDirectoryNotEmptyException("Failed to remove file (directory is not empty) [fileId=" + fileId + ", listing=" + listing + ']');
        }
        GridGgfsListingEntry listingEntry = parentInfo.listing().get(fileName);
        if (listingEntry == null || !listingEntry.fileId().equals((Object)fileId)) {
            return null;
        }
        this.softDeleteNonTx(parentId, fileName, fileId);
        this.id2InfoPrj.transform((Object)fileId, (GridClosure)new UpdatePath(path));
        return GridGgfsFileInfo.builder(fileInfo).path(path).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridUuid softDelete(@Nullable GridUuid parentId, @Nullable String pathName, GridUuid pathId) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridUuid gridUuid;
                assert (this.validTxState(false));
                GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);
                try {
                    if (parentId == null) {
                        this.lockIds(pathId, GridGgfsFileInfo.TRASH_ID);
                    } else {
                        this.lockIds(parentId, pathId, GridGgfsFileInfo.TRASH_ID);
                    }
                    GridUuid resId = this.softDeleteNonTx(parentId, pathName, pathId);
                    tx.commit();
                    this.delWorker.signal();
                    gridUuid = resId;
                }
                catch (Throwable throwable) {
                    tx.close();
                    throw throwable;
                }
                tx.close();
                return gridUuid;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to perform soft delete because Grid is stopping [parentId=" + parentId + ", pathName=" + pathName + ", pathId=" + pathId + ']');
    }

    @Nullable
    private GridUuid softDeleteNonTx(@Nullable GridUuid parentId, @Nullable String name, GridUuid id) throws GridException {
        GridUuid resId;
        assert (this.validTxState(true));
        if (parentId == null) {
            Map<String, GridGgfsListingEntry> rootListing;
            assert (GridGgfsFileInfo.ROOT_ID.equals((Object)id));
            GridGgfsFileInfo rootInfo = (GridGgfsFileInfo)this.id2InfoPrj.get((Object)GridGgfsFileInfo.ROOT_ID);
            if (rootInfo == null) {
                return null;
            }
            if (this.id2InfoPrj.get((Object)GridGgfsFileInfo.TRASH_ID) == null) {
                this.id2InfoPrj.put((Object)GridGgfsFileInfo.TRASH_ID, (Object)new GridGgfsFileInfo(GridGgfsFileInfo.TRASH_ID), new GridPredicate[0]);
            }
            if (!(rootListing = rootInfo.listing()).isEmpty()) {
                GridUuid[] lockIds = new GridUuid[rootInfo.listing().size()];
                int i = 0;
                for (GridGgfsListingEntry entry : rootInfo.listing().values()) {
                    lockIds[i++] = entry.fileId();
                }
                this.lockIds(lockIds);
                HashMap<String, GridGgfsListingEntry> transferListing = new HashMap<String, GridGgfsListingEntry>();
                transferListing.putAll(rootListing);
                GridGgfsFileInfo newInfo = new GridGgfsFileInfo(transferListing);
                this.id2InfoPrj.put((Object)newInfo.id(), (Object)newInfo, new GridPredicate[0]);
                this.id2InfoPrj.transform((Object)GridGgfsFileInfo.TRASH_ID, (GridClosure)new UpdateListing(newInfo.id().toString(), new GridGgfsListingEntry(newInfo), false));
                for (Map.Entry entry : transferListing.entrySet()) {
                    this.id2InfoPrj.transform((Object)GridGgfsFileInfo.ROOT_ID, (GridClosure)new UpdateListing((String)entry.getKey(), (GridGgfsListingEntry)entry.getValue(), true));
                }
                resId = newInfo.id();
            } else {
                resId = null;
            }
        } else {
            if (this.id2InfoPrj.get((Object)GridGgfsFileInfo.TRASH_ID) == null) {
                this.id2InfoPrj.put((Object)GridGgfsFileInfo.TRASH_ID, (Object)new GridGgfsFileInfo(GridGgfsFileInfo.TRASH_ID), new GridPredicate[0]);
            }
            this.moveNonTx(id, name, parentId, id.toString(), GridGgfsFileInfo.TRASH_ID);
            resId = id;
        }
        return resId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<GridUuid> delete(GridUuid parentId, Map<String, GridGgfsListingEntry> listing) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                HashSet<GridUuid> hashSet;
                assert (parentId != null);
                assert (listing != null);
                assert (this.validTxState(false));
                GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);
                try {
                    HashSet<GridUuid> res = new HashSet<GridUuid>();
                    GridUuid[] allIds = new GridUuid[listing.size() + 1];
                    allIds[0] = parentId;
                    int i = 1;
                    for (GridGgfsListingEntry entry : listing.values()) {
                        allIds[i++] = entry.fileId();
                    }
                    Map<GridUuid, GridGgfsFileInfo> locks = this.lockIds(allIds);
                    GridGgfsFileInfo parentInfo = locks.get(parentId);
                    if (parentInfo != null) {
                        HashMap<String, GridGgfsListingEntry> newListing = new HashMap<String, GridGgfsListingEntry>(parentInfo.listing().size(), 1.0f);
                        newListing.putAll(parentInfo.listing());
                        for (Map.Entry<String, GridGgfsListingEntry> entry : listing.entrySet()) {
                            GridUuid entryId = entry.getValue().fileId();
                            GridGgfsFileInfo entryInfo = locks.get(entryId);
                            if (entryInfo != null) {
                                if (!entryInfo.isFile() && (!entryInfo.isDirectory() || !entryInfo.listing().isEmpty())) continue;
                                this.id2InfoPrj.remove((Object)entryId, new GridPredicate[0]);
                                newListing.remove(entry.getKey());
                                res.add(entryId);
                                continue;
                            }
                            newListing.remove(entry.getKey());
                            res.add(entryId);
                        }
                        this.id2InfoPrj.putx((Object)parentId, (Object)new GridGgfsFileInfo(newListing, parentInfo), new GridPredicate[0]);
                    }
                    tx.commit();
                    hashSet = res;
                }
                catch (Throwable throwable) {
                    tx.close();
                    throw throwable;
                }
                tx.close();
                return hashSet;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to perform delete because Grid is stopping [parentId=" + parentId + ", listing=" + listing + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean delete(GridUuid parentId, String name, GridUuid id) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                boolean bl;
                assert (this.validTxState(false));
                GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);
                try {
                    boolean res = false;
                    Map<GridUuid, GridGgfsFileInfo> infos = this.lockIds(parentId, id);
                    if (infos.containsKey(parentId) && infos.containsKey(id)) {
                        GridGgfsFileInfo parentInfo = infos.get(parentId);
                        assert (parentInfo != null);
                        GridGgfsListingEntry listingEntry = parentInfo.listing().get(name);
                        if (listingEntry != null) {
                            this.id2InfoPrj.transform((Object)parentId, (GridClosure)new UpdateListing(name, listingEntry, true));
                        }
                        this.id2InfoPrj.remove((Object)id, new GridPredicate[0]);
                        res = true;
                    }
                    tx.commit();
                    bl = res;
                }
                catch (Throwable throwable) {
                    tx.close();
                    throw throwable;
                }
                tx.close();
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to perform delete because Grid is stopping [parentId=" + parentId + ", name=" + name + ", id=" + id + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GridUuid> pendingDeletes() throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                Map<String, GridGgfsListingEntry> listing;
                GridGgfsFileInfo trashInfo = (GridGgfsFileInfo)this.id2InfoPrj.get((Object)GridGgfsFileInfo.TRASH_ID);
                if (trashInfo != null && (listing = trashInfo.listing()) != null && !listing.isEmpty()) {
                    Collection collection = F.viewReadOnly(listing.values(), (GridClosure)new GridClosure<GridGgfsListingEntry, GridUuid>(){

                        public GridUuid apply(GridGgfsListingEntry e) {
                            return e.fileId();
                        }
                    }, (GridPredicate[])new GridPredicate[0]);
                    return collection;
                }
                Set<GridUuid> set = Collections.emptySet();
                return set;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get pending deletes because Grid is stopping.");
    }

    @Nullable
    private GridGgfsFileInfo updatePropertiesNonTx(@Nullable GridUuid parentId, GridUuid fileId, String fileName, Map<String, String> props) throws GridException {
        assert (fileId != null);
        assert (!F.isEmpty(props)) : "Expects not-empty file's properties";
        assert (this.validTxState(true));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Update file properties [fileId=" + fileId + ", props=" + props + ']');
        }
        try {
            Map<String, GridGgfsListingEntry> listing;
            GridGgfsListingEntry entry;
            GridGgfsFileInfo parentInfo;
            GridGgfsFileInfo oldInfo;
            if (parentId == null) {
                oldInfo = this.info(fileId);
                parentInfo = null;
            } else {
                Map<GridUuid, GridGgfsFileInfo> locked = this.lockIds(parentId, fileId);
                oldInfo = locked.get(fileId);
                parentInfo = locked.get(parentId);
                if (parentInfo == null) {
                    return null;
                }
            }
            assert (this.validTxState(true));
            if (oldInfo == null) {
                return null;
            }
            if (!(parentInfo == null || (entry = (listing = parentInfo.listing()).get(fileName)) != null && entry.fileId().equals((Object)fileId))) {
                return null;
            }
            GridLeanMap tmp = oldInfo.properties();
            tmp = tmp == null ? new GridLeanMap(props.size()) : new GridLeanMap(tmp);
            for (Map.Entry<String, String> e : props.entrySet()) {
                if (e.getValue() == null) {
                    tmp.remove(e.getKey());
                    continue;
                }
                tmp.put(e.getKey(), e.getValue());
            }
            GridGgfsFileInfo newInfo = new GridGgfsFileInfo(oldInfo, (Map<String, String>)tmp);
            this.id2InfoPrj.putx((Object)fileId, (Object)newInfo, new GridPredicate[0]);
            if (parentId != null) {
                GridGgfsListingEntry entry2 = new GridGgfsListingEntry(newInfo);
                assert (this.metaCache.get((Object)parentId) != null);
                this.id2InfoPrj.transform((Object)parentId, (GridClosure)new UpdateListing(fileName, entry2, false));
            }
            return newInfo;
        }
        catch (GridClosureException e) {
            throw U.cast((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridGgfsFileInfo updateProperties(@Nullable GridUuid parentId, GridUuid fileId, String fileName, Map<String, String> props) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsFileInfo gridGgfsFileInfo;
                assert (this.validTxState(false));
                GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);
                try {
                    GridGgfsFileInfo info = this.updatePropertiesNonTx(parentId, fileId, fileName, props);
                    tx.commit();
                    gridGgfsFileInfo = info;
                }
                catch (Throwable throwable) {
                    tx.close();
                    throw throwable;
                }
                tx.close();
                return gridGgfsFileInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to update properties because Grid is stopping [parentId=" + parentId + ", fileId=" + fileId + ", fileName=" + fileName + ", props=" + props + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateParentListingAsync(GridUuid parentId, GridUuid fileId, String fileName, long lenDelta, long modificationTime) {
        if (this.busyLock.enterBusy()) {
            try {
                assert (parentId != null);
                assert (this.validTxState(false));
                this.id2InfoPrj.transformAsync((Object)parentId, (GridClosure)new UpdateListingEntry(fileId, fileName, lenDelta, 0L, modificationTime));
            }
            finally {
                this.busyLock.leaveBusy();
            }
        } else {
            throw new IllegalStateException("Failed to update parent listing because Grid is stopping [parentId=" + parentId + ", fileId=" + fileId + ", fileName=" + fileName + ']');
        }
    }

    /*
     * Loose catch block
     */
    @Nullable
    public GridGgfsFileInfo updateInfo(GridUuid fileId, GridClosure<GridGgfsFileInfo, GridGgfsFileInfo> c) throws GridException {
        assert (this.validTxState(false));
        assert (fileId != null);
        assert (c != null);
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsFileInfo gridGgfsFileInfo;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Update file info [fileId=" + fileId + ", c=" + c + ']');
                }
                try (GridCacheTx tx = this.metaCache.isLockedByThread((Object)fileId) ? null : this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);){
                    GridGgfsFileInfo oldInfo = this.info(fileId);
                    if (oldInfo == null) {
                        GridGgfsFileInfo gridGgfsFileInfo2 = null;
                        return gridGgfsFileInfo2;
                    }
                    GridGgfsFileInfo newInfo = (GridGgfsFileInfo)c.apply((Object)oldInfo);
                    if (newInfo == null) {
                        throw new GridGgfsException("Failed to update file info with null value [oldInfo=" + oldInfo + ", newInfo=" + newInfo + ", c=" + c + ']');
                    }
                    if (!oldInfo.id().equals((Object)newInfo.id())) {
                        throw new GridGgfsException("Failed to update file info (file IDs differ) [oldInfo=" + oldInfo + ", newInfo=" + newInfo + ", c=" + c + ']');
                    }
                    if (oldInfo.isDirectory() != newInfo.isDirectory()) {
                        throw new GridGgfsException("Failed to update file info (file types differ) [oldInfo=" + oldInfo + ", newInfo=" + newInfo + ", c=" + c + ']');
                    }
                    boolean b = this.metaCache.replace((Object)fileId, (Object)oldInfo, (Object)newInfo);
                    assert (b) : "Inconsistent transaction state [oldInfo=" + oldInfo + ", newInfo=" + newInfo + ", c=" + c + ']';
                    if (tx != null) {
                        tx.commit();
                    }
                    gridGgfsFileInfo = newInfo;
                }
                return gridGgfsFileInfo;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to update file system entry info because Grid is stopping: " + fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sampling(Boolean val) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                boolean bl;
                this.validTxState(false);
                GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);
                try {
                    Object prev = val != null ? this.metaCache.put((Object)this.sampling, (Object)val, new GridPredicate[0]) : this.metaCache.remove((Object)this.sampling, new GridPredicate[0]);
                    tx.commit();
                    bl = !F.eq((Object)prev, (Object)val);
                }
                catch (Throwable throwable) {
                    tx.close();
                    throw throwable;
                }
                tx.close();
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to set sampling flag because Grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean sampling() throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                this.validTxState(false);
                Object val = this.metaCache.get((Object)this.sampling);
                Boolean bl = val == null || !(val instanceof Boolean) ? null : (Boolean)val;
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get sampling flag because Grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsSecondaryOutputStreamDescriptor createDual(final FileSystem fs, final GridGgfsPath path, final boolean simpleCreate, final @Nullable FsPermission perm, final boolean overwrite, final int bufSize, final short replication, final long blockSize, final GridUuid affKey) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsSecondaryOutputStreamDescriptor gridGgfsSecondaryOutputStreamDescriptor;
                assert (fs != null);
                assert (path != null);
                final LinkedList pendingEvts = new LinkedList();
                SynchronizationTask<GridGgfsSecondaryOutputStreamDescriptor> task = new SynchronizationTask<GridGgfsSecondaryOutputStreamDescriptor>(){
                    private FSDataOutputStream out;

                    @Override
                    public GridGgfsSecondaryOutputStreamDescriptor onSuccess(Map<GridGgfsPath, GridGgfsFileInfo> infos) throws Exception {
                        FileStatus status;
                        assert (!infos.isEmpty());
                        GridGgfsPath parentPath = null;
                        for (GridGgfsPath curPath : infos.keySet()) {
                            if (parentPath != null && !curPath.isSubDirectoryOf(parentPath)) continue;
                            parentPath = curPath;
                        }
                        assert (parentPath != null);
                        GridGgfsFileInfo parentInfo = infos.get(parentPath);
                        Path path0 = GridGgfsMetaManager.this.secondaryPath(path);
                        this.out = simpleCreate ? fs.create(GridGgfsMetaManager.this.secondaryPath(path), overwrite) : fs.create(path0, perm, overwrite, bufSize, replication, blockSize, null);
                        GridGgfsPath parent0 = path.parent();
                        assert (parent0 != null) : "path.parent() is null (are we creating ROOT?): " + path;
                        if (!parentPath.equals((Object)parent0)) {
                            parentInfo = GridGgfsMetaManager.this.synchronize(fs, parentPath, parentInfo, parent0, true, null);
                            if (GridGgfsMetaManager.this.evts.isRecordable(124)) {
                                GridGgfsPath evtPath = parent0;
                                while (!parentPath.equals((Object)evtPath)) {
                                    pendingEvts.addFirst(new GridGgfsEvent(evtPath, GridGgfsMetaManager.this.locNode, 124));
                                    evtPath = evtPath.parent();
                                    assert (evtPath != null);
                                }
                            }
                        }
                        try {
                            status = fs.getFileStatus(path0);
                        }
                        catch (IOException e) {
                            throw new GridGgfsException("Failed to get status of the file created in the secondary file system: " + path, (Throwable)e);
                        }
                        if (status == null) {
                            throw new GridGgfsException("Failed to open output stream to the file created in the secondary file system because it no longer exists: " + path);
                        }
                        if (status.isDir()) {
                            throw new GridGgfsException("Failed to open output stream to the file created in the secondary file system because the path points to a directory: " + path);
                        }
                        GridGgfsFileInfo newInfo = new GridGgfsFileInfo((int)status.getBlockSize(), status.getLen(), affKey, GridUuid.randomUuid(), GridGgfsMetaManager.this.ggfsCtx.ggfs().evictExclude(path, false), GridGgfsMetaManager.this.properties(status));
                        GridGgfsFileInfo oldInfo = GridGgfsMetaManager.this.putIfAbsentNonTx(parentInfo.id(), path.name(), newInfo);
                        if (oldInfo != null) {
                            GridGgfsMetaManager.this.id2InfoPrj.removex((Object)oldInfo.id(), new GridPredicate[0]);
                            GridGgfsMetaManager.this.id2InfoPrj.putx((Object)newInfo.id(), (Object)newInfo, new GridPredicate[0]);
                            GridGgfsMetaManager.this.id2InfoPrj.transform((Object)parentInfo.id(), (GridClosure)new UpdateListing(path.name(), parentInfo.listing().get(path.name()), true));
                            GridGgfsMetaManager.this.id2InfoPrj.transform((Object)parentInfo.id(), (GridClosure)new UpdateListing(path.name(), new GridGgfsListingEntry(newInfo), false));
                            GridFuture<Object> delFut = GridGgfsMetaManager.this.ggfsCtx.data().delete(oldInfo);
                            if (GridGgfsMetaManager.this.evts.isRecordable(127)) {
                                delFut.listenAsync((GridInClosure)new CI1<GridFuture<?>>(){

                                    public void apply(GridFuture<?> t) {
                                        try {
                                            t.get();
                                            GridGgfsMetaManager.this.evts.record((GridEvent)new GridGgfsEvent(path, GridGgfsMetaManager.this.locNode, 127));
                                        }
                                        catch (GridException e) {
                                            LT.warn((GridLogger)GridGgfsMetaManager.this.log, (Throwable)e, (String)("Old file deletion failed in DUAL mode [path=" + path + ", simpleCreate=" + simpleCreate + ", permission=" + perm + ", overwrite=" + overwrite + ", bufferSize=" + bufSize + ", replication=" + replication + ", blockSize=" + blockSize + ']'));
                                        }
                                    }
                                });
                            }
                            if (GridGgfsMetaManager.this.evts.isRecordable(118)) {
                                pendingEvts.add(new GridGgfsEvent(path, GridGgfsMetaManager.this.locNode, 118));
                            }
                        }
                        if (GridGgfsMetaManager.this.evts.isRecordable(116)) {
                            pendingEvts.add(new GridGgfsEvent(path, GridGgfsMetaManager.this.locNode, 116));
                        }
                        return new GridGgfsSecondaryOutputStreamDescriptor(parentInfo.id(), newInfo, this.out);
                    }

                    @Override
                    public GridGgfsSecondaryOutputStreamDescriptor onFailure(Exception err) throws GridException {
                        U.closeQuiet((Closeable)this.out);
                        U.error((GridLogger)GridGgfsMetaManager.this.log, (Object)("File create in DUAL mode failed [path=" + path + ", simpleCreate=" + simpleCreate + ", permission=" + perm + ", overwrite=" + overwrite + ", bufferSize=" + bufSize + ", replication=" + replication + ", blockSize=" + blockSize + ']'), (Throwable)err);
                        if (err instanceof GridGgfsException) {
                            throw (GridGgfsException)err;
                        }
                        throw new GridGgfsException("Failed to create the file due to secondary file system exception: " + path, (Throwable)err);
                    }
                };
                try {
                    gridGgfsSecondaryOutputStreamDescriptor = this.synchronizeAndExecute(task, fs, false, path.parent());
                }
                catch (Throwable throwable) {
                    for (GridGgfsEvent evt : pendingEvts) {
                        this.evts.record((GridEvent)evt);
                    }
                    throw throwable;
                }
                for (GridGgfsEvent evt : pendingEvts) {
                    this.evts.record((GridEvent)evt);
                }
                return gridGgfsSecondaryOutputStreamDescriptor;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to create file in DUAL mode because Grid is stopping: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsSecondaryOutputStreamDescriptor appendDual(final FileSystem fs, final GridGgfsPath path, final int bufSize) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (fs != null);
                assert (path != null);
                SynchronizationTask<GridGgfsSecondaryOutputStreamDescriptor> task = new SynchronizationTask<GridGgfsSecondaryOutputStreamDescriptor>(){
                    private FSDataOutputStream out;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public GridGgfsSecondaryOutputStreamDescriptor onSuccess(Map<GridGgfsPath, GridGgfsFileInfo> infos) throws Exception {
                        int blockSize;
                        GridGgfsFileInfo info = infos.get(path);
                        if (info.isDirectory()) {
                            throw new GridGgfsException("Failed to open output stream to the file in the secondary file system because the path points to a directory: " + path);
                        }
                        Path path0 = GridGgfsMetaManager.this.secondaryPath(path);
                        this.out = fs.append(path0, bufSize);
                        long len = info.length();
                        int remainder = (int)(len % (long)(blockSize = info.blockSize()));
                        if (remainder > 0) {
                            int blockIdx = (int)(len / (long)blockSize);
                            try (GridGgfsSecondaryInputStreamWrapper wrapper = new GridGgfsSecondaryInputStreamWrapper(fs, path0, bufSize, GridGgfsMetaManager.this.log);){
                                GridGgfsMetaManager.this.ggfsCtx.data().dataBlock(info, path, blockIdx, wrapper).get();
                            }
                        }
                        info = GridGgfsMetaManager.this.lockInfo(info);
                        GridGgfsMetaManager.this.metaCache.putx((Object)info.id(), (Object)info, new GridPredicate[0]);
                        return new GridGgfsSecondaryOutputStreamDescriptor(infos.get(path.parent()).id(), info, this.out);
                    }

                    @Override
                    public GridGgfsSecondaryOutputStreamDescriptor onFailure(@Nullable Exception err) throws GridException {
                        U.closeQuiet((Closeable)this.out);
                        U.error((GridLogger)GridGgfsMetaManager.this.log, (Object)("File append in DUAL mode failed [path=" + path + ", bufferSize=" + bufSize + ']'), (Throwable)err);
                        if (err instanceof GridGgfsException) {
                            throw (GridGgfsException)err;
                        }
                        throw new GridException("Failed to append to the file due to secondary file system exception: " + path, (Throwable)err);
                    }
                };
                GridGgfsSecondaryOutputStreamDescriptor gridGgfsSecondaryOutputStreamDescriptor = this.synchronizeAndExecute(task, fs, true, path);
                return gridGgfsSecondaryOutputStreamDescriptor;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to append to file in DUAL mode because Grid is stopping: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsSecondaryInputStreamDescriptor openDual(final FileSystem fs, final GridGgfsPath path, final int bufSize) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (fs != null);
                assert (path != null);
                GridGgfsFileInfo info = this.info(this.fileId(path));
                if (info != null) {
                    if (!info.isFile()) {
                        throw new GridGgfsInvalidPathException("Failed to open file (not a file): " + path);
                    }
                    GridGgfsSecondaryInputStreamDescriptor gridGgfsSecondaryInputStreamDescriptor = new GridGgfsSecondaryInputStreamDescriptor(info, new GridGgfsSecondaryInputStreamWrapper(fs, this.secondaryPath(path), bufSize, this.log));
                    return gridGgfsSecondaryInputStreamDescriptor;
                }
                SynchronizationTask<GridGgfsSecondaryInputStreamDescriptor> task = new SynchronizationTask<GridGgfsSecondaryInputStreamDescriptor>(){

                    @Override
                    public GridGgfsSecondaryInputStreamDescriptor onSuccess(Map<GridGgfsPath, GridGgfsFileInfo> infos) throws Exception {
                        GridGgfsFileInfo info = infos.get(path);
                        if (info == null) {
                            throw new GridGgfsFileNotFoundException("File not found: " + path);
                        }
                        if (!info.isFile()) {
                            throw new GridGgfsInvalidPathException("Failed to open file (not a file): " + path);
                        }
                        return new GridGgfsSecondaryInputStreamDescriptor(infos.get(path), new GridGgfsSecondaryInputStreamWrapper(fs, GridGgfsMetaManager.this.secondaryPath(path), bufSize, GridGgfsMetaManager.this.log));
                    }

                    @Override
                    public GridGgfsSecondaryInputStreamDescriptor onFailure(@Nullable Exception err) throws GridException {
                        U.error((GridLogger)GridGgfsMetaManager.this.log, (Object)("File open in DUAL mode failed [path=" + path + ", bufferSize=" + bufSize + ']'), (Throwable)err);
                        if (err instanceof GridGgfsException) {
                            throw (GridException)((Object)err);
                        }
                        throw new GridException("Failed to open the path due to secondary file system exception: " + path, (Throwable)err);
                    }
                };
                GridGgfsSecondaryInputStreamDescriptor gridGgfsSecondaryInputStreamDescriptor = this.synchronizeAndExecute(task, fs, false, path);
                return gridGgfsSecondaryInputStreamDescriptor;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to open file in DUAL mode because Grid is stopping: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridGgfsFileInfo synchronizeFileDual(FileSystem fs, final GridGgfsPath path) throws GridException {
        assert (fs != null);
        assert (path != null);
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsFileInfo info = this.info(this.fileId(path));
                if (info != null) {
                    GridGgfsFileInfo gridGgfsFileInfo = info;
                    return gridGgfsFileInfo;
                }
                SynchronizationTask<GridGgfsFileInfo> task = new SynchronizationTask<GridGgfsFileInfo>(){

                    @Override
                    public GridGgfsFileInfo onSuccess(Map<GridGgfsPath, GridGgfsFileInfo> infos) throws Exception {
                        return infos.get(path);
                    }

                    @Override
                    public GridGgfsFileInfo onFailure(@Nullable Exception err) throws GridException {
                        if (err instanceof GridGgfsException) {
                            throw (GridException)((Object)err);
                        }
                        throw new GridException("Failed to synchronize path due to secondary file system exception: " + path, (Throwable)err);
                    }
                };
                GridGgfsFileInfo gridGgfsFileInfo = this.synchronizeAndExecute(task, fs, false, path);
                return gridGgfsFileInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to synchronize file because Grid is stopping: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirsDual(final FileSystem fs, final GridGgfsPath path, final Map<String, String> props) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                boolean bl;
                assert (fs != null);
                assert (path != null);
                assert (props != null);
                if (path.parent() == null) {
                    boolean bl2 = true;
                    return bl2;
                }
                final LinkedList pendingEvts = new LinkedList();
                SynchronizationTask<Boolean> task = new SynchronizationTask<Boolean>(){

                    @Override
                    public Boolean onSuccess(Map<GridGgfsPath, GridGgfsFileInfo> infos) throws Exception {
                        if (!fs.mkdirs(GridGgfsMetaManager.this.secondaryPath(path), new GridGgfsHdfsProperties(props).permission())) {
                            return false;
                        }
                        assert (!infos.isEmpty());
                        GridGgfsPath parentPath = null;
                        for (GridGgfsPath curPath : infos.keySet()) {
                            if (parentPath != null && !curPath.isSubDirectoryOf(parentPath)) continue;
                            parentPath = curPath;
                        }
                        assert (parentPath != null);
                        GridGgfsFileInfo parentPathInfo = infos.get(parentPath);
                        GridGgfsMetaManager.this.synchronize(fs, parentPath, parentPathInfo, path, true, null);
                        if (GridGgfsMetaManager.this.evts.isRecordable(124)) {
                            GridGgfsPath evtPath = path;
                            while (!parentPath.equals((Object)evtPath)) {
                                pendingEvts.addFirst(new GridGgfsEvent(evtPath, GridGgfsMetaManager.this.locNode, 124));
                                evtPath = evtPath.parent();
                                assert (evtPath != null);
                            }
                        }
                        return true;
                    }

                    @Override
                    public Boolean onFailure(@Nullable Exception err) throws GridException {
                        U.error((GridLogger)GridGgfsMetaManager.this.log, (Object)("Directory creation in DUAL mode failed [path=" + path + ", properties=" + props + ']'), (Throwable)err);
                        throw new GridException("Failed to create the path due to secondary file system exception: " + path, (Throwable)err);
                    }
                };
                try {
                    bl = this.synchronizeAndExecute(task, fs, false, path.parent());
                }
                catch (Throwable throwable) {
                    for (GridGgfsEvent evt : pendingEvts) {
                        this.evts.record((GridEvent)evt);
                    }
                    throw throwable;
                }
                for (GridGgfsEvent evt : pendingEvts) {
                    this.evts.record((GridEvent)evt);
                }
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to create directory in DUAL mode because Grid is stopping: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameDual(final FileSystem fs, final GridGgfsPath src, final GridGgfsPath dest) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                boolean bl;
                assert (fs != null);
                assert (src != null);
                assert (dest != null);
                if (src.parent() == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                final LinkedList pendingEvts = new LinkedList();
                SynchronizationTask<Boolean> task = new SynchronizationTask<Boolean>(){

                    @Override
                    public Boolean onSuccess(Map<GridGgfsPath, GridGgfsFileInfo> infos) throws Exception {
                        GridGgfsFileInfo destParentInfo;
                        GridGgfsFileInfo srcInfo = infos.get(src);
                        GridGgfsFileInfo srcParentInfo = infos.get(src.parent());
                        GridGgfsFileInfo destInfo = infos.get(dest);
                        GridGgfsFileInfo gridGgfsFileInfo = destParentInfo = dest.parent() != null ? infos.get(dest.parent()) : null;
                        if (srcInfo == null) {
                            throw new GridGgfsFileNotFoundException("Failed to rename (source path not found): " + src);
                        }
                        if (destInfo == null && destParentInfo == null) {
                            throw new GridGgfsFileNotFoundException("Failed to rename (destination path not found): " + dest);
                        }
                        if (!fs.rename(GridGgfsMetaManager.this.secondaryPath(src), GridGgfsMetaManager.this.secondaryPath(dest))) {
                            throw new GridGgfsException("Failed to rename (secondary file system returned false) [src=" + src + ", dest=" + dest + ']');
                        }
                        if (destInfo == null) {
                            assert (destParentInfo != null);
                            GridGgfsMetaManager.this.moveNonTx(srcInfo.id(), src.name(), srcParentInfo.id(), dest.name(), destParentInfo.id());
                        } else {
                            if (destInfo.isFile()) {
                                throw new GridGgfsException("Failed to rename the path in the local file system because destination path already exists and it is a file: " + dest);
                            }
                            GridGgfsMetaManager.this.moveNonTx(srcInfo.id(), src.name(), srcParentInfo.id(), src.name(), destInfo.id());
                        }
                        if (srcInfo.isFile()) {
                            if (GridGgfsMetaManager.this.evts.isRecordable(117)) {
                                pendingEvts.add(new GridGgfsEvent(src, destInfo == null ? dest : new GridGgfsPath(dest, src.name()), GridGgfsMetaManager.this.locNode, 117));
                            }
                        } else if (GridGgfsMetaManager.this.evts.isRecordable(125)) {
                            pendingEvts.add(new GridGgfsEvent(src, dest, GridGgfsMetaManager.this.locNode, 125));
                        }
                        return true;
                    }

                    @Override
                    public Boolean onFailure(@Nullable Exception err) throws GridException {
                        U.error((GridLogger)GridGgfsMetaManager.this.log, (Object)("Path rename in DUAL mode failed [source=" + src + ", destination=" + dest + ']'), (Throwable)err);
                        if (err instanceof GridGgfsException) {
                            throw (GridException)((Object)err);
                        }
                        throw new GridException("Failed to rename the path due to secondary file system exception: " + src, (Throwable)err);
                    }
                };
                try {
                    bl = this.synchronizeAndExecute(task, fs, false, src, dest);
                }
                catch (Throwable throwable) {
                    for (GridGgfsEvent evt : pendingEvts) {
                        this.evts.record((GridEvent)evt);
                    }
                    throw throwable;
                }
                for (GridGgfsEvent evt : pendingEvts) {
                    this.evts.record((GridEvent)evt);
                }
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to rename in DUAL mode because Grid is stopping [src=" + src + ", dest=" + dest + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDual(final FileSystem fs, final GridGgfsPath path, final boolean recursive) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                assert (fs != null);
                assert (path != null);
                SynchronizationTask<Boolean> task = new SynchronizationTask<Boolean>(){

                    @Override
                    public Boolean onSuccess(Map<GridGgfsPath, GridGgfsFileInfo> infos) throws Exception {
                        GridGgfsFileInfo info = infos.get(path);
                        if (info == null) {
                            return false;
                        }
                        if (!fs.delete(GridGgfsMetaManager.this.secondaryPath(path), recursive)) {
                            return false;
                        }
                        if (path.parent() != null) {
                            assert (infos.containsKey(path.parent()));
                            GridGgfsMetaManager.this.softDeleteNonTx(infos.get(path.parent()).id(), path.name(), info.id());
                        } else {
                            assert (GridGgfsFileInfo.ROOT_ID.equals((Object)info.id()));
                            GridGgfsMetaManager.this.softDeleteNonTx(null, path.name(), info.id());
                        }
                        GridGgfsMetaManager.this.id2InfoPrj.transform((Object)info.id(), (GridClosure)new UpdatePath(path));
                        return true;
                    }

                    @Override
                    public Boolean onFailure(@Nullable Exception err) throws GridException {
                        U.error((GridLogger)GridGgfsMetaManager.this.log, (Object)("Path delete in DUAL mode failed [path=" + path + ", recursive=" + recursive + ']'), (Throwable)err);
                        throw new GridException("Failed to delete the path due to secondary file system exception: ", (Throwable)err);
                    }
                };
                Boolean res = this.synchronizeAndExecute(task, fs, false, Collections.singleton(GridGgfsFileInfo.TRASH_ID), path);
                this.delWorker.signal();
                boolean bl = res;
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to delete in DUAL mode because Grid is stopping: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsFileInfo updateDual(final FileSystem fs, final GridGgfsPath path, final Map<String, String> props) throws GridException {
        assert (fs != null);
        assert (path != null);
        assert (props != null && !props.isEmpty());
        if (this.busyLock.enterBusy()) {
            try {
                SynchronizationTask<GridGgfsFileInfo> task = new SynchronizationTask<GridGgfsFileInfo>(){

                    @Override
                    public GridGgfsFileInfo onSuccess(Map<GridGgfsPath, GridGgfsFileInfo> infos) throws Exception {
                        if (infos.get(path) == null) {
                            return null;
                        }
                        Path secondaryPath = GridGgfsMetaManager.this.secondaryPath(path);
                        GridGgfsHdfsProperties props0 = new GridGgfsHdfsProperties(props);
                        if (props0.userName() != null || props0.groupName() != null) {
                            fs.setOwner(secondaryPath, props0.userName(), props0.groupName());
                        }
                        if (props0.permission() != null) {
                            fs.setPermission(secondaryPath, props0.permission());
                        }
                        assert (path.parent() == null || infos.get(path.parent()) != null);
                        return GridGgfsMetaManager.this.updatePropertiesNonTx(infos.get(path.parent()).id(), infos.get(path).id(), path.name(), props);
                    }

                    @Override
                    public GridGgfsFileInfo onFailure(@Nullable Exception err) throws GridException {
                        U.error((GridLogger)GridGgfsMetaManager.this.log, (Object)("Path update in DUAL mode failed [path=" + path + ", properties=" + props + ']'), (Throwable)err);
                        throw new GridException("Failed to update the path due to secondary file system exception: " + path, (Throwable)err);
                    }
                };
                GridGgfsFileInfo gridGgfsFileInfo = this.synchronizeAndExecute(task, fs, false, path);
                return gridGgfsFileInfo;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to update in DUAL mode because Grid is stopping: " + path);
    }

    private GridGgfsFileInfo synchronize(FileSystem fs, GridGgfsPath startPath, GridGgfsFileInfo startPathInfo, GridGgfsPath endPath, boolean strict, @Nullable Map<GridGgfsPath, GridGgfsFileInfo> created) throws GridException {
        assert (fs != null);
        assert (startPath != null && startPathInfo != null && endPath != null);
        this.validTxState(true);
        GridGgfsFileInfo parentInfo = startPathInfo;
        List components = endPath.components();
        GridGgfsPath curPath = startPath;
        for (int i = startPath.components().size(); i < components.size(); ++i) {
            curPath = new GridGgfsPath(curPath, (String)components.get(i));
            if (created != null && created.containsKey(curPath)) {
                parentInfo = created.get(curPath);
                continue;
            }
            FileStatus status = null;
            IOException err = null;
            try {
                status = fs.getFileStatus(this.secondaryPath(curPath));
            }
            catch (IOException e) {
                err = e;
            }
            if (status != null) {
                if (!status.isDir() && !curPath.equals((Object)endPath)) {
                    throw new GridException("Failed to create path the locally because secondary file system directory structure was modified concurrently and the path is not a directory as expected: " + curPath);
                }
            } else {
                if (strict) {
                    throw new GridException("Failed to create path locally due to secondary file system exception: " + curPath, (Throwable)err);
                }
                if (created != null) {
                    created.put(curPath.parent(), parentInfo);
                }
                return null;
            }
            GridGgfsFileInfo curInfo = status.isDir() ? new GridGgfsFileInfo(true, this.properties(status)) : new GridGgfsFileInfo(this.ggfsCtx.configuration().getBlockSize(), status.getLen(), this.ggfsCtx.ggfs().evictExclude(curPath, false), this.properties(status));
            GridGgfsFileInfo newCurInfo = this.putIfAbsentNonTx(parentInfo.id(), (String)components.get(i), curInfo);
            if (newCurInfo != null) {
                curInfo = newCurInfo;
            }
            if (created != null) {
                created.put(curPath, curInfo);
            }
            parentInfo = curInfo;
        }
        return parentInfo;
    }

    private <T> T synchronizeAndExecute(SynchronizationTask<T> task, FileSystem fs, boolean strict, GridGgfsPath ... paths) throws GridException {
        return this.synchronizeAndExecute(task, fs, strict, (Collection<GridUuid>)null, paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T synchronizeAndExecute(SynchronizationTask<T> task, FileSystem fs, boolean strict, @Nullable Collection<GridUuid> extraLockIds, GridGgfsPath ... paths) throws GridException {
        assert (task != null);
        assert (fs != null);
        assert (paths != null && paths.length > 0);
        if (paths.length > 1) {
            Arrays.sort(paths);
        }
        boolean finished = false;
        T res = null;
        while (!finished) {
            ArrayList<List<GridUuid>> pathIds = new ArrayList<List<GridUuid>>(paths.length);
            for (GridGgfsPath path : paths) {
                pathIds.add(this.fileIds(path));
            }
            try (GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);){
                boolean changed;
                HashMap<GridGgfsPath, GridGgfsPath> pathToParent = new HashMap<GridGgfsPath, GridGgfsPath>();
                HashMap<GridGgfsPath, GridUuid> pathToId = new HashMap<GridGgfsPath, GridUuid>();
                for (int i = 0; i < paths.length; ++i) {
                    GridUuid pathId;
                    GridGgfsPath path = paths[i];
                    List ids = (List)pathIds.get(i);
                    if (ids.size() > 1) {
                        GridGgfsPath parentPath = path.parent();
                        GridUuid parentId = (GridUuid)ids.get(ids.size() - 2);
                        for (int j = ids.size() - 3; j >= 0 && parentId == null; --j) {
                            parentPath = parentPath.parent();
                            parentId = (GridUuid)ids.get(j);
                        }
                        assert (parentPath != null && parentId != null);
                        pathToParent.put(path, parentPath);
                        pathToId.put(parentPath, parentId);
                    }
                    if ((pathId = (GridUuid)ids.get(ids.size() - 1)) == null) continue;
                    pathToId.put(path, pathId);
                }
                GridUuid[] lockArr = new GridUuid[extraLockIds == null ? pathToId.size() : pathToId.size() + extraLockIds.size()];
                int idx = 0;
                for (GridUuid id : pathToId.values()) {
                    lockArr[idx++] = id;
                }
                if (extraLockIds != null) {
                    for (GridUuid id : extraLockIds) {
                        lockArr[idx++] = id;
                    }
                }
                Map<GridUuid, GridGgfsFileInfo> idToInfo = this.lockIds(lockArr);
                if (extraLockIds != null) {
                    for (GridUuid id : extraLockIds) {
                        idToInfo.remove(id);
                    }
                }
                boolean bl = changed = idToInfo.size() != pathToId.size();
                if (!changed) {
                    for (Map.Entry entry : pathToId.entrySet()) {
                        if (((GridUuid)entry.getValue()).equals((Object)this.fileId((GridGgfsPath)entry.getKey(), true))) continue;
                        changed = true;
                        break;
                    }
                }
                if (changed) {
                    finished = true;
                    throw new GridGgfsConcurrentModificationException();
                }
                boolean newParents = false;
                for (int i = 0; i < paths.length; ++i) {
                    List<GridUuid> newIds = this.fileIds(paths[i], true);
                    if (((List)pathIds.get(i)).equals(newIds)) continue;
                    newParents = true;
                    break;
                }
                if (newParents) continue;
                HashMap<GridGgfsPath, GridGgfsFileInfo> infos = new HashMap<GridGgfsPath, GridGgfsFileInfo>();
                TreeMap<GridGgfsPath, GridGgfsFileInfo> created = new TreeMap<GridGgfsPath, GridGgfsFileInfo>();
                for (GridGgfsPath path : paths) {
                    GridGgfsPath parentPath = path.parent();
                    if (pathToId.containsKey(path)) {
                        infos.put(path, this.info((GridUuid)pathToId.get(path)));
                        if (parentPath == null) continue;
                        infos.put(parentPath, this.info((GridUuid)pathToId.get(parentPath)));
                        continue;
                    }
                    GridGgfsPath firstParentPath = (GridGgfsPath)pathToParent.get(path);
                    assert (firstParentPath != null);
                    assert (pathToId.get(firstParentPath) != null);
                    GridGgfsFileInfo info = this.synchronize(fs, firstParentPath, idToInfo.get(pathToId.get(firstParentPath)), path, strict, created);
                    assert (strict && info != null || !strict);
                    if (info != null) {
                        infos.put(path, info);
                    }
                    if (parentPath == null) continue;
                    if (parentPath.equals((Object)firstParentPath)) {
                        infos.put(firstParentPath, idToInfo.get(pathToId.get(firstParentPath)));
                        continue;
                    }
                    assert (strict && created.get(parentPath) != null || !strict);
                    if (created.get(parentPath) != null) {
                        infos.put(parentPath, created.get(parentPath));
                        continue;
                    }
                    infos.put(created.lastKey(), created.get(created.lastKey()));
                }
                finished = true;
                try {
                    res = task.onSuccess(infos);
                }
                catch (Exception e) {
                    res = task.onFailure(e);
                }
                tx.commit();
            }
        }
        return res;
    }

    private <K, V> boolean putx(GridCacheProjection<K, V> cache, K key, GridClosure<V, V> c) throws GridException {
        assert (this.validTxState(true));
        Object oldVal = cache.get(key);
        Object newVal = c.apply(oldVal);
        return newVal == null ? cache.removex(key, new GridPredicate[0]) : cache.putx(key, newVal, new GridPredicate[0]);
    }

    private boolean validTxState(boolean inTx) {
        boolean txState;
        boolean bl = txState = inTx == (this.metaCache.tx() != null);
        assert (txState) : (inTx ? "Method cannot be called outside transaction " : "Method cannot be called in transaction ") + "[tx=" + this.metaCache.tx() + ", threadId=" + Thread.currentThread().getId() + ']';
        return txState;
    }

    private Map<String, String> properties(FileStatus status) {
        FsPermission perm = status.getPermission();
        if (perm == null) {
            perm = FsPermission.getDefault();
        }
        return F.asMap((Object)"permission", (Object)String.format("%04o", perm.toShort()), (Object)"usrName", (Object)status.getOwner(), (Object)"grpName", (Object)status.getGroup());
    }

    private Path secondaryPath(GridGgfsPath path) {
        assert (path != null);
        assert (this.cfg.getSecondaryHadoopFileSystemUri() != null);
        return new Path(this.cfg.getSecondaryHadoopFileSystemUri() + path.toString().substring(path.root().toString().length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimes(GridUuid parentId, GridUuid fileId, String fileName, long accessTime, long modificationTime) throws GridException {
        block12: {
            if (this.busyLock.enterBusy()) {
                try {
                    assert (this.validTxState(false));
                    try (GridCacheTx tx = this.metaCache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);){
                        Map<GridUuid, GridGgfsFileInfo> infoMap = this.lockIds(fileId, parentId);
                        GridGgfsFileInfo fileInfo = infoMap.get(fileId);
                        if (fileInfo == null) {
                            throw new GridGgfsFileNotFoundException("Failed to update times (path was not found): " + fileName);
                        }
                        GridGgfsFileInfo parentInfo = infoMap.get(parentId);
                        if (parentInfo == null) {
                            throw new GridGgfsInvalidPathException("Failed to update times (parent was not found): " + fileName);
                        }
                        GridGgfsListingEntry entry = parentInfo.listing().get(fileName);
                        if (entry == null || !entry.fileId().equals((Object)fileId)) {
                            throw new GridGgfsInvalidPathException("Failed to update times (file concurrently modified): " + fileName);
                        }
                        assert (parentInfo.isDirectory());
                        GridGgfsFileInfo updated = new GridGgfsFileInfo(fileInfo, accessTime == -1L ? fileInfo.accessTime() : accessTime, modificationTime == -1L ? fileInfo.modificationTime() : modificationTime);
                        this.id2InfoPrj.putx((Object)fileId, (Object)updated, new GridPredicate[0]);
                        this.id2InfoPrj.transform((Object)parentId, (GridClosure)new UpdateListingEntry(fileId, fileName, 0L, accessTime, modificationTime));
                        tx.commit();
                        break block12;
                    }
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            }
            throw new IllegalStateException("Failed to update times because Grid is stopping [parentId=" + parentId + ", fileId=" + fileId + ", fileName=" + fileName + ']');
        }
    }

    @GridInternal
    private static final class UpdatePath
    implements GridClosure<GridGgfsFileInfo, GridGgfsFileInfo>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private GridGgfsPath path;

        private UpdatePath(GridGgfsPath path) {
            this.path = path;
        }

        public UpdatePath() {
        }

        public GridGgfsFileInfo apply(GridGgfsFileInfo info) {
            return GridGgfsFileInfo.builder(info).path(this.path).build();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.path);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.path = (GridGgfsPath)in.readObject();
        }

        public String toString() {
            return S.toString(UpdatePath.class, (Object)this);
        }
    }

    @GridInternal
    private static final class UpdateListing
    implements GridClosure<GridGgfsFileInfo, GridGgfsFileInfo>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private String fileName;
        private GridGgfsListingEntry entry;
        private boolean rmv;

        private UpdateListing(String fileName, GridGgfsListingEntry entry, boolean rmv) {
            assert (fileName != null);
            assert (entry != null);
            this.fileName = fileName;
            this.entry = entry;
            this.rmv = rmv;
        }

        public UpdateListing() {
        }

        @Nullable
        public GridGgfsFileInfo apply(GridGgfsFileInfo fileInfo) {
            assert (fileInfo != null) : "File info not found for the child: " + this.entry.fileId();
            assert (fileInfo.isDirectory());
            HashMap<String, GridGgfsListingEntry> listing = new HashMap<String, GridGgfsListingEntry>(fileInfo.listing().size() + (this.rmv ? 0 : 1));
            listing.putAll(fileInfo.listing());
            if (this.rmv) {
                GridGgfsListingEntry oldEntry = (GridGgfsListingEntry)listing.get(this.fileName);
                if (oldEntry == null || !oldEntry.fileId().equals((Object)this.entry.fileId())) {
                    throw new GridRuntimeException("Directory listing doesn't contain expected file [listing=" + listing + ", fileName=" + this.fileName + ", entry=" + this.entry + ']');
                }
                listing.remove(this.fileName);
            } else {
                GridGgfsListingEntry oldEntry = listing.put(this.fileName, this.entry);
                if (oldEntry != null && !oldEntry.fileId().equals((Object)this.entry.fileId())) {
                    throw new GridRuntimeException("Directory listing contains unexpected file [listing=" + listing + ", fileName=" + this.fileName + ", entry=" + this.entry + ", oldEntry=" + oldEntry + ']');
                }
            }
            return new GridGgfsFileInfo(listing, fileInfo);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.fileName);
            out.writeObject(this.entry);
            out.writeBoolean(this.rmv);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.fileName = U.readString((DataInput)in);
            this.entry = (GridGgfsListingEntry)in.readObject();
            this.rmv = in.readBoolean();
        }

        public String toString() {
            return S.toString(UpdateListing.class, (Object)this);
        }
    }

    private static final class UpdateListingEntry
    implements GridClosure<GridGgfsFileInfo, GridGgfsFileInfo>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private String fileName;
        private GridUuid fileId;
        private long lenDelta;
        private long accessTime;
        private long modificationTime;

        public UpdateListingEntry() {
        }

        private UpdateListingEntry(GridUuid fileId, String fileName, long lenDelta, long accessTime, long modificationTime) {
            this.fileId = fileId;
            this.fileName = fileName;
            this.lenDelta = lenDelta;
            this.accessTime = accessTime;
            this.modificationTime = modificationTime;
        }

        public GridGgfsFileInfo apply(GridGgfsFileInfo fileInfo) {
            Map<String, GridGgfsListingEntry> listing = fileInfo.listing();
            GridGgfsListingEntry entry = listing.get(this.fileName);
            if (entry == null || !entry.fileId().equals((Object)this.fileId)) {
                return fileInfo;
            }
            entry = new GridGgfsListingEntry(entry, entry.length() + this.lenDelta, this.accessTime == -1L ? entry.accessTime() : this.accessTime, this.modificationTime == -1L ? entry.modificationTime() : this.modificationTime);
            listing = new HashMap<String, GridGgfsListingEntry>(listing);
            listing.put(this.fileName, entry);
            return new GridGgfsFileInfo(listing, fileInfo);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeGridUuid((DataOutput)out, (GridUuid)this.fileId);
            out.writeUTF(this.fileName);
            out.writeLong(this.lenDelta);
            out.writeLong(this.accessTime);
            out.writeLong(this.modificationTime);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.fileId = U.readGridUuid((DataInput)in);
            this.fileName = in.readUTF();
            this.lenDelta = in.readLong();
            this.accessTime = in.readLong();
            this.modificationTime = in.readLong();
        }
    }

    private static class PathDescriptor {
        private final GridGgfsPath path;
        private final List<GridUuid> ids;
        private GridGgfsPath parentPath;
        private GridGgfsFileInfo parentInfo;

        PathDescriptor(GridGgfsPath path, List<GridUuid> ids, GridGgfsPath parentPath, GridGgfsFileInfo parentInfo) {
            assert (path != null);
            assert (ids != null && !ids.isEmpty());
            assert (parentPath == null && parentInfo == null || parentPath != null && parentInfo != null);
            assert (parentPath == null || parentPath != null && path.isSubDirectoryOf(parentPath));
            this.path = path;
            this.ids = ids;
            this.parentPath = parentPath;
            this.parentInfo = parentInfo;
        }

        private Collection<GridUuid> ids() {
            return this.ids;
        }

        private GridUuid endId(int i) {
            return this.ids.get(this.ids.size() - i);
        }

        private void updateParent(GridGgfsPath newParentPath, GridGgfsFileInfo newParentInfo) {
            assert (newParentPath != null);
            assert (newParentInfo != null);
            assert (this.path.isSubDirectoryOf(newParentPath));
            this.parentPath = newParentPath;
            this.parentInfo = newParentInfo;
            this.ids.set(newParentPath.components().size(), newParentInfo.id());
        }

        private GridGgfsPath parentPath() {
            return this.parentPath;
        }

        private GridGgfsFileInfo parentInfo() {
            return this.parentInfo;
        }
    }

    private static interface SynchronizationTask<T> {
        public T onSuccess(Map<GridGgfsPath, GridGgfsFileInfo> var1) throws Exception;

        public T onFailure(Exception var1) throws GridException;
    }
}

