/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.gridgain.grid.ggfs.GridGgfsMetrics;
import org.gridgain.grid.util.typedef.internal.S;

public class GridGgfsMetricsAdapter
implements GridGgfsMetrics,
Externalizable {
    private static final long serialVersionUID = 0L;
    private long locSpaceSize;
    private long maxSpaceSize;
    private long secondarySpaceSize;
    private int dirsCnt;
    private int filesCnt;
    private int filesOpenedForRead;
    private int filesOpenedForWrite;
    private long blocksReadTotal;
    private long blocksReadRmt;
    private long blocksWrittenTotal;
    private long blocksWrittenRmt;
    private long bytesRead;
    private long bytesReadTime;
    private long bytesWritten;
    private long bytesWriteTime;

    public GridGgfsMetricsAdapter() {
    }

    public GridGgfsMetricsAdapter(long locSpaceSize, long maxSpaceSize, long secondarySpaceSize, int dirsCnt, int filesCnt, int filesOpenedForRead, int filesOpenedForWrite, long blocksReadTotal, long blocksReadRmt, long blocksWrittenTotal, long blocksWrittenRmt, long bytesRead, long bytesReadTime, long bytesWritten, long bytesWriteTime) {
        this.locSpaceSize = locSpaceSize;
        this.maxSpaceSize = maxSpaceSize;
        this.secondarySpaceSize = secondarySpaceSize;
        this.dirsCnt = dirsCnt;
        this.filesCnt = filesCnt;
        this.filesOpenedForRead = filesOpenedForRead;
        this.filesOpenedForWrite = filesOpenedForWrite;
        this.blocksReadTotal = blocksReadTotal;
        this.blocksReadRmt = blocksReadRmt;
        this.blocksWrittenTotal = blocksWrittenTotal;
        this.blocksWrittenRmt = blocksWrittenRmt;
        this.bytesRead = bytesRead;
        this.bytesReadTime = bytesReadTime;
        this.bytesWritten = bytesWritten;
        this.bytesWriteTime = bytesWriteTime;
    }

    public long localSpaceSize() {
        return this.locSpaceSize;
    }

    public long maxSpaceSize() {
        return this.maxSpaceSize;
    }

    public long secondarySpaceSize() {
        return this.secondarySpaceSize;
    }

    public int directoriesCount() {
        return this.dirsCnt;
    }

    public int filesCount() {
        return this.filesCnt;
    }

    public int filesOpenedForRead() {
        return this.filesOpenedForRead;
    }

    public int filesOpenedForWrite() {
        return this.filesOpenedForWrite;
    }

    public long blocksReadTotal() {
        return this.blocksReadTotal;
    }

    public long blocksReadRemote() {
        return this.blocksReadRmt;
    }

    public long blocksWrittenTotal() {
        return this.blocksWrittenTotal;
    }

    public long blocksWrittenRemote() {
        return this.blocksWrittenRmt;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public long bytesReadTime() {
        return this.bytesReadTime;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public long bytesWriteTime() {
        return this.bytesWriteTime;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.locSpaceSize);
        out.writeLong(this.maxSpaceSize);
        out.writeLong(this.secondarySpaceSize);
        out.writeInt(this.dirsCnt);
        out.writeInt(this.filesCnt);
        out.writeInt(this.filesOpenedForRead);
        out.writeInt(this.filesOpenedForWrite);
        out.writeLong(this.blocksReadTotal);
        out.writeLong(this.blocksReadRmt);
        out.writeLong(this.blocksWrittenTotal);
        out.writeLong(this.blocksWrittenRmt);
        out.writeLong(this.bytesRead);
        out.writeLong(this.bytesReadTime);
        out.writeLong(this.bytesWritten);
        out.writeLong(this.bytesWriteTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.locSpaceSize = in.readLong();
        this.maxSpaceSize = in.readLong();
        this.secondarySpaceSize = in.readLong();
        this.dirsCnt = in.readInt();
        this.filesCnt = in.readInt();
        this.filesOpenedForRead = in.readInt();
        this.filesOpenedForWrite = in.readInt();
        this.blocksReadTotal = in.readLong();
        this.blocksReadRmt = in.readLong();
        this.blocksWrittenTotal = in.readLong();
        this.blocksWrittenRmt = in.readLong();
        this.bytesRead = in.readLong();
        this.bytesReadTime = in.readLong();
        this.bytesWritten = in.readLong();
        this.bytesWriteTime = in.readLong();
    }

    public String toString() {
        return S.toString(GridGgfsMetricsAdapter.class, (Object)this);
    }
}

