/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.util.GridBoundedConcurrentLinkedHashMap;
import org.gridgain.grid.util.typedef.T2;
import org.jetbrains.annotations.Nullable;

public class GridGgfsModeResolver {
    private static final int MAX_PATH_CACHE = 1000;
    private final GridGgfsMode dfltMode;
    private ArrayList<T2<GridGgfsPath, GridGgfsMode>> modes;
    private Map<GridGgfsPath, GridGgfsMode> modesCache;
    private Map<GridGgfsPath, Set<GridGgfsMode>> childrenModesCache;

    public GridGgfsModeResolver(GridGgfsMode dfltMode, @Nullable List<T2<GridGgfsPath, GridGgfsMode>> modes) {
        assert (dfltMode != null);
        this.dfltMode = dfltMode;
        if (modes != null) {
            ArrayList<T2<GridGgfsPath, GridGgfsMode>> modes0 = new ArrayList<T2<GridGgfsPath, GridGgfsMode>>(modes);
            Collections.sort(modes0, new Comparator<Map.Entry<GridGgfsPath, GridGgfsMode>>(){

                @Override
                public int compare(Map.Entry<GridGgfsPath, GridGgfsMode> o1, Map.Entry<GridGgfsPath, GridGgfsMode> o2) {
                    return o2.getKey().components().size() - o1.getKey().components().size();
                }
            });
            this.modes = modes0;
            this.modesCache = new GridBoundedConcurrentLinkedHashMap(1000);
            this.childrenModesCache = new GridBoundedConcurrentLinkedHashMap(1000);
        }
    }

    public GridGgfsMode resolveMode(GridGgfsPath path) {
        assert (path != null);
        if (this.modes == null) {
            return this.dfltMode;
        }
        GridGgfsMode mode = this.modesCache.get(path);
        if (mode == null) {
            for (T2<GridGgfsPath, GridGgfsMode> entry : this.modes) {
                if (!GridGgfsModeResolver.startsWith(path, (GridGgfsPath)entry.getKey())) continue;
                mode = (GridGgfsMode)entry.getValue();
                break;
            }
            if (mode == null) {
                mode = this.dfltMode;
            }
            this.modesCache.put(path, mode);
        }
        return mode;
    }

    public Set<GridGgfsMode> resolveChildrenModes(GridGgfsPath path) {
        assert (path != null);
        if (this.modes == null) {
            return Collections.singleton(this.dfltMode);
        }
        Set<GridGgfsMode> children = this.childrenModesCache.get(path);
        if (children == null) {
            children = new HashSet<GridGgfsMode>(GridGgfsMode.values().length, 1.0f);
            GridGgfsMode pathDefault = this.dfltMode;
            for (T2<GridGgfsPath, GridGgfsMode> child : this.modes) {
                if (GridGgfsModeResolver.startsWith(path, (GridGgfsPath)child.getKey())) {
                    pathDefault = (GridGgfsMode)child.getValue();
                    break;
                }
                if (!GridGgfsModeResolver.startsWith((GridGgfsPath)child.getKey(), path)) continue;
                children.add((GridGgfsMode)child.getValue());
            }
            children.add(pathDefault);
            this.childrenModesCache.put(path, children);
        }
        return children;
    }

    @Nullable
    public List<T2<GridGgfsPath, GridGgfsMode>> modesOrdered() {
        return this.modes != null ? Collections.unmodifiableList(this.modes) : null;
    }

    private static boolean startsWith(GridGgfsPath path, GridGgfsPath prefix) {
        List p1Comps = path.components();
        List p2Comps = prefix.components();
        if (p2Comps.size() > p1Comps.size()) {
            return false;
        }
        for (int i = 0; i < p1Comps.size(); ++i) {
            if (i >= p2Comps.size() || p2Comps.get(i) == null) {
                return true;
            }
            if (((String)p1Comps.get(i)).equals(p2Comps.get(i))) continue;
            return false;
        }
        return true;
    }
}

