/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.gridgain.grid.GridException;
import org.gridgain.grid.ggfs.GridGgfsOutputStream;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

abstract class GridGgfsOutputStreamAdapter
extends GridGgfsOutputStream {
    protected final GridGgfsPath path;
    private final int bufSize;
    private boolean closed;
    private ByteBuffer buf;
    protected long bytes;
    protected long time;

    GridGgfsOutputStreamAdapter(GridGgfsPath path, int bufSize) {
        assert (path != null);
        assert (bufSize > 0);
        this.path = path;
        this.bufSize = bufSize;
    }

    public long bytes() {
        return this.bytes;
    }

    public synchronized void write(int b) throws IOException {
        this.checkClosed(null, 0);
        long startTime = System.nanoTime();
        b &= 0xFF;
        if (this.buf == null) {
            this.buf = ByteBuffer.allocate(this.bufSize);
        }
        this.buf.put((byte)b);
        if (this.buf.position() >= this.bufSize) {
            this.sendData(true);
        }
        this.time += System.nanoTime() - startTime;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        A.notNull((Object)b, (String)"b");
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("Invalid bounds [data.length=" + b.length + ", offset=" + off + ", length=" + len + ']');
        }
        this.checkClosed(null, 0);
        if (len == 0) {
            return;
        }
        long startTime = System.nanoTime();
        if (this.buf == null) {
            if (len >= this.bufSize) {
                this.buf = ByteBuffer.wrap(b, off, len);
                this.sendData(false);
                return;
            }
            this.buf = ByteBuffer.allocate(Math.max(this.bufSize, len));
        }
        if (this.buf.remaining() < len) {
            this.buf = ByteBuffer.allocate(this.buf.position() + len).put((ByteBuffer)this.buf.flip());
        }
        assert (len <= this.buf.remaining()) : "Expects write data size less or equal then remaining buffer capacity [len=" + len + ", buf.remaining=" + this.buf.remaining() + ']';
        this.buf.put(b, off, len);
        if (this.buf.position() >= this.bufSize) {
            this.sendData(true);
        }
        this.time += System.nanoTime() - startTime;
    }

    public synchronized void transferFrom(DataInput in, int len) throws IOException {
        this.checkClosed(in, len);
        long startTime = System.nanoTime();
        if (this.buf != null && this.buf.position() > 0) {
            this.sendData(true);
        }
        try {
            this.storeDataBlocks(in, len);
        }
        catch (GridException e) {
            throw new IOException(e.getMessage(), e);
        }
        this.time += System.nanoTime() - startTime;
    }

    public synchronized void flush() throws IOException {
        this.checkClosed(null, 0);
        if (this.buf != null && this.buf.position() > 0) {
            this.sendData(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            try {
                this.flush();
            }
            finally {
                this.onClose();
            }
        }
        finally {
            this.closed = true;
        }
    }

    protected abstract void storeDataBlock(ByteBuffer var1) throws GridException, IOException;

    protected abstract void storeDataBlocks(DataInput var1, int var2) throws GridException, IOException;

    protected void onClose() throws IOException {
    }

    private void checkClosed(@Nullable DataInput in, int len) throws IOException {
        assert (Thread.holdsLock((Object)this));
        if (this.closed) {
            if (in != null) {
                in.skipBytes(len);
            }
            throw new IOException("Stream has been closed: " + (Object)((Object)this));
        }
    }

    private void sendData(boolean flip) throws IOException {
        assert (Thread.holdsLock((Object)this));
        try {
            if (flip) {
                this.buf.flip();
            }
            this.storeDataBlock(this.buf);
        }
        catch (GridException e) {
            throw new IOException("Failed to store data into file: " + this.path, e);
        }
        this.buf = null;
    }

    public String toString() {
        return S.toString(GridGgfsOutputStreamAdapter.class, (Object)((Object)this));
    }
}

