/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.Externalizable;
import java.io.IOError;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.ggfs.GridGgfsException;
import org.gridgain.grid.ggfs.GridGgfsFileNotFoundException;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsContext;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDataManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileAffinityRange;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileInfo;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileMap;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileWorkerBatch;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsLocalMetrics;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsMetaManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsOutputStreamAdapter;
import org.gridgain.grid.kernal.processors.task.GridInternal;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.util.future.GridFutureAdapter;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class GridGgfsOutputStreamImpl
extends GridGgfsOutputStreamAdapter {
    private static final int MAX_BLOCKS_CNT = 16;
    private GridGgfsContext ggfsCtx;
    private final GridGgfsMetaManager meta;
    private final GridGgfsDataManager data;
    private GridGgfsFileInfo fileInfo;
    private final GridUuid parentId;
    private final String fileName;
    private long space;
    private byte[] remainder;
    private int remainderDataLen;
    private final GridFuture<Boolean> writeCompletionFut;
    private final GridGgfsMode mode;
    private final GridGgfsFileWorkerBatch batch;
    private final AtomicBoolean onCloseGuard = new AtomicBoolean();
    private final GridGgfsLocalMetrics metrics;
    private GridGgfsFileAffinityRange streamRange;

    GridGgfsOutputStreamImpl(GridGgfsContext ggfsCtx, GridGgfsPath path, GridGgfsFileInfo fileInfo, GridUuid parentId, int bufSize, GridGgfsMode mode, @Nullable GridGgfsFileWorkerBatch batch, GridGgfsLocalMetrics metrics) throws GridException {
        super(path, GridGgfsOutputStreamImpl.optimizeBufferSize(bufSize, fileInfo));
        assert (fileInfo != null);
        assert (fileInfo.isFile()) : "Unexpected file info: " + fileInfo;
        assert (mode != null && mode != GridGgfsMode.PROXY);
        assert (mode == GridGgfsMode.PRIMARY && batch == null || batch != null);
        assert (metrics != null);
        if (fileInfo.lockId() == null) {
            throw new GridGgfsException("Failed to acquire file lock (concurrently modified?): " + path);
        }
        this.ggfsCtx = ggfsCtx;
        this.meta = ggfsCtx.meta();
        this.data = ggfsCtx.data();
        this.fileInfo = fileInfo;
        this.mode = mode;
        this.batch = batch;
        this.parentId = parentId;
        this.metrics = metrics;
        this.streamRange = this.initialStreamRange(fileInfo);
        this.fileName = path.name();
        this.writeCompletionFut = this.data.writeStart(fileInfo);
    }

    private static int optimizeBufferSize(int bufSize, GridGgfsFileInfo fileInfo) {
        assert (bufSize > 0);
        if (fileInfo == null) {
            return bufSize;
        }
        int blockSize = fileInfo.blockSize();
        if (blockSize <= 0) {
            return bufSize;
        }
        if (bufSize <= blockSize) {
            return blockSize;
        }
        int maxBufSize = blockSize * 16;
        if (bufSize > maxBufSize) {
            return maxBufSize;
        }
        if (fileInfo.length() == 0L) {
            return bufSize / blockSize * blockSize;
        }
        return bufSize;
    }

    @Override
    protected synchronized void storeDataBlock(ByteBuffer block) throws GridException, IOException {
        int writeLen = block.remaining();
        this.preStoreDataBlocks(null, writeLen);
        int blockSize = this.fileInfo.blockSize();
        if (this.remainderDataLen + writeLen < blockSize) {
            if (this.remainder == null) {
                this.remainder = new byte[blockSize];
            } else if (this.remainder.length != blockSize) {
                assert (this.remainderDataLen == this.remainder.length);
                byte[] allocated = new byte[blockSize];
                U.arrayCopy((byte[])this.remainder, (int)0, (byte[])allocated, (int)0, (int)this.remainder.length);
                this.remainder = allocated;
            }
            block.get(this.remainder, this.remainderDataLen, writeLen);
            this.remainderDataLen += writeLen;
        } else {
            this.remainder = this.data.storeDataBlocks(this.fileInfo, this.fileInfo.length() + this.space, this.remainder, this.remainderDataLen, block, false, this.streamRange, this.batch);
            this.remainderDataLen = this.remainder == null ? 0 : this.remainder.length;
        }
    }

    @Override
    protected synchronized void storeDataBlocks(DataInput in, int len) throws GridException, IOException {
        this.preStoreDataBlocks(in, len);
        int blockSize = this.fileInfo.blockSize();
        if (this.remainderDataLen + len < blockSize) {
            if (this.remainder == null) {
                this.remainder = new byte[blockSize];
            } else if (this.remainder.length != blockSize) {
                assert (this.remainderDataLen == this.remainder.length);
                byte[] allocated = new byte[blockSize];
                U.arrayCopy((byte[])this.remainder, (int)0, (byte[])allocated, (int)0, (int)this.remainder.length);
                this.remainder = allocated;
            }
            in.readFully(this.remainder, this.remainderDataLen, len);
            this.remainderDataLen += len;
        } else {
            this.remainder = this.data.storeDataBlocks(this.fileInfo, this.fileInfo.length() + this.space, this.remainder, this.remainderDataLen, in, len, false, this.streamRange, this.batch);
            this.remainderDataLen = this.remainder == null ? 0 : this.remainder.length;
        }
    }

    private void preStoreDataBlocks(@Nullable DataInput in, int len) throws GridException, IOException {
        if (this.writeCompletionFut.isDone()) {
            assert (((GridFutureAdapter)this.writeCompletionFut).isFailed());
            if (in != null) {
                in.skipBytes(len);
            }
            this.writeCompletionFut.get();
        }
        this.bytes += (long)len;
        this.space += (long)len;
    }

    @Override
    public synchronized void flush() throws IOException {
        boolean exists;
        try {
            exists = this.meta.exists(this.fileInfo.id());
        }
        catch (GridException e) {
            throw new IOError(e);
        }
        if (!exists) {
            this.onClose(true);
            throw new IOException("File was concurrently deleted: " + this.path);
        }
        super.flush();
        try {
            if (this.remainder != null) {
                this.data.storeDataBlocks(this.fileInfo, this.fileInfo.length() + this.space, null, 0, ByteBuffer.wrap(this.remainder, 0, this.remainderDataLen), true, this.streamRange, this.batch);
                this.remainder = null;
                this.remainderDataLen = 0;
            }
            if (this.space > 0L) {
                GridGgfsFileInfo fileInfo0 = this.meta.updateInfo(this.fileInfo.id(), new ReserveSpaceClosure(this.space, this.streamRange));
                if (fileInfo0 == null) {
                    throw new IOException("File was concurrently deleted: " + this.path);
                }
                this.fileInfo = fileInfo0;
                this.streamRange = this.initialStreamRange(this.fileInfo);
                this.space = 0L;
            }
        }
        catch (GridException e) {
            throw new IOException("Failed to flush data [path=" + this.path + ", space=" + this.space + ']', e);
        }
    }

    @Override
    protected void onClose() throws IOException {
        this.onClose(false);
    }

    private void onClose(boolean deleted) throws IOException {
        assert (Thread.holdsLock((Object)this));
        if (this.onCloseGuard.compareAndSet(false, true)) {
            boolean exists;
            if (this.mode != GridGgfsMode.PRIMARY) {
                assert (this.batch != null);
                this.batch.finish();
            }
            try {
                exists = !deleted && this.meta.exists(this.fileInfo.id());
            }
            catch (GridException e) {
                throw new IOError(e);
            }
            if (exists) {
                IOException err;
                block23: {
                    err = null;
                    try {
                        this.data.writeClose(this.fileInfo);
                        this.writeCompletionFut.get();
                    }
                    catch (GridException e) {
                        err = new IOException("Failed to close stream [path=" + this.path + ", fileInfo=" + this.fileInfo + ']', e);
                    }
                    this.metrics.addWrittenBytesTime(this.bytes, this.time);
                    if (this.mode == GridGgfsMode.DUAL_SYNC) {
                        try {
                            this.batch.await();
                        }
                        catch (GridException e) {
                            if (err != null) break block23;
                            err = new IOException("Failed to close secondary file system stream [path=" + this.path + ", fileInfo=" + this.fileInfo + ']', e);
                        }
                    }
                }
                long modificationTime = System.currentTimeMillis();
                try {
                    this.meta.unlock(this.fileInfo, modificationTime);
                }
                catch (GridGgfsFileNotFoundException ignore) {
                    this.data.delete(this.fileInfo);
                    throw new IOException("File was concurrently deleted: " + this.path);
                }
                catch (GridException e) {
                    throw new IOError(e);
                }
                this.meta.updateParentListingAsync(this.parentId, this.fileInfo.id(), this.fileName, this.bytes, modificationTime);
                if (err != null) {
                    throw err;
                }
            } else {
                try {
                    if (this.mode == GridGgfsMode.DUAL_SYNC) {
                        this.batch.await();
                    }
                }
                catch (GridException e) {
                    throw new IOException("Failed to close secondary file system stream [path=" + this.path + ", fileInfo=" + this.fileInfo + ']', e);
                }
                finally {
                    this.data.delete(this.fileInfo);
                }
            }
        }
    }

    private GridGgfsFileAffinityRange initialStreamRange(GridGgfsFileInfo fileInfo) {
        GridGgfsFileMap map;
        if (!this.ggfsCtx.configuration().isFragmentizerEnabled()) {
            return null;
        }
        int blockSize = fileInfo.blockSize();
        long off = (fileInfo.length() + (long)blockSize - 1L) / (long)blockSize * (long)blockSize;
        long lastBlockOff = off - (long)fileInfo.blockSize();
        if (lastBlockOff < 0L) {
            lastBlockOff = 0L;
        }
        GridUuid prevAffKey = (map = fileInfo.fileMap()) == null ? null : map.affinityKey(lastBlockOff, false);
        GridUuid affKey = this.data.nextAffinityKey(prevAffKey);
        return affKey == null ? null : new GridGgfsFileAffinityRange(off, off, affKey);
    }

    @Override
    public String toString() {
        return S.toString(GridGgfsOutputStreamImpl.class, (Object)((Object)this));
    }

    @GridInternal
    private static final class ReserveSpaceClosure
    implements GridClosure<GridGgfsFileInfo, GridGgfsFileInfo>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private long space;
        private GridGgfsFileAffinityRange range;

        public ReserveSpaceClosure() {
        }

        private ReserveSpaceClosure(long space, GridGgfsFileAffinityRange range) {
            this.space = space;
            this.range = range;
        }

        public GridGgfsFileInfo apply(GridGgfsFileInfo oldInfo) {
            GridGgfsFileMap oldMap = oldInfo.fileMap();
            GridGgfsFileMap newMap = new GridGgfsFileMap(oldMap);
            newMap.addRange(this.range);
            GridGgfsFileInfo updated = new GridGgfsFileInfo(oldInfo, oldInfo.length() + this.space);
            updated.fileMap(newMap);
            return updated;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.space);
            out.writeObject(this.range);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.space = in.readLong();
            this.range = (GridGgfsFileAffinityRange)in.readObject();
        }

        public String toString() {
            return S.toString(ReserveSpaceClosure.class, (Object)this);
        }
    }
}

