/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.util.typedef.T2;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridGgfsPaths
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private String secondaryUri;
    private String secondaryCfgPath;
    private GridGgfsMode dfltMode;
    private List<T2<GridGgfsPath, GridGgfsMode>> pathModes;

    public GridGgfsPaths() {
    }

    public GridGgfsPaths(@Nullable String secondaryUri, @Nullable String secondaryCfgPath, GridGgfsMode dfltMode, @Nullable List<T2<GridGgfsPath, GridGgfsMode>> pathModes) {
        this.secondaryUri = secondaryUri;
        this.secondaryCfgPath = secondaryCfgPath;
        this.dfltMode = dfltMode;
        this.pathModes = pathModes;
    }

    public String secondaryUri() {
        return this.secondaryUri;
    }

    public String secondaryConfigurationPath() {
        return this.secondaryCfgPath;
    }

    public GridGgfsMode defaultMode() {
        return this.dfltMode;
    }

    public List<T2<GridGgfsPath, GridGgfsMode>> pathModes() {
        return this.pathModes;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString((DataOutput)out, (String)this.secondaryUri);
        U.writeString((DataOutput)out, (String)this.secondaryCfgPath);
        U.writeEnum0((DataOutput)out, (Enum)this.dfltMode);
        if (this.pathModes != null) {
            out.writeBoolean(true);
            out.writeInt(this.pathModes.size());
            for (T2<GridGgfsPath, GridGgfsMode> pathMode : this.pathModes) {
                ((GridGgfsPath)pathMode.getKey()).writeExternal(out);
                U.writeEnum0((DataOutput)out, (Enum)((Enum)pathMode.getValue()));
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.secondaryUri = U.readString((DataInput)in);
        this.secondaryCfgPath = U.readString((DataInput)in);
        this.dfltMode = GridGgfsMode.fromOrdinal((int)U.readEnumOrdinal0((DataInput)in));
        if (in.readBoolean()) {
            int size = in.readInt();
            this.pathModes = new ArrayList<T2<GridGgfsPath, GridGgfsMode>>(size);
            for (int i = 0; i < size; ++i) {
                GridGgfsPath path = new GridGgfsPath();
                path.readExternal(in);
                T2 entry = new T2((Object)path, (Object)GridGgfsMode.fromOrdinal((int)U.readEnumOrdinal0((DataInput)in)));
                this.pathModes.add((T2<GridGgfsPath, GridGgfsMode>)entry);
            }
        }
    }
}

