/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.gridgain.grid.GridConfiguration;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridNode;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.GridCacheConfiguration;
import org.gridgain.grid.cache.GridCacheMemoryMode;
import org.gridgain.grid.cache.GridCacheMode;
import org.gridgain.grid.cache.affinity.GridCacheAffinityKeyMapper;
import org.gridgain.grid.compute.GridComputeJob;
import org.gridgain.grid.ggfs.GridGgfs;
import org.gridgain.grid.ggfs.GridGgfsConfiguration;
import org.gridgain.grid.ggfs.GridGgfsGroupDataBlocksKeyMapper;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.ggfs.mapreduce.GridGgfsJob;
import org.gridgain.grid.ggfs.mapreduce.GridGgfsRecordResolver;
import org.gridgain.grid.kernal.GridKernalContext;
import org.gridgain.grid.kernal.processors.cache.GridCacheAdapter;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsAckMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsAttributes;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsBlockKey;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsBlocksMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsContext;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDataManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDeleteMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileAffinityRange;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFragmentizerManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFragmentizerRequest;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFragmentizerResponse;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsJobImpl;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsMetaManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsProcessorAdapter;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsServerManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSyncMessage;
import org.gridgain.grid.kernal.processors.license.GridLicenseUseRegistry;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridInClosure;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.product.GridProductEdition;
import org.gridgain.grid.util.direct.GridTcpCommunicationMessageAdapter;
import org.gridgain.grid.util.direct.GridTcpCommunicationMessageFactory;
import org.gridgain.grid.util.direct.GridTcpCommunicationMessageProducer;
import org.gridgain.grid.util.ipc.GridIpcServerEndpoint;
import org.gridgain.grid.util.typedef.C1;
import org.gridgain.grid.util.typedef.CI1;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.X;
import org.gridgain.grid.util.typedef.internal.U;
import org.jdk8.backport.ConcurrentHashMap8;
import org.jetbrains.annotations.Nullable;

public class GridGgfsProcessor
extends GridGgfsProcessorAdapter {
    private static final String NULL_NAME = UUID.randomUUID().toString();
    private static final GridClosure<GridGgfsContext, GridGgfs> CTX_TO_GGFS = new C1<GridGgfsContext, GridGgfs>(){

        public GridGgfs apply(GridGgfsContext ggfsCtx) {
            return ggfsCtx.ggfs();
        }
    };
    private final ConcurrentMap<String, GridGgfsContext> ggfsCache = new ConcurrentHashMap8();

    public GridGgfsProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    public void start() throws GridException {
        if (this.ctx.config().isDaemon()) {
            return;
        }
        GridGgfsConfiguration[] cfgs = this.ctx.config().getGgfsConfiguration();
        assert (cfgs != null && cfgs.length > 0);
        GridTcpCommunicationMessageFactory.registerCommon((GridTcpCommunicationMessageProducer)new GridTcpCommunicationMessageProducer(){

            public GridTcpCommunicationMessageAdapter create(byte type) {
                switch (type) {
                    case 65: {
                        return new GridGgfsAckMessage();
                    }
                    case 66: {
                        return new GridGgfsBlockKey();
                    }
                    case 67: {
                        return new GridGgfsBlocksMessage();
                    }
                    case 68: {
                        return new GridGgfsDeleteMessage();
                    }
                    case 69: {
                        return new GridGgfsFileAffinityRange();
                    }
                    case 70: {
                        return new GridGgfsFragmentizerRequest();
                    }
                    case 71: {
                        return new GridGgfsFragmentizerResponse();
                    }
                    case 72: {
                        return new GridGgfsSyncMessage();
                    }
                }
                assert (false) : "Invalid GGFS message type.";
                return null;
            }
        }, (int[])new int[]{65, 66, 67, 68, 69, 70, 71, 72});
        GridLicenseUseRegistry.onUsage((GridProductEdition)GridProductEdition.HADOOP, ((Object)((Object)this)).getClass());
        this.validateLocalGgfsConfigurations(cfgs);
        for (GridGgfsConfiguration cfg : cfgs) {
            GridGgfsContext ggfsCtx = new GridGgfsContext(this.ctx, new GridGgfsConfiguration(cfg), new GridGgfsMetaManager(), new GridGgfsDataManager(), new GridGgfsServerManager(), new GridGgfsFragmentizerManager());
            for (GridGgfsManager mgr : ggfsCtx.managers()) {
                mgr.start(ggfsCtx);
            }
            this.ggfsCache.put(this.maskName(cfg.getName()), ggfsCtx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("GGFS processor started.");
        }
    }

    public void onKernalStart() throws GridException {
        if (this.ctx.config().isDaemon()) {
            return;
        }
        for (GridNode n : this.ctx.discovery().remoteNodes()) {
            this.checkGgfsOnRemoteNode(n);
        }
        for (GridGgfsContext ggfsCtx : this.ggfsCache.values()) {
            for (GridGgfsManager mgr : ggfsCtx.managers()) {
                mgr.onKernalStart();
            }
        }
    }

    public void stop(boolean cancel) {
        for (GridGgfsContext ggfsCtx : this.ggfsCache.values()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stopping ggfs: " + ggfsCtx.configuration().getName());
            }
            List<GridGgfsManager> mgrs = ggfsCtx.managers();
            ListIterator<GridGgfsManager> it = mgrs.listIterator(mgrs.size());
            while (it.hasPrevious()) {
                GridGgfsManager mgr = it.previous();
                mgr.stop(cancel);
            }
            ggfsCtx.ggfs().stop();
        }
        this.ggfsCache.clear();
        if (this.log.isDebugEnabled()) {
            this.log.debug("GGFS processor stopped.");
        }
    }

    public void onKernalStop(boolean cancel) {
        for (GridGgfsContext ggfsCtx : this.ggfsCache.values()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stopping ggfs: " + ggfsCtx.configuration().getName());
            }
            List<GridGgfsManager> mgrs = ggfsCtx.managers();
            ListIterator<GridGgfsManager> it = mgrs.listIterator(mgrs.size());
            while (it.hasPrevious()) {
                GridGgfsManager mgr = it.previous();
                mgr.onKernalStop(cancel);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished executing GGFS processor onKernalStop() callback.");
        }
    }

    public void printMemoryStats() {
        X.println((String)">>>", (Object[])new Object[0]);
        X.println((String)(">>> GGFS processor memory stats [grid=" + this.ctx.gridName() + ']'), (Object[])new Object[0]);
        X.println((String)(">>>   ggfsCacheSize: " + this.ggfsCache.size()), (Object[])new Object[0]);
    }

    public Collection<GridGgfs> ggfss() {
        return F.viewReadOnly(this.ggfsCache.values(), CTX_TO_GGFS, (GridPredicate[])new GridPredicate[0]);
    }

    @Nullable
    public GridGgfs ggfs(@Nullable String name) {
        GridGgfsContext ggfsCtx = (GridGgfsContext)this.ggfsCache.get(this.maskName(name));
        return ggfsCtx == null ? null : ggfsCtx.ggfs();
    }

    @Nullable
    public Collection<GridIpcServerEndpoint> endpoints(@Nullable String name) {
        GridGgfsContext ggfsCtx = (GridGgfsContext)this.ggfsCache.get(this.maskName(name));
        return ggfsCtx == null ? Collections.emptyList() : ggfsCtx.server().endpoints();
    }

    @Nullable
    public GridComputeJob createJob(GridGgfsJob job, @Nullable String ggfsName, GridGgfsPath path, long start, long length, GridGgfsRecordResolver recRslv) {
        return new GridGgfsJobImpl(job, ggfsName, path, start, length, recRslv);
    }

    public void addAttributes(Map<String, Object> attrs) throws GridException {
        super.addAttributes(attrs);
        GridConfiguration gridCfg = this.ctx.config();
        if (gridCfg.isDaemon() || F.isEmpty((Object[])gridCfg.getGgfsConfiguration()) || F.isEmpty((Object[])gridCfg.getCacheConfiguration())) {
            return;
        }
        final HashMap cacheCfgs = new HashMap();
        F.forEach((Object[])gridCfg.getCacheConfiguration(), (GridInClosure)new CI1<GridCacheConfiguration>(){

            public void apply(GridCacheConfiguration c) {
                cacheCfgs.put(c.getName(), c);
            }
        }, (GridPredicate[])new GridPredicate[0]);
        ArrayList<GridGgfsAttributes> attrVals = new ArrayList<GridGgfsAttributes>();
        assert (gridCfg.getGgfsConfiguration() != null);
        for (GridGgfsConfiguration ggfsCfg : gridCfg.getGgfsConfiguration()) {
            GridCacheAffinityKeyMapper affMapper;
            GridCacheConfiguration cacheCfg = (GridCacheConfiguration)cacheCfgs.get(ggfsCfg.getDataCacheName());
            if (cacheCfg == null || !((affMapper = cacheCfg.getAffinityMapper()) instanceof GridGgfsGroupDataBlocksKeyMapper)) continue;
            attrVals.add(new GridGgfsAttributes(ggfsCfg.getName(), ggfsCfg.getBlockSize(), ((GridGgfsGroupDataBlocksKeyMapper)affMapper).groupSize(), ggfsCfg.getMetaCacheName(), ggfsCfg.getDataCacheName(), ggfsCfg.getDefaultMode(), ggfsCfg.getPathModes(), ggfsCfg.isFragmentizerEnabled()));
        }
        attrs.put("org.gridgain.ggfs", attrVals.toArray(new GridGgfsAttributes[attrVals.size()]));
    }

    private String maskName(@Nullable String name) {
        return name == null ? NULL_NAME : name;
    }

    private void validateLocalGgfsConfigurations(GridGgfsConfiguration[] cfgs) throws GridException {
        HashSet<String> cfgNames = new HashSet<String>();
        for (GridGgfsConfiguration cfg : cfgs) {
            boolean secondary;
            int backups;
            String name = cfg.getName();
            if (cfgNames.contains(name)) {
                throw new GridException("Duplicate GGFS name found (check configuration and assign unique name to each): " + name);
            }
            GridCacheAdapter dataCache = this.ctx.cache().internalCache(cfg.getDataCacheName());
            if (dataCache == null) {
                throw new GridException("Data cache is not configured locally for GGFS: " + cfg);
            }
            if (dataCache.configuration().isQueryIndexEnabled()) {
                throw new GridException("GGFS data cache cannot start with enabled query indexing.");
            }
            GridCache metaCache = this.ctx.cache().cache(cfg.getMetaCacheName());
            if (metaCache == null) {
                throw new GridException("Metadata cache is not configured locally for GGFS: " + cfg);
            }
            if (metaCache.configuration().isQueryIndexEnabled()) {
                throw new GridException("GGFS metadata cache cannot start with enabled query indexing.");
            }
            if (F.eq((Object)cfg.getDataCacheName(), (Object)cfg.getMetaCacheName())) {
                throw new GridException("Cannot use same cache as both data and meta cache: " + cfg.getName());
            }
            if (!(dataCache.configuration().getAffinityMapper() instanceof GridGgfsGroupDataBlocksKeyMapper)) {
                throw new GridException("Invalid GGFS data cache configuration (key affinity mapper class should be " + GridGgfsGroupDataBlocksKeyMapper.class.getSimpleName() + "): " + cfg);
            }
            long maxSpaceSize = cfg.getMaxSpaceSize();
            if (maxSpaceSize > 0L) {
                long maxHeapSize = Runtime.getRuntime().maxMemory();
                long offHeapSize = dataCache.configuration().getOffHeapMaxMemory();
                if (offHeapSize < 0L && maxSpaceSize > maxHeapSize) {
                    throw new GridException("Maximum GGFS space size cannot be greater that size of available heap memory [maxHeapSize=" + maxHeapSize + ", maxGgfsSpaceSize=" + maxSpaceSize + ']');
                }
                if (offHeapSize > 0L && maxSpaceSize > maxHeapSize + offHeapSize) {
                    throw new GridException("Maximum GGFS space size cannot be greater than size of available heap memory and offheap storage [maxHeapSize=" + maxHeapSize + ", offHeapSize=" + offHeapSize + ", maxGgfsSpaceSize=" + maxSpaceSize + ']');
                }
            }
            if (dataCache.configuration().getCacheMode() == GridCacheMode.PARTITIONED && (backups = dataCache.configuration().getBackups()) != 0) {
                throw new GridException("GGFS data cache cannot be used with backups (set backup count to 0 and restart the grid): " + cfg.getDataCacheName());
            }
            if (cfg.getMaxSpaceSize() == 0L && dataCache.configuration().getMemoryMode() == GridCacheMemoryMode.OFFHEAP_VALUES) {
                U.warn((GridLogger)this.log, (Object)("GGFS max space size is not specified but data cache values are stored off-heap (max space will be limited to 80% of max JVM heap size): " + cfg.getName()));
            }
            boolean bl = secondary = cfg.getDefaultMode() == GridGgfsMode.PROXY;
            if (cfg.getPathModes() != null) {
                for (Map.Entry mode : cfg.getPathModes().entrySet()) {
                    if (mode.getValue() != GridGgfsMode.PROXY) continue;
                    secondary = true;
                }
            }
            if (secondary) {
                this.assertParameter(cfg.getSecondaryHadoopFileSystemUri() != null, "secondaryHadoopFileSystemUri cannot be null when mode is SECONDARY");
                this.assertParameter(cfg.getSecondaryHadoopFileSystemConfigPath() != null, "secondaryHadoopFileSystemConfigPath cannot be null when mode is SECONDARY");
            }
            if (cfg.getSecondaryHadoopFileSystemConfigPath() != null && cfg.getSecondaryHadoopFileSystemUri() == null) {
                throw new GridException("secondaryHadoopFileSystemUri cannot be null when secondaryHadoopFileSystemConfigPath is set.");
            }
            if (cfg.getSecondaryHadoopFileSystemConfigPath() == null && cfg.getSecondaryHadoopFileSystemUri() != null) {
                throw new GridException("secondaryHadoopFileSystemConfigPath cannot be null when secondaryHadoopFileSystemUri is set.");
            }
            cfgNames.add(name);
        }
    }

    private void checkGgfsOnRemoteNode(GridNode rmtNode) throws GridException {
        Object[] locAttrs = (GridGgfsAttributes[])this.ctx.discovery().localNode().attribute("org.gridgain.ggfs");
        Object[] rmtAttrs = (GridGgfsAttributes[])rmtNode.attribute("org.gridgain.ggfs");
        if (F.isEmpty((Object[])locAttrs) || F.isEmpty((Object[])rmtAttrs)) {
            return;
        }
        assert (rmtAttrs != null && locAttrs != null);
        for (Object rmtAttr : rmtAttrs) {
            for (Object locAttr : locAttrs) {
                if (!F.eq((Object)((GridGgfsAttributes)rmtAttr).ggfsName(), (Object)((GridGgfsAttributes)locAttr).ggfsName())) {
                    if (F.eq((Object)((GridGgfsAttributes)rmtAttr).metaCacheName(), (Object)((GridGgfsAttributes)locAttr).metaCacheName())) {
                        throw new GridException("Meta cache names should be different for different GGFS instances configuration [metaCacheName=" + ((GridGgfsAttributes)rmtAttr).metaCacheName() + ", locNodeId=" + this.ctx.localNodeId() + ", rmtNodeId=" + rmtNode.id() + ", locGgfsName=" + ((GridGgfsAttributes)locAttr).ggfsName() + ", rmtGgfsName=" + ((GridGgfsAttributes)rmtAttr).ggfsName() + ']');
                    }
                    if (!F.eq((Object)((GridGgfsAttributes)rmtAttr).dataCacheName(), (Object)((GridGgfsAttributes)locAttr).dataCacheName())) continue;
                    throw new GridException("Data cache names should be different for different GGFS instances configuration [dataCacheName=" + ((GridGgfsAttributes)rmtAttr).dataCacheName() + ", locNodeId=" + this.ctx.localNodeId() + ", rmtNodeId=" + rmtNode.id() + ", locGgfsName=" + ((GridGgfsAttributes)locAttr).ggfsName() + ", rmtGgfsName=" + ((GridGgfsAttributes)rmtAttr).ggfsName() + ']');
                }
                if (!F.eq((Object)((GridGgfsAttributes)rmtAttr).blockSize(), (Object)((GridGgfsAttributes)locAttr).blockSize())) {
                    throw new GridException("Data block size should be same on all nodes in grid for GGFS configuration [rmtNodeId=" + rmtNode.id() + ", rmtBlockSize=" + ((GridGgfsAttributes)rmtAttr).blockSize() + ", locBlockSize=" + ((GridGgfsAttributes)locAttr).blockSize() + ", ggfsName=" + ((GridGgfsAttributes)rmtAttr).ggfsName() + ']');
                }
                if (!F.eq((Object)((GridGgfsAttributes)rmtAttr).groupSize(), (Object)((GridGgfsAttributes)locAttr).groupSize())) {
                    throw new GridException("Affinity mapper group size should be the same on all nodes in grid for GGFS configuration [rmtNodeId=" + rmtNode.id() + ", rmtGrpSize=" + ((GridGgfsAttributes)rmtAttr).groupSize() + ", locGrpSize=" + ((GridGgfsAttributes)locAttr).groupSize() + ", ggfsName=" + ((GridGgfsAttributes)rmtAttr).ggfsName() + ']');
                }
                if (!F.eq((Object)((GridGgfsAttributes)rmtAttr).metaCacheName(), (Object)((GridGgfsAttributes)locAttr).metaCacheName())) {
                    throw new GridException("Meta cache name should be the same on all nodes in grid for GGFS configuration [rmtNodeId=" + rmtNode.id() + ", rmtMetaCacheName=" + ((GridGgfsAttributes)rmtAttr).metaCacheName() + ", locMetaCacheName=" + ((GridGgfsAttributes)locAttr).metaCacheName() + ", ggfsName=" + ((GridGgfsAttributes)rmtAttr).ggfsName() + ']');
                }
                if (!F.eq((Object)((GridGgfsAttributes)rmtAttr).dataCacheName(), (Object)((GridGgfsAttributes)locAttr).dataCacheName())) {
                    throw new GridException("Data cache name should be the same on all nodes in grid for GGFS configuration [rmtNodeId=" + rmtNode.id() + ", rmtDataCacheName=" + ((GridGgfsAttributes)rmtAttr).dataCacheName() + ", locDataCacheName=" + ((GridGgfsAttributes)locAttr).dataCacheName() + ", ggfsName=" + ((GridGgfsAttributes)rmtAttr).ggfsName() + ']');
                }
                if (!F.eq((Object)((GridGgfsAttributes)rmtAttr).defaultMode(), (Object)((GridGgfsAttributes)locAttr).defaultMode())) {
                    throw new GridException("Default mode should be the same on all nodes in grid for GGFS configuration [rmtNodeId=" + rmtNode.id() + ", rmtDefaultMode=" + ((GridGgfsAttributes)rmtAttr).defaultMode() + ", locDefaultMode=" + ((GridGgfsAttributes)locAttr).defaultMode() + ", ggfsName=" + ((GridGgfsAttributes)rmtAttr).ggfsName() + ']');
                }
                if (!F.eq(((GridGgfsAttributes)rmtAttr).pathModes(), ((GridGgfsAttributes)locAttr).pathModes())) {
                    throw new GridException("Path modes should be the same on all nodes in grid for GGFS configuration [rmtNodeId=" + rmtNode.id() + ", rmtPathModes=" + ((GridGgfsAttributes)rmtAttr).pathModes() + ", locPathModes=" + ((GridGgfsAttributes)locAttr).pathModes() + ", ggfsName=" + ((GridGgfsAttributes)rmtAttr).ggfsName() + ']');
                }
                if (F.eq((Object)((GridGgfsAttributes)rmtAttr).fragmentizerEnabled(), (Object)((GridGgfsAttributes)locAttr).fragmentizerEnabled())) continue;
                throw new GridException("Fragmentizer should be either enabled or disabled on all nodes in grid for GGFS configuration [rmtNodeId=" + rmtNode.id() + ", rmtFragmentizerEnabled=" + ((GridGgfsAttributes)rmtAttr).fragmentizerEnabled() + ", locFragmentizerEnabled=" + ((GridGgfsAttributes)locAttr).fragmentizerEnabled() + ", ggfsName=" + ((GridGgfsAttributes)rmtAttr).ggfsName() + ']');
            }
        }
    }
}

