/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.typedef.internal.U;

public class GridGgfsSecondaryInputStreamWrapper {
    private final FileSystem fs;
    private final Path path;
    private final int bufSize;
    private final GridLogger log;
    private FSDataInputStream in;
    private IOException err;
    private boolean opened;

    GridGgfsSecondaryInputStreamWrapper(FileSystem fs, Path path, int bufSize, GridLogger log) {
        assert (fs != null);
        assert (path != null);
        assert (log != null);
        this.fs = fs;
        this.path = path;
        this.bufSize = bufSize;
        this.log = log;
    }

    FSDataInputStream in() throws IOException {
        if (this.opened) {
            if (this.err != null) {
                throw this.err;
            }
        } else {
            this.opened = true;
            try {
                this.in = this.fs.open(this.path, this.bufSize);
                if (this.in == null) {
                    throw new IOException("Failed to open input stream (secondary file system returned null): " + this.path);
                }
            }
            catch (IOException e) {
                this.err = e;
                U.error((GridLogger)this.log, (Object)("Failed to open secondary file system input stream: " + this.path), (Throwable)e);
                throw this.err;
            }
        }
        return this.in;
    }

    void close() {
        U.closeQuiet((Closeable)this.in);
    }
}

