/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.gridgain.grid.GridException;
import org.gridgain.grid.ggfs.GridGgfsConfiguration;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsServer;
import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.thread.GridThread;
import org.gridgain.grid.util.ipc.GridIpcEndpointBindException;
import org.gridgain.grid.util.ipc.GridIpcServerEndpoint;
import org.gridgain.grid.util.typedef.C1;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.U;
import org.gridgain.grid.util.worker.GridWorker;

public class GridGgfsServerManager
extends GridGgfsManager {
    private static final long REBIND_INTERVAL = 3000L;
    private Collection<GridGgfsServer> srvrs;
    private BindWorker bindWorker;
    private CountDownLatch kernalStartLatch = new CountDownLatch(1);

    @Override
    protected void start0() throws GridException {
        GridGgfsConfiguration ggfsCfg = this.ggfsCtx.configuration();
        HashMap<String, String> cfg = ggfsCfg.getIpcEndpointConfiguration();
        if (F.isEmpty((Map)cfg)) {
            cfg = new HashMap<String, String>();
            cfg.put("type", U.isWindows() ? "tcp" : "shmem");
            cfg.put("port", String.valueOf(10500));
        }
        if (ggfsCfg.isIpcEndpointEnabled()) {
            this.bind(cfg, false);
        }
        if (ggfsCfg.getManagementPort() >= 0) {
            cfg = new HashMap();
            cfg.put("type", "tcp");
            cfg.put("port", String.valueOf(ggfsCfg.getManagementPort()));
            this.bind(cfg, true);
        }
        if (this.bindWorker != null) {
            new GridThread((GridWorker)this.bindWorker).start();
        }
    }

    private void bind(Map<String, String> endpointCfg, boolean mgmt) throws GridException {
        if (this.srvrs == null) {
            this.srvrs = new ConcurrentLinkedQueue<GridGgfsServer>();
        }
        GridGgfsServer ipcSrv = new GridGgfsServer(this.ggfsCtx, endpointCfg, mgmt);
        try {
            ipcSrv.start();
            this.srvrs.add(ipcSrv);
        }
        catch (GridIpcEndpointBindException ignored) {
            int port = ipcSrv.getIpcServerEndpoint().getPort();
            String portMsg = port != -1 ? " Failed to bind to port (is port already in use?): " + port : "";
            U.warn((GridLogger)this.log, (Object)("Failed to start GGFS " + (mgmt ? "management " : "") + "endpoint " + "(will retry every " + 3L + "s)." + portMsg));
            if (this.bindWorker == null) {
                this.bindWorker = new BindWorker();
            }
            this.bindWorker.addConfiguration(endpointCfg, mgmt);
        }
    }

    public Collection<GridIpcServerEndpoint> endpoints() {
        return F.viewReadOnly(this.srvrs, (GridClosure)new C1<GridGgfsServer, GridIpcServerEndpoint>(){

            public GridIpcServerEndpoint apply(GridGgfsServer e) {
                return e.getIpcServerEndpoint();
            }
        }, (GridPredicate[])new GridPredicate[0]);
    }

    @Override
    protected void onKernalStart0() throws GridException {
        if (!F.isEmpty(this.srvrs)) {
            for (GridGgfsServer srv : this.srvrs) {
                srv.onKernalStart();
            }
        }
        this.kernalStartLatch.countDown();
    }

    @Override
    protected void stop0(boolean cancel) {
        this.kernalStartLatch.countDown();
        if (this.bindWorker != null) {
            this.bindWorker.cancel();
            U.join((GridWorker)this.bindWorker, (GridLogger)this.log);
        }
        if (!F.isEmpty(this.srvrs)) {
            for (GridGgfsServer srv : this.srvrs) {
                srv.stop(cancel);
            }
        }
    }

    private class BindWorker
    extends GridWorker {
        private Collection<GridBiTuple<Map<String, String>, Boolean>> bindCfgs;

        private BindWorker() {
            super(GridGgfsServerManager.this.ggfsCtx.kernalContext().gridName(), "bind-worker", GridGgfsServerManager.this.ggfsCtx.kernalContext().log());
            this.bindCfgs = new LinkedList<GridBiTuple<Map<String, String>, Boolean>>();
        }

        public void addConfiguration(Map<String, String> cfg, boolean mgmt) {
            this.bindCfgs.add((GridBiTuple<Map<String, String>, Boolean>)F.t(cfg, (Object)mgmt));
        }

        protected void body() throws InterruptedException {
            GridGgfsServerManager.this.kernalStartLatch.await();
            while (!this.isCancelled()) {
                Thread.sleep(3000L);
                Iterator<GridBiTuple<Map<String, String>, Boolean>> it = this.bindCfgs.iterator();
                while (it.hasNext()) {
                    GridBiTuple<Map<String, String>, Boolean> cfg = it.next();
                    GridGgfsServer ipcSrv = new GridGgfsServer(GridGgfsServerManager.this.ggfsCtx, (Map)cfg.get1(), (Boolean)cfg.get2());
                    try {
                        ipcSrv.start();
                        ipcSrv.onKernalStart();
                        GridGgfsServerManager.this.srvrs.add(ipcSrv);
                        it.remove();
                    }
                    catch (GridException e) {
                        if (!GridWorker.log.isDebugEnabled()) continue;
                        GridWorker.log.debug("Failed to bind GGFS endpoint [cfg=" + cfg + ", err=" + e.getMessage() + ']');
                    }
                }
                if (!this.bindCfgs.isEmpty()) continue;
                break;
            }
        }
    }
}

