/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.gridgain.grid.GridNode;
import org.gridgain.grid.hadoop.GridHadoopConfiguration;
import org.gridgain.grid.hadoop.GridHadoopMapReducePlan;
import org.gridgain.grid.hadoop.GridHadoopMapReducePlanner;
import org.gridgain.grid.kernal.GridKernalContext;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopComponent;
import org.gridgain.grid.kernal.processors.hadoop.jobtracker.GridHadoopJobMetadata;
import org.gridgain.grid.kernal.processors.hadoop.jobtracker.GridHadoopJobTracker;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.GridHadoopShuffle;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.GridHadoopTaskExecutorAdapter;

public class GridHadoopContext {
    private GridKernalContext ctx;
    private GridHadoopConfiguration cfg;
    private GridHadoopJobTracker jobTracker;
    private GridHadoopTaskExecutorAdapter taskExecutor;
    private GridHadoopShuffle shuffle;
    private List<GridHadoopComponent> components = new ArrayList<GridHadoopComponent>();

    public GridHadoopContext(GridKernalContext ctx, GridHadoopConfiguration cfg, GridHadoopJobTracker jobTracker, GridHadoopTaskExecutorAdapter taskExecutor, GridHadoopShuffle shuffle) {
        this.ctx = ctx;
        this.cfg = cfg;
        this.jobTracker = this.add(jobTracker);
        this.taskExecutor = this.add(taskExecutor);
        this.shuffle = this.add(shuffle);
    }

    public List<GridHadoopComponent> components() {
        return this.components;
    }

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    public GridHadoopConfiguration configuration() {
        return this.cfg;
    }

    public UUID localNodeId() {
        return this.ctx.localNodeId();
    }

    public long localNodeOrder() {
        assert (this.ctx.discovery() != null);
        return this.ctx.discovery().localNode().order();
    }

    public Collection<GridNode> nodes() {
        return this.ctx.discovery().cacheNodes("gg-hadoop-mr-sys-cache", this.ctx.discovery().topologyVersion());
    }

    public boolean jobUpdateLeader() {
        long minOrder = Long.MAX_VALUE;
        GridNode minOrderNode = null;
        for (GridNode node : this.nodes()) {
            if (node.order() >= minOrder) continue;
            minOrder = node.order();
            minOrderNode = node;
        }
        assert (minOrderNode != null);
        return this.localNodeId().equals(minOrderNode.id());
    }

    public boolean isParticipating(GridHadoopJobMetadata meta) {
        UUID locNodeId = this.localNodeId();
        if (locNodeId.equals(meta.submitNodeId())) {
            return true;
        }
        GridHadoopMapReducePlan plan = meta.mapReducePlan();
        return plan.mapperNodeIds().contains(locNodeId) || plan.reducerNodeIds().contains(locNodeId) || this.jobUpdateLeader();
    }

    public GridHadoopJobTracker jobTracker() {
        return this.jobTracker;
    }

    public GridHadoopTaskExecutorAdapter taskExecutor() {
        return this.taskExecutor;
    }

    public GridHadoopShuffle shuffle() {
        return this.shuffle;
    }

    public GridHadoopMapReducePlanner planner() {
        return this.cfg.getMapReducePlanner();
    }

    private <C extends GridHadoopComponent> C add(C c) {
        this.components.add(c);
        return c;
    }
}

