/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop;

import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.hadoop.GridHadoop;
import org.gridgain.grid.hadoop.GridHadoopConfiguration;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.hadoop.GridHadoopJobInfo;
import org.gridgain.grid.hadoop.GridHadoopJobStatus;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopProcessor;
import org.gridgain.grid.util.GridSpinBusyLock;
import org.jetbrains.annotations.Nullable;

public class GridHadoopImpl
implements GridHadoop {
    private final GridHadoopProcessor proc;
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();

    GridHadoopImpl(GridHadoopProcessor proc) {
        this.proc = proc;
    }

    public GridHadoopConfiguration configuration() {
        return this.proc.config();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridHadoopJobId nextJobId() {
        if (this.busyLock.enterBusy()) {
            try {
                GridHadoopJobId gridHadoopJobId = this.proc.nextJobId();
                return gridHadoopJobId;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get next job ID (grid is stopping).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridFuture<?> submit(GridHadoopJobId jobId, GridHadoopJobInfo jobInfo) {
        if (this.busyLock.enterBusy()) {
            try {
                GridFuture<?> gridFuture = this.proc.submit(jobId, jobInfo);
                return gridFuture;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to submit job (grid is stopping).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridHadoopJobStatus status(GridHadoopJobId jobId) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridHadoopJobStatus gridHadoopJobStatus = this.proc.status(jobId);
                return gridHadoopJobStatus;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get job status (grid is stopping).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridFuture<?> finishFuture(GridHadoopJobId jobId) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridFuture<?> gridFuture = this.proc.finishFuture(jobId);
                return gridFuture;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get job finish future (grid is stopping).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean kill(GridHadoopJobId jobId) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                boolean bl = this.proc.kill(jobId);
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to kill job (grid is stopping).");
    }
}

