/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop;

import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.hadoop.GridHadoop;
import org.gridgain.grid.hadoop.GridHadoopConfiguration;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.hadoop.GridHadoopJobInfo;
import org.gridgain.grid.hadoop.GridHadoopJobStatus;
import org.gridgain.grid.hadoop.GridHadoopMapReducePlanner;
import org.gridgain.grid.kernal.GridKernalContext;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopComponent;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopContext;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopImpl;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopProcessorAdapter;
import org.gridgain.grid.kernal.processors.hadoop.jobtracker.GridHadoopJobTracker;
import org.gridgain.grid.kernal.processors.hadoop.planner.GridHadoopDefaultMapReducePlanner;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.GridHadoopShuffle;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.GridHadoopEmbeddedTaskExecutor;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.GridHadoopExternalTaskExecutor;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.tostring.GridToStringExclude;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopProcessor
extends GridHadoopProcessorAdapter {
    private final AtomicInteger idCtr = new AtomicInteger();
    @GridToStringExclude
    private GridHadoopContext hctx;
    @GridToStringExclude
    private GridHadoop hadoop;

    public GridHadoopProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    public void start() throws GridException {
        if (this.ctx.isDaemon()) {
            return;
        }
        GridHadoopConfiguration cfg = this.ctx.config().getHadoopConfiguration();
        cfg = cfg == null ? new GridHadoopConfiguration() : new GridHadoopConfiguration(cfg);
        this.initializeDefaults(cfg);
        this.validate(cfg);
        this.hctx = new GridHadoopContext(this.ctx, cfg, new GridHadoopJobTracker(), cfg.isExternalExecution() ? new GridHadoopExternalTaskExecutor() : new GridHadoopEmbeddedTaskExecutor(), new GridHadoopShuffle());
        for (GridHadoopComponent c : this.hctx.components()) {
            c.start(this.hctx);
        }
        this.hadoop = new GridHadoopImpl(this);
        this.checkHadoopInstallation();
    }

    private void checkHadoopInstallation() throws GridException {
        URL location;
        String hadoopHome = System.getenv("HADOOP_HOME");
        if (F.isEmpty((String)hadoopHome)) {
            U.quietAndWarn((GridLogger)this.log, (Object)"HADOOP_HOME environment variable is not set.");
        } else {
            U.quietAndInfo((GridLogger)this.log, (String)("Apache Hadoop is found at " + hadoopHome));
        }
        try {
            location = Class.forName("org.apache.hadoop.conf.Configuration").getProtectionDomain().getCodeSource().getLocation();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new GridException("Apache Hadoop is not in classpath. Check if HADOOP_HOME environment variable points to Apache Hadoop installation directory.", e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Hadoop classes are loaded from " + location);
        }
    }

    public String toString() {
        return S.toString(GridHadoopProcessor.class, (Object)((Object)this));
    }

    public void stop(boolean cancel) throws GridException {
        super.stop(cancel);
        if (this.hctx == null) {
            return;
        }
        List<GridHadoopComponent> components = this.hctx.components();
        ListIterator<GridHadoopComponent> it = components.listIterator(components.size());
        while (it.hasPrevious()) {
            GridHadoopComponent c = it.previous();
            c.stop(cancel);
        }
    }

    public void onKernalStart() throws GridException {
        super.onKernalStart();
        if (this.hctx == null) {
            return;
        }
        for (GridHadoopComponent c : this.hctx.components()) {
            c.onKernalStart();
        }
    }

    public void onKernalStop(boolean cancel) {
        super.onKernalStop(cancel);
        if (this.hctx == null) {
            return;
        }
        List<GridHadoopComponent> components = this.hctx.components();
        ListIterator<GridHadoopComponent> it = components.listIterator(components.size());
        while (it.hasPrevious()) {
            GridHadoopComponent c = it.previous();
            c.onKernalStop(cancel);
        }
    }

    public GridHadoopContext context() {
        return this.hctx;
    }

    public GridHadoop hadoop() {
        return this.hadoop;
    }

    public GridHadoopConfiguration config() {
        return this.hctx.configuration();
    }

    public GridHadoopJobId nextJobId() {
        return new GridHadoopJobId(this.ctx.localNodeId(), this.idCtr.incrementAndGet());
    }

    public GridFuture<?> submit(GridHadoopJobId jobId, GridHadoopJobInfo jobInfo) {
        return this.hctx.jobTracker().submit(jobId, jobInfo);
    }

    public GridHadoopJobStatus status(GridHadoopJobId jobId) throws GridException {
        return this.hctx.jobTracker().status(jobId);
    }

    public GridFuture<?> finishFuture(GridHadoopJobId jobId) throws GridException {
        return this.hctx.jobTracker().finishFuture(jobId);
    }

    public boolean kill(GridHadoopJobId jobId) throws GridException {
        return this.hctx.jobTracker().killJob(jobId);
    }

    private void initializeDefaults(GridHadoopConfiguration cfg) {
        if (cfg.getMapReducePlanner() == null) {
            cfg.setMapReducePlanner((GridHadoopMapReducePlanner)new GridHadoopDefaultMapReducePlanner());
        }
    }

    private void validate(GridHadoopConfiguration hadoopCfg) throws GridException {
        if (this.ctx.config().isPeerClassLoadingEnabled()) {
            throw new GridException("Peer class loading cannot be used with Hadoop (disable it using GridConfiguration.setPeerClassLoadingEnabled()).");
        }
    }
}

