/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.gridgain.grid.hadoop.GridHadoopDefaultJobInfo;
import org.gridgain.grid.hadoop.GridHadoopJobPhase;
import org.gridgain.grid.hadoop.GridHadoopJobState;
import org.gridgain.grid.hadoop.GridHadoopJobStatus;
import org.gridgain.grid.kernal.processors.hadoop.jobtracker.GridHadoopJobMetadata;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopUtils {
    public static final int SPECULATIVE_CONCURRENCY = Math.min(8, Runtime.getRuntime().availableProcessors() * 2);
    private static final String STAGING_CONSTANT = ".staging";
    private static final long STEP_SPAN = 1000L;
    private static final int MIN_STEPS_PER_HALF_PROGRESS = 5;
    private static final int STEPS_PER_HALF_PROGRESS_RANGE = 45;

    public static GridHadoopJobStatus status(GridHadoopJobMetadata meta) {
        GridHadoopDefaultJobInfo jobInfo = (GridHadoopDefaultJobInfo)meta.jobInfo();
        return new GridHadoopJobStatus(meta.jobId(), meta.phase() == GridHadoopJobPhase.PHASE_COMPLETE ? (meta.failCause() == null ? GridHadoopJobState.STATE_SUCCEEDED : GridHadoopJobState.STATE_FAILED) : GridHadoopJobState.STATE_RUNNING, jobInfo.configuration().getJobName(), jobInfo.configuration().getUser(), meta.pendingSplits() != null ? meta.pendingSplits().size() : 0, meta.pendingReducers() != null ? meta.pendingReducers().size() : 0, meta.mapReducePlan().mappers(), meta.mapReducePlan().reducers(), meta.startTimestamp(), meta.setupCompleteTimestamp(), meta.mapCompleteTimestamp(), meta.phase(), SPECULATIVE_CONCURRENCY, meta.version());
    }

    public static JobStatus status(GridHadoopJobStatus status, Configuration conf) {
        float cleanupProgress;
        float reduceProgress;
        float mapProgress;
        float setupProgress;
        JobStatus.State state;
        JobID jobId = new JobID(status.jobId().globalId().toString(), status.jobId().localId());
        switch (status.jobState()) {
            case STATE_RUNNING: {
                state = JobStatus.State.RUNNING;
                break;
            }
            case STATE_SUCCEEDED: {
                state = JobStatus.State.SUCCEEDED;
                break;
            }
            case STATE_FAILED: {
                state = JobStatus.State.FAILED;
                break;
            }
            default: {
                assert (status.jobState() == GridHadoopJobState.STATE_KILLED);
                state = JobStatus.State.KILLED;
            }
        }
        switch (status.jobPhase()) {
            case PHASE_SETUP: {
                setupProgress = GridHadoopUtils.setupProgress(status);
                mapProgress = 0.0f;
                reduceProgress = 0.0f;
                cleanupProgress = 0.0f;
                break;
            }
            case PHASE_MAP: {
                setupProgress = 1.0f;
                mapProgress = GridHadoopUtils.mapProgress(status);
                reduceProgress = 0.0f;
                cleanupProgress = 0.0f;
                break;
            }
            case PHASE_REDUCE: {
                setupProgress = 1.0f;
                mapProgress = 1.0f;
                reduceProgress = GridHadoopUtils.reduceProgress(status);
                cleanupProgress = 0.0f;
                break;
            }
            case PHASE_CANCELLING: {
                setupProgress = GridHadoopUtils.setupProgress(status);
                mapProgress = GridHadoopUtils.mapProgress(status);
                reduceProgress = GridHadoopUtils.reduceProgress(status);
                cleanupProgress = 0.0f;
                break;
            }
            default: {
                assert (status.jobPhase() == GridHadoopJobPhase.PHASE_COMPLETE);
                setupProgress = GridHadoopUtils.setupProgress(status);
                mapProgress = GridHadoopUtils.mapProgress(status);
                reduceProgress = GridHadoopUtils.reduceProgress(status);
                cleanupProgress = 1.0f;
            }
        }
        return new JobStatus(jobId, setupProgress, mapProgress, reduceProgress, cleanupProgress, state, JobPriority.NORMAL, status.user(), status.jobName(), GridHadoopUtils.jobFile(conf, status.user(), jobId).toString(), "N/A");
    }

    public static Path stagingAreaDir(Configuration conf, String usr) {
        return new Path(conf.get("yarn.app.mapreduce.am.staging-dir", "/tmp/hadoop-yarn/staging") + "/" + usr + "/" + STAGING_CONSTANT);
    }

    public static Path jobFile(Configuration conf, String usr, JobID jobId) {
        return new Path(GridHadoopUtils.stagingAreaDir(conf, usr), jobId.toString() + "/" + "job.xml");
    }

    private static float setupProgress(GridHadoopJobStatus status) {
        if (status.mapStartTime() > 0L) {
            return 1.0f;
        }
        return GridHadoopUtils.progress(1, 0, 1, status.setupStartTime());
    }

    private static float mapProgress(GridHadoopJobStatus status) {
        if (status.reduceStartTime() > 0L) {
            return 1.0f;
        }
        return GridHadoopUtils.progress(status.totalMapperCnt(), status.totalMapperCnt() - status.pendingMapperCnt(), Math.min(status.totalMapperCnt(), status.concurrencyLevel()), status.mapStartTime());
    }

    private static float reduceProgress(GridHadoopJobStatus status) {
        if (status.reduceStartTime() == 0L) {
            return 0.0f;
        }
        return GridHadoopUtils.progress(status.totalReducerCnt(), status.totalReducerCnt() - status.pendingReducerCnt(), Math.min(status.totalReducerCnt(), status.concurrencyLevel()), status.reduceStartTime());
    }

    private static float progress(int totalTasks, int completedTasks, int maxConcurrentTasks, long startTime) {
        if (totalTasks == 0 || totalTasks == completedTasks) {
            return 1.0f;
        }
        assert (maxConcurrentTasks <= totalTasks);
        int concurrentTasks = Math.min(totalTasks - completedTasks, maxConcurrentTasks);
        long dur = U.currentTimeMillis() - startTime;
        float speculativeProgress = GridHadoopUtils.speculativeProgress(totalTasks, maxConcurrentTasks, dur) * (float)concurrentTasks;
        float res = ((float)completedTasks + speculativeProgress) / (float)totalTasks;
        assert (res <= 1.01f);
        if (res > 1.0f) {
            res = 1.0f;
        }
        return res;
    }

    private static float speculativeProgress(int totalTasks, int maxConcurrentTasks, long dur) {
        float halfRatio = (float)maxConcurrentTasks / (float)totalTasks;
        int halfProgressSteps = 5 + (int)(45.0f * halfRatio);
        long stepSizeChanges = dur / ((long)halfProgressSteps * 1000L);
        long tailSteps = dur / 1000L - stepSizeChanges * (long)halfProgressSteps;
        assert ((long)halfProgressSteps * stepSizeChanges + tailSteps == dur / 1000L);
        float power2 = (float)Math.pow(0.5, stepSizeChanges);
        return 1.0f - power2 + power2 / 2.0f * (float)tailSteps / (float)halfProgressSteps;
    }

    private GridHadoopUtils() {
    }
}

