/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.ChecksumFs;
import org.apache.hadoop.fs.DelegateToFileSystem;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.local.LocalConfigKeys;
import org.gridgain.grid.kernal.processors.hadoop.fs.GridHadoopRawLocalFileSystem;

public class GridHadoopLocalFileSystemV2
extends ChecksumFs {
    public GridHadoopLocalFileSystemV2(Configuration cfg) throws IOException, URISyntaxException {
        super((AbstractFileSystem)new DelegateFS(cfg));
    }

    public GridHadoopLocalFileSystemV2(URI uri, Configuration cfg) throws IOException, URISyntaxException {
        this(cfg);
    }

    private static class DelegateFS
    extends DelegateToFileSystem {
        public DelegateFS(Configuration cfg) throws IOException, URISyntaxException {
            super(FsConstants.LOCAL_FS_URI, (FileSystem)new GridHadoopRawLocalFileSystem(), cfg, FsConstants.LOCAL_FS_URI.getScheme(), false);
        }

        public int getUriDefaultPort() {
            return -1;
        }

        public FsServerDefaults getServerDefaults() throws IOException {
            return LocalConfigKeys.getServerDefaults();
        }

        public boolean isValidName(String src) {
            return true;
        }
    }
}

