/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.fs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopRawLocalFileSystem
extends FileSystem {
    private final ThreadLocal<Path> workDir = new ThreadLocal<Path>(){

        @Override
        protected Path initialValue() {
            return GridHadoopRawLocalFileSystem.this.getInitialWorkingDirectory();
        }
    };

    File convert(Path path) {
        this.checkPath(path);
        if (path.isAbsolute()) {
            return new File(path.toUri().getPath());
        }
        return new File(this.getWorkingDirectory().toUri().getPath(), path.toUri().getPath());
    }

    public Path getInitialWorkingDirectory() {
        File f = new File(System.getProperty("user.dir"));
        return new Path(f.getAbsoluteFile().toURI()).makeQualified(this.getUri(), null);
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
    }

    public URI getUri() {
        return FsConstants.LOCAL_FS_URI;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return new FSDataInputStream((InputStream)new InStream(GridHadoopRawLocalFileSystem.checkExists(this.convert(f))));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufSize, short replication, long blockSize, Progressable progress) throws IOException {
        File file = this.convert(f);
        if (!overwrite && !file.createNewFile()) {
            throw new IOException("Failed to create new file: " + f.toUri());
        }
        return this.out(file, false, bufSize);
    }

    private FSDataOutputStream out(File file, boolean append, int bufSize) throws IOException {
        return new FSDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file, append), bufSize < 32768 ? 32768 : bufSize), new FileSystem.Statistics(this.getUri().getScheme()));
    }

    public FSDataOutputStream append(Path f, int bufSize, Progressable progress) throws IOException {
        return this.out(this.convert(f), true, bufSize);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.convert(src).renameTo(this.convert(dst));
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        File file = this.convert(f);
        if (file.isDirectory() && !recursive) {
            throw new IOException("Failed to remove directory in non recursive mode: " + f.toUri());
        }
        return U.delete((File)file);
    }

    public void setWorkingDirectory(Path dir) {
        this.workDir.set(dir);
        this.checkPath(dir);
    }

    public Path getWorkingDirectory() {
        return this.workDir.get();
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        File parent2f;
        if (f == null) {
            throw new IllegalArgumentException("mkdirs path arg is null");
        }
        Path parent = f.getParent();
        File p2f = this.convert(f);
        if (parent != null && (parent2f = this.convert(parent)) != null && parent2f.exists() && !parent2f.isDirectory()) {
            throw new FileAlreadyExistsException("Parent path is not a directory: " + parent);
        }
        return !(parent != null && !this.mkdirs(parent) || !p2f.mkdir() && !p2f.isDirectory());
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.fileStatus(GridHadoopRawLocalFileSystem.checkExists(this.convert(f)));
    }

    private FileStatus fileStatus(File file) throws IOException {
        boolean dir = file.isDirectory();
        java.nio.file.Path path = dir ? null : file.toPath();
        return new FileStatus(dir ? 0L : file.length(), dir, 1, 4096L, file.lastModified(), file.lastModified(), null, null, null, dir ? null : (Files.isSymbolicLink(path) ? new Path(Files.readSymbolicLink(path).toUri()) : null), new Path(file.toURI()));
    }

    private static File checkExists(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist.");
        }
        return file;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        File file = this.convert(f);
        if (GridHadoopRawLocalFileSystem.checkExists(file).isFile()) {
            return new FileStatus[]{this.fileStatus(file)};
        }
        File[] files = file.listFiles();
        FileStatus[] res = new FileStatus[files.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.fileStatus(files[i]);
        }
        return res;
    }

    public boolean supportsSymlinks() {
        return true;
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        Files.createSymbolicLink(this.convert(link).toPath(), this.convert(target).toPath(), new FileAttribute[0]);
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException {
        return this.getFileStatus(this.getLinkTarget(f));
    }

    public Path getLinkTarget(Path f) throws IOException {
        File file = Files.readSymbolicLink(this.convert(f).toPath()).toFile();
        return new Path(file.toURI());
    }

    private static class InStream
    extends InputStream
    implements Seekable,
    PositionedReadable {
        private final RandomAccessFile file;

        public InStream(File f) throws IOException {
            this.file = new RandomAccessFile(f, "r");
        }

        @Override
        public synchronized int read() throws IOException {
            return this.file.read();
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            return this.file.read(b, off, len);
        }

        @Override
        public synchronized void close() throws IOException {
            this.file.close();
        }

        public synchronized int read(long pos, byte[] buf, int off, int len) throws IOException {
            long pos0 = this.file.getFilePointer();
            this.file.seek(pos);
            int res = this.file.read(buf, off, len);
            this.file.seek(pos0);
            return res;
        }

        public void readFully(long pos, byte[] buf, int off, int len) throws IOException {
            if (this.read(pos, buf, off, len) != len) {
                throw new IOException();
            }
        }

        public void readFully(long pos, byte[] buf) throws IOException {
            this.readFully(pos, buf, 0, buf.length);
        }

        public synchronized void seek(long pos) throws IOException {
            this.file.seek(pos);
        }

        public synchronized long getPos() throws IOException {
            return this.file.getFilePointer();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }
    }
}

