/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.jobtracker;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.gridgain.grid.hadoop.GridHadoopInputSplit;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.hadoop.GridHadoopJobInfo;
import org.gridgain.grid.hadoop.GridHadoopJobPhase;
import org.gridgain.grid.hadoop.GridHadoopMapReducePlan;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.GridHadoopProcessDescriptor;
import org.gridgain.grid.util.tostring.GridToStringExclude;
import org.gridgain.grid.util.tostring.GridToStringInclude;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopJobMetadata
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private GridHadoopJobId jobId;
    private GridHadoopJobInfo jobInfo;
    private UUID submitNodeId;
    private GridHadoopMapReducePlan mrPlan;
    private Collection<GridHadoopInputSplit> pendingSplits;
    private Collection<Integer> pendingReducers;
    private Map<Object, Integer> taskNumMap = new HashMap<Object, Integer>();
    private int nextTaskNum;
    @GridToStringInclude
    private Map<Integer, GridHadoopProcessDescriptor> reducersAddrs;
    private GridHadoopJobPhase phase = GridHadoopJobPhase.PHASE_SETUP;
    @GridToStringExclude
    private Throwable failCause;
    private long ver;
    private long startTs;
    private long setupCompleteTs;
    private long mapCompleteTs;
    private long completeTs;

    public GridHadoopJobMetadata() {
    }

    public GridHadoopJobMetadata(UUID submitNodeId, GridHadoopJobId jobId, GridHadoopJobInfo jobInfo) {
        this.jobId = jobId;
        this.jobInfo = jobInfo;
        this.submitNodeId = submitNodeId;
        this.startTs = System.currentTimeMillis();
    }

    public GridHadoopJobMetadata(GridHadoopJobMetadata src) {
        this.completeTs = src.completeTs;
        this.failCause = src.failCause;
        this.jobId = src.jobId;
        this.jobInfo = src.jobInfo;
        this.mapCompleteTs = src.mapCompleteTs;
        this.mrPlan = src.mrPlan;
        this.pendingSplits = src.pendingSplits;
        this.pendingReducers = src.pendingReducers;
        this.phase = src.phase;
        this.reducersAddrs = src.reducersAddrs;
        this.setupCompleteTs = src.setupCompleteTs;
        this.startTs = src.startTs;
        this.submitNodeId = src.submitNodeId;
        this.taskNumMap = src.taskNumMap;
        this.ver = src.ver + 1L;
    }

    public UUID submitNodeId() {
        return this.submitNodeId;
    }

    public void phase(GridHadoopJobPhase phase) {
        this.phase = phase;
    }

    public GridHadoopJobPhase phase() {
        return this.phase;
    }

    public Map<Integer, GridHadoopProcessDescriptor> reducersAddresses() {
        return this.reducersAddrs;
    }

    public void reducersAddresses(Map<Integer, GridHadoopProcessDescriptor> reducersAddrs) {
        this.reducersAddrs = reducersAddrs;
    }

    public void pendingSplits(Collection<GridHadoopInputSplit> pendingSplits) {
        this.pendingSplits = pendingSplits;
    }

    public Collection<GridHadoopInputSplit> pendingSplits() {
        return this.pendingSplits;
    }

    public void pendingReducers(Collection<Integer> pendingReducers) {
        this.pendingReducers = pendingReducers;
    }

    public Collection<Integer> pendingReducers() {
        return this.pendingReducers;
    }

    public GridHadoopJobId jobId() {
        return this.jobId;
    }

    public long startTimestamp() {
        return this.startTs;
    }

    public long setupCompleteTimestamp() {
        return this.setupCompleteTs;
    }

    public long mapCompleteTimestamp() {
        return this.mapCompleteTs;
    }

    public long completeTimestamp() {
        return this.completeTs;
    }

    public void setupCompleteTimestamp(long setupCompleteTs) {
        this.setupCompleteTs = setupCompleteTs;
    }

    public void mapCompleteTimestamp(long mapCompleteTs) {
        this.mapCompleteTs = mapCompleteTs;
    }

    public void completeTimestamp(long completeTs) {
        this.completeTs = completeTs;
    }

    public long setupTime() {
        this.setupCompleteTs = this.startTs;
        return this.setupCompleteTs;
    }

    public long mapTime() {
        return this.mapCompleteTs - this.setupCompleteTs;
    }

    public long reduceTime() {
        return this.completeTs - this.mapCompleteTs;
    }

    public long totalTime() {
        return this.completeTs - this.startTs;
    }

    public void mapReducePlan(GridHadoopMapReducePlan mrPlan) {
        assert (this.mrPlan == null) : "Map-reduce plan can only be initialized once.";
        this.mrPlan = mrPlan;
        for (UUID nodeId : mrPlan.mapperNodeIds()) {
            for (GridHadoopInputSplit split : mrPlan.mappers(nodeId)) {
                this.assignTaskNumber(split);
            }
            this.assignTaskNumber(nodeId);
        }
        for (UUID nodeId : mrPlan.reducerNodeIds()) {
            for (int rdc : mrPlan.reducers(nodeId)) {
                this.assignTaskNumber(rdc);
            }
        }
    }

    public GridHadoopMapReducePlan mapReducePlan() {
        return this.mrPlan;
    }

    public GridHadoopJobInfo jobInfo() {
        return this.jobInfo;
    }

    public void failCause(Throwable failCause) {
        assert (failCause != null);
        if (this.failCause == null) {
            this.failCause = failCause;
        }
    }

    public Throwable failCause() {
        return this.failCause;
    }

    public long version() {
        return this.ver;
    }

    public int taskNumber(Object src) {
        Integer res = this.taskNumMap.get(src);
        if (res == null) {
            throw new IllegalArgumentException("Failed to find task number for source [src=" + src + ", map=" + this.taskNumMap + ']');
        }
        return res;
    }

    private void assignTaskNumber(Object src) {
        Integer num = this.taskNumMap.get(src);
        if (num == null) {
            this.taskNumMap.put(src, this.nextTaskNum++);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid((DataOutput)out, (UUID)this.submitNodeId);
        out.writeObject(this.jobId);
        out.writeObject(this.jobInfo);
        out.writeObject(this.mrPlan);
        out.writeObject(this.pendingSplits);
        out.writeObject(this.pendingReducers);
        out.writeObject(this.taskNumMap);
        out.writeInt(this.nextTaskNum);
        out.writeObject(this.phase);
        out.writeObject(this.failCause);
        out.writeLong(this.ver);
        out.writeLong(this.startTs);
        out.writeLong(this.setupCompleteTs);
        out.writeLong(this.mapCompleteTs);
        out.writeLong(this.completeTs);
        out.writeObject(this.reducersAddrs);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.submitNodeId = U.readUuid((DataInput)in);
        this.jobId = (GridHadoopJobId)in.readObject();
        this.jobInfo = (GridHadoopJobInfo)in.readObject();
        this.mrPlan = (GridHadoopMapReducePlan)in.readObject();
        this.pendingSplits = (Collection)in.readObject();
        this.pendingReducers = (Collection)in.readObject();
        this.taskNumMap = (Map)in.readObject();
        this.nextTaskNum = in.readInt();
        this.phase = (GridHadoopJobPhase)in.readObject();
        this.failCause = (Throwable)in.readObject();
        this.ver = in.readLong();
        this.startTs = in.readLong();
        this.setupCompleteTs = in.readLong();
        this.mapCompleteTs = in.readLong();
        this.completeTs = in.readLong();
        this.reducersAddrs = (Map)in.readObject();
    }

    public String toString() {
        return S.toString(GridHadoopJobMetadata.class, (Object)this, (String)"pendingMaps", (Object)this.pendingSplits.size(), (String)"pendingReduces", (Object)this.pendingReducers.size(), (String)"failCause", this.failCause == null ? null : this.failCause.getClass().getName());
    }
}

