/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.jobtracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.GridCacheEntry;
import org.gridgain.grid.cache.GridCacheProjection;
import org.gridgain.grid.cache.query.GridCacheContinuousQuery;
import org.gridgain.grid.events.GridDiscoveryEvent;
import org.gridgain.grid.events.GridEvent;
import org.gridgain.grid.hadoop.GridHadoopInputSplit;
import org.gridgain.grid.hadoop.GridHadoopJob;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.hadoop.GridHadoopJobInfo;
import org.gridgain.grid.hadoop.GridHadoopJobPhase;
import org.gridgain.grid.hadoop.GridHadoopJobProperty;
import org.gridgain.grid.hadoop.GridHadoopJobStatus;
import org.gridgain.grid.hadoop.GridHadoopMapReducePlan;
import org.gridgain.grid.hadoop.GridHadoopMapReducePlanner;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.hadoop.GridHadoopTaskType;
import org.gridgain.grid.kernal.managers.eventstorage.GridLocalEventListener;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopComponent;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopContext;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopTaskCancelledException;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopUtils;
import org.gridgain.grid.kernal.processors.hadoop.jobtracker.GridHadoopJobMetadata;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.GridHadoopTaskState;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.GridHadoopTaskStatus;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.GridHadoopProcessDescriptor;
import org.gridgain.grid.lang.GridBiPredicate;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridInClosure;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.GridMutex;
import org.gridgain.grid.util.GridSpinReadWriteLock;
import org.gridgain.grid.util.future.GridFinishedFutureEx;
import org.gridgain.grid.util.future.GridFutureAdapter;
import org.gridgain.grid.util.future.GridFutureAdapterEx;
import org.gridgain.grid.util.typedef.CI1;
import org.gridgain.grid.util.typedef.CIX1;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.U;
import org.jdk8.backport.ConcurrentHashMap8;
import org.jetbrains.annotations.Nullable;

public class GridHadoopJobTracker
extends GridHadoopComponent {
    private final GridMutex mux = new GridMutex();
    private volatile GridCacheProjection<GridHadoopJobId, GridHadoopJobMetadata> jobMetaPrj;
    private GridHadoopMapReducePlanner mrPlanner;
    private ConcurrentMap<GridHadoopJobId, GridFutureAdapterEx<GridHadoopJob>> jobs = new ConcurrentHashMap8();
    private ConcurrentMap<GridHadoopJobId, JobLocalState> activeJobs = new ConcurrentHashMap8();
    private ConcurrentMap<GridHadoopJobId, GridFutureAdapter<GridHadoopJobId>> activeFinishFuts = new ConcurrentHashMap8();
    private ExecutorService evtProcSvc;
    private GridSpinReadWriteLock busyLock;
    private CI1<GridFuture<?>> failsLogger = new CI1<GridFuture<?>>(){

        public void apply(GridFuture<?> gridFuture) {
            try {
                gridFuture.get();
            }
            catch (GridException e) {
                U.error((GridLogger)GridHadoopJobTracker.this.log, (Object)"Failed to transform system cache.", (Throwable)e);
            }
        }
    };

    @Override
    public void start(GridHadoopContext ctx) throws GridException {
        super.start(ctx);
        this.busyLock = new GridSpinReadWriteLock();
        this.evtProcSvc = Executors.newFixedThreadPool(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCacheProjection<GridHadoopJobId, GridHadoopJobMetadata> jobMetaCache() {
        GridCacheProjection prj = this.jobMetaPrj;
        if (prj == null) {
            GridMutex gridMutex = this.mux;
            synchronized (gridMutex) {
                prj = this.jobMetaPrj;
                if (prj == null) {
                    GridCache sysCache = this.ctx.kernalContext().cache().cache("gg-hadoop-mr-sys-cache");
                    assert (sysCache != null);
                    this.mrPlanner = this.ctx.planner();
                    try {
                        this.ctx.kernalContext().resource().injectGeneric((Object)this.mrPlanner);
                    }
                    catch (GridException e) {
                        U.error((GridLogger)this.log, (Object)"Failed to inject resources.", (Throwable)e);
                        throw new IllegalStateException(e);
                    }
                    this.jobMetaPrj = prj = sysCache.projection(GridHadoopJobId.class, GridHadoopJobMetadata.class);
                }
            }
        }
        return prj;
    }

    @Override
    public void onKernalStart() throws GridException {
        super.onKernalStart();
        GridCacheContinuousQuery qry = this.jobMetaCache().queries().createContinuousQuery();
        qry.callback((GridBiPredicate)new GridBiPredicate<UUID, Collection<Map.Entry<GridHadoopJobId, GridHadoopJobMetadata>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean apply(UUID nodeId, final Collection<Map.Entry<GridHadoopJobId, GridHadoopJobMetadata>> evts) {
                if (!GridHadoopJobTracker.this.busyLock.tryReadLock()) {
                    return false;
                }
                try {
                    GridHadoopJobTracker.this.evtProcSvc.submit(new EventHandler(){

                        @Override
                        protected void body() throws GridException {
                            GridHadoopJobTracker.this.processJobMetadata(evts);
                        }
                    });
                    boolean bl = true;
                    return bl;
                }
                finally {
                    GridHadoopJobTracker.this.busyLock.readUnlock();
                }
            }
        });
        qry.execute();
        this.ctx.kernalContext().event().addLocalEventListener(new GridLocalEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(final GridEvent evt) {
                if (!GridHadoopJobTracker.this.busyLock.tryReadLock()) {
                    return;
                }
                try {
                    GridHadoopJobTracker.this.evtProcSvc.submit(new EventHandler(){

                        @Override
                        protected void body() {
                            GridHadoopJobTracker.this.processNodeLeft((GridDiscoveryEvent)evt);
                        }
                    });
                }
                finally {
                    GridHadoopJobTracker.this.busyLock.readUnlock();
                }
            }
        }, 12, new int[]{11});
    }

    @Override
    public void onKernalStop(boolean cancel) {
        super.onKernalStop(cancel);
        this.busyLock.writeLock();
        this.evtProcSvc.shutdown();
        for (GridFutureAdapter fut : this.activeFinishFuts.values()) {
            fut.onDone((Throwable)new GridException("Failed to execute Hadoop map-reduce job (grid is stopping)."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridFuture<GridHadoopJobId> submit(GridHadoopJobId jobId, GridHadoopJobInfo info) {
        if (!this.busyLock.tryReadLock()) {
            return new GridFinishedFutureEx((Throwable)new GridException("Failed to execute map-reduce job (grid is stopping): " + info));
        }
        try {
            if (this.jobs.containsKey(jobId) || this.jobMetaCache().containsKey((Object)jobId)) {
                throw new GridException("Failed to submit job. Job with the same ID already exists: " + jobId);
            }
            GridHadoopJob job = this.job(jobId, info);
            GridHadoopMapReducePlan mrPlan = this.mrPlanner.preparePlan(job, this.ctx.nodes(), null);
            GridHadoopJobMetadata meta = new GridHadoopJobMetadata(this.ctx.localNodeId(), jobId, info);
            meta.mapReducePlan(mrPlan);
            meta.pendingSplits(this.allSplits(mrPlan));
            meta.pendingReducers(this.allReducers(mrPlan));
            GridFutureAdapter completeFut = new GridFutureAdapter();
            GridFutureAdapter<GridHadoopJobId> old = this.activeFinishFuts.put(jobId, (GridFutureAdapter<GridHadoopJobId>)completeFut);
            assert (old == null) : "Duplicate completion future [jobId=" + jobId + ", old=" + old + ']';
            if (this.log.isDebugEnabled()) {
                this.log.debug("Submitting job metadata [jobId=" + jobId + ", meta=" + meta + ']');
            }
            if (this.jobMetaCache().putIfAbsent((Object)jobId, (Object)meta) != null) {
                throw new GridException("Failed to submit job. Job with the same ID already exists: " + jobId);
            }
            GridFutureAdapter gridFutureAdapter = completeFut;
            return gridFutureAdapter;
        }
        catch (GridException e) {
            U.error((GridLogger)this.log, (Object)("Failed to submit job: " + jobId), (Throwable)e);
            GridFinishedFutureEx gridFinishedFutureEx = new GridFinishedFutureEx((Throwable)e);
            return gridFinishedFutureEx;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridHadoopJobStatus status(GridHadoopJobId jobId) throws GridException {
        if (!this.busyLock.tryReadLock()) {
            return null;
        }
        try {
            GridHadoopJobMetadata meta = (GridHadoopJobMetadata)this.jobMetaCache().get((Object)jobId);
            GridHadoopJobStatus gridHadoopJobStatus = meta != null ? GridHadoopUtils.status(meta) : null;
            return gridHadoopJobStatus;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridFuture<?> finishFuture(GridHadoopJobId jobId) throws GridException {
        if (!this.busyLock.tryReadLock()) {
            return null;
        }
        try {
            GridHadoopJobMetadata meta = (GridHadoopJobMetadata)this.jobMetaCache().get((Object)jobId);
            if (meta == null) {
                GridFuture<?> gridFuture = null;
                return gridFuture;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Got job metadata for status check [locNodeId=" + this.ctx.localNodeId() + ", meta=" + meta + ']');
            }
            if (meta.phase() == GridHadoopJobPhase.PHASE_COMPLETE) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Job is complete, returning finished future: " + jobId);
                }
                GridFinishedFutureEx gridFinishedFutureEx = new GridFinishedFutureEx((Object)jobId, meta.failCause());
                return gridFinishedFutureEx;
            }
            GridFutureAdapter fut = (GridFutureAdapter)F.addIfAbsent(this.activeFinishFuts, (Object)jobId, (Object)new GridFutureAdapter());
            meta = (GridHadoopJobMetadata)this.jobMetaCache().get((Object)jobId);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Re-checking job metadata [locNodeId=" + this.ctx.localNodeId() + ", meta=" + meta + ']');
            }
            if (meta == null) {
                fut.onDone();
                this.activeFinishFuts.remove(jobId, fut);
            } else if (meta.phase() == GridHadoopJobPhase.PHASE_COMPLETE) {
                fut.onDone((Object)jobId, meta.failCause());
                this.activeFinishFuts.remove(jobId, fut);
            }
            GridFutureAdapter gridFutureAdapter = fut;
            return gridFutureAdapter;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridHadoopMapReducePlan plan(GridHadoopJobId jobId) throws GridException {
        if (!this.busyLock.tryReadLock()) {
            return null;
        }
        try {
            GridHadoopJobMetadata meta = (GridHadoopJobMetadata)this.jobMetaCache().get((Object)jobId);
            if (meta != null) {
                GridHadoopMapReducePlan gridHadoopMapReducePlan = meta.mapReducePlan();
                return gridHadoopMapReducePlan;
            }
            GridHadoopMapReducePlan gridHadoopMapReducePlan = null;
            return gridHadoopMapReducePlan;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onTaskFinished(GridHadoopTaskInfo info, GridHadoopTaskStatus status) {
        if (!this.busyLock.tryReadLock()) {
            return;
        }
        try {
            assert (status.state() != GridHadoopTaskState.RUNNING);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received task finished callback [info=" + info + ", status=" + status + ']');
            }
            JobLocalState state = (JobLocalState)this.activeJobs.get(info.jobId());
            assert (status.state() != GridHadoopTaskState.FAILED || status.failCause() != null) : "Invalid task status [info=" + info + ", status=" + status + ']';
            if (!$assertionsDisabled && state == null) {
                if (!this.ctx.jobUpdateLeader()) throw new AssertionError((Object)("Missing local state for finished task [info=" + info + ", status=" + status + ']'));
                if (info.type() != GridHadoopTaskType.COMMIT && info.type() != GridHadoopTaskType.ABORT) {
                    throw new AssertionError((Object)("Missing local state for finished task [info=" + info + ", status=" + status + ']'));
                }
            }
            switch (info.type()) {
                case SETUP: {
                    state.onSetupFinished(info, status);
                    return;
                }
                case MAP: {
                    state.onMapFinished(info, status);
                    return;
                }
                case REDUCE: {
                    state.onReduceFinished(info, status);
                    return;
                }
                case COMBINE: {
                    state.onCombineFinished(info, status);
                    return;
                }
                case COMMIT: 
                case ABORT: {
                    GridCacheEntry entry = this.jobMetaCache().entry((Object)info.jobId());
                    entry.timeToLive(this.ctx.configuration().getFinishedJobInfoTtl());
                    entry.transformAsync((GridClosure)new UpdatePhaseClosure(GridHadoopJobPhase.PHASE_COMPLETE)).listenAsync(this.failsLogger);
                    return;
                }
            }
            return;
        }
        catch (GridException e) {
            U.error((GridLogger)this.log, (Object)"Failed to process task finish event.", (Throwable)e);
            return;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    private void transform(GridHadoopJobId jobId, GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata> c) {
        this.jobMetaCache().transformAsync((Object)jobId, c).listenAsync(this.failsLogger);
    }

    public void onExternalMappersInitialized(GridHadoopJobId jobId, Collection<Integer> reducers, GridHadoopProcessDescriptor desc) {
        this.transform(jobId, new InitializeReducersClosure(reducers, desc));
    }

    private Collection<GridHadoopInputSplit> allSplits(GridHadoopMapReducePlan plan) {
        HashSet<GridHadoopInputSplit> res = new HashSet<GridHadoopInputSplit>();
        for (UUID nodeId : plan.mapperNodeIds()) {
            res.addAll(plan.mappers(nodeId));
        }
        return res;
    }

    private Collection<Integer> allReducers(GridHadoopMapReducePlan plan) {
        HashSet<Integer> res = new HashSet<Integer>();
        for (int i = 0; i < plan.reducers(); ++i) {
            res.add(i);
        }
        return res;
    }

    private void processNodeLeft(GridDiscoveryEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing discovery event [locNodeId=" + this.ctx.localNodeId() + ", evt=" + evt + ']');
        }
        if (this.ctx.jobUpdateLeader()) {
            boolean checkSetup = evt.eventNode().order() < this.ctx.localNodeOrder();
            for (GridHadoopJobMetadata meta : this.jobMetaCache().values()) {
                GridHadoopJobId jobId = meta.jobId();
                GridHadoopMapReducePlan plan = meta.mapReducePlan();
                GridHadoopJobPhase phase = meta.phase();
                try {
                    if (checkSetup && phase == GridHadoopJobPhase.PHASE_SETUP && !this.activeJobs.containsKey(jobId)) {
                        GridHadoopJob job = this.job(jobId, meta.jobInfo());
                        Collection<GridHadoopTaskInfo> setupTask = this.setupTask(jobId);
                        assert (setupTask != null);
                        this.ctx.taskExecutor().run(job, setupTask);
                        continue;
                    }
                    if (phase != GridHadoopJobPhase.PHASE_MAP && phase != GridHadoopJobPhase.PHASE_REDUCE) continue;
                    HashSet cancelSplits = null;
                    for (UUID nodeId : plan.mapperNodeIds()) {
                        if (this.ctx.kernalContext().discovery().node(nodeId) != null) continue;
                        Collection mappers = plan.mappers(nodeId);
                        if (cancelSplits == null) {
                            cancelSplits = new HashSet();
                        }
                        cancelSplits.addAll(mappers);
                    }
                    HashSet<Integer> cancelReducers = null;
                    for (UUID nodeId : plan.reducerNodeIds()) {
                        if (this.ctx.kernalContext().discovery().node(nodeId) != null) continue;
                        int[] reducers = plan.reducers(nodeId);
                        if (cancelReducers == null) {
                            cancelReducers = new HashSet<Integer>();
                        }
                        for (int rdc : reducers) {
                            cancelReducers.add(rdc);
                        }
                    }
                    if (cancelSplits == null && cancelReducers == null) continue;
                    this.jobMetaCache().transform((Object)meta.jobId(), (GridClosure)new CancelJobClosure(new GridException("One or more nodes participating in map-reduce job execution failed."), cancelSplits, cancelReducers));
                }
                catch (GridException e) {
                    U.error((GridLogger)this.log, (Object)("Failed to cancel job: " + meta), (Throwable)e);
                }
            }
        }
    }

    private void processJobMetadata(Iterable<Map.Entry<GridHadoopJobId, GridHadoopJobMetadata>> updated) throws GridException {
        UUID locNodeId = this.ctx.localNodeId();
        block9: for (Map.Entry<GridHadoopJobId, GridHadoopJobMetadata> entry : updated) {
            GridHadoopJobId jobId = entry.getKey();
            GridHadoopJobMetadata meta = entry.getValue();
            if (meta == null || !this.ctx.isParticipating(meta)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processing job metadata update callback [locNodeId=" + locNodeId + ", meta=" + meta + ']');
            }
            try {
                this.ctx.taskExecutor().onJobStateChanged(meta);
            }
            catch (GridException e) {
                U.error((GridLogger)this.log, (Object)("Failed to process job state changed callback (will fail the job) [locNodeId=" + locNodeId + ", jobId=" + jobId + ", meta=" + meta + ']'), (Throwable)e);
                this.transform(jobId, new CancelJobClosure(e));
                continue;
            }
            JobLocalState state = (JobLocalState)this.activeJobs.get(jobId);
            GridHadoopJob job = this.job(jobId, meta.jobInfo());
            GridHadoopMapReducePlan plan = meta.mapReducePlan();
            switch (meta.phase()) {
                case PHASE_SETUP: {
                    Collection<GridHadoopTaskInfo> setupTask;
                    if (!this.ctx.jobUpdateLeader() || (setupTask = this.setupTask(jobId)) == null) continue block9;
                    this.ctx.taskExecutor().run(job, setupTask);
                    break;
                }
                case PHASE_MAP: {
                    Collection<GridHadoopTaskInfo> tasks = this.mapperTasks(plan.mappers(locNodeId), meta);
                    if (tasks == null) continue block9;
                    this.ctx.taskExecutor().run(job, tasks);
                    break;
                }
                case PHASE_REDUCE: {
                    GridHadoopTaskInfo info;
                    if (meta.pendingReducers().isEmpty() && this.ctx.jobUpdateLeader()) {
                        info = new GridHadoopTaskInfo(this.ctx.localNodeId(), GridHadoopTaskType.COMMIT, jobId, 0, 0, null);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Submitting COMMIT task for execution [locNodeId=" + locNodeId + ", jobId=" + jobId + ']');
                        }
                        this.ctx.taskExecutor().run(job, Collections.singletonList(info));
                        return;
                    }
                    Collection<GridHadoopTaskInfo> tasks = this.reducerTasks(plan.reducers(locNodeId), job);
                    if (tasks == null) continue block9;
                    this.ctx.taskExecutor().run(job, tasks);
                    break;
                }
                case PHASE_CANCELLING: {
                    int[] rdc;
                    GridHadoopTaskInfo info;
                    if (state != null && state.onCancel()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Cancelling local task execution for job: " + meta);
                        }
                        this.ctx.taskExecutor().cancelTasks(jobId);
                    }
                    if (meta.pendingSplits().isEmpty() && meta.pendingReducers().isEmpty()) {
                        if (this.ctx.jobUpdateLeader()) {
                            if (state == null) {
                                state = this.initState(jobId);
                            }
                            if (state.onAborted()) {
                                info = new GridHadoopTaskInfo(this.ctx.localNodeId(), GridHadoopTaskType.ABORT, jobId, 0, 0, null);
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Submitting ABORT task for execution [locNodeId=" + locNodeId + ", jobId=" + jobId + ']');
                                }
                                this.ctx.taskExecutor().run(job, Collections.singletonList(info));
                            }
                        }
                        return;
                    }
                    ArrayList<GridHadoopInputSplit> cancelMappers = new ArrayList<GridHadoopInputSplit>();
                    ArrayList<Integer> cancelReducers = new ArrayList<Integer>();
                    Collection mappers = plan.mappers(this.ctx.localNodeId());
                    if (mappers != null) {
                        for (GridHadoopInputSplit b : mappers) {
                            if (state != null && state.mapperScheduled(b)) continue;
                            cancelMappers.add(b);
                        }
                    }
                    if ((rdc = plan.reducers(this.ctx.localNodeId())) != null) {
                        for (int r : rdc) {
                            if (state != null && state.reducerScheduled(r)) continue;
                            cancelReducers.add(r);
                        }
                    }
                    if (cancelMappers.isEmpty() && cancelReducers.isEmpty()) continue block9;
                    this.transform(jobId, new CancelJobClosure(cancelMappers, cancelReducers));
                    break;
                }
                case PHASE_COMPLETE: {
                    GridFutureAdapterEx jobFut;
                    GridFutureAdapter finishFut;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Job execution is complete, will remove local state from active jobs [jobId=" + jobId + ", meta=" + meta + ", setupTime=" + meta.setupTime() + ", mapTime=" + meta.mapTime() + ", reduceTime=" + meta.reduceTime() + ", totalTime=" + meta.totalTime() + ']');
                    }
                    if (state != null) {
                        state = (JobLocalState)this.activeJobs.remove(jobId);
                        assert (state != null);
                        this.ctx.shuffle().jobFinished(jobId);
                    }
                    if ((finishFut = (GridFutureAdapter)this.activeFinishFuts.remove(jobId)) != null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Completing job future [locNodeId=" + locNodeId + ", meta=" + meta + ']');
                        }
                        finishFut.onDone((Object)jobId, meta.failCause());
                    }
                    if ((jobFut = (GridFutureAdapterEx)this.jobs.get(jobId)).get() == job && this.jobs.remove(jobId, jobFut)) {
                        job.dispose(false);
                        break;
                    }
                    assert (false);
                    continue block9;
                }
                default: {
                    assert (false);
                    continue block9;
                }
            }
        }
    }

    @Nullable
    private Collection<GridHadoopTaskInfo> setupTask(GridHadoopJobId jobId) {
        if (this.activeJobs.containsKey(jobId)) {
            return null;
        }
        this.initState(jobId);
        return Collections.singleton(new GridHadoopTaskInfo(this.ctx.localNodeId(), GridHadoopTaskType.SETUP, jobId, 0, 0, null));
    }

    private Collection<GridHadoopTaskInfo> mapperTasks(Iterable<GridHadoopInputSplit> mappers, GridHadoopJobMetadata meta) {
        UUID locNodeId = this.ctx.localNodeId();
        GridHadoopJobId jobId = meta.jobId();
        JobLocalState state = (JobLocalState)this.activeJobs.get(jobId);
        ArrayList<GridHadoopTaskInfo> tasks = null;
        if (mappers != null) {
            if (state == null) {
                state = this.initState(jobId);
            }
            for (GridHadoopInputSplit split : mappers) {
                if (!state.addMapper(split)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Submitting MAP task for execution [locNodeId=" + locNodeId + ", split=" + split + ']');
                }
                GridHadoopTaskInfo taskInfo = new GridHadoopTaskInfo(locNodeId, GridHadoopTaskType.MAP, jobId, meta.taskNumber(split), 0, split);
                if (tasks == null) {
                    tasks = new ArrayList<GridHadoopTaskInfo>();
                }
                tasks.add(taskInfo);
            }
        }
        return tasks;
    }

    private Collection<GridHadoopTaskInfo> reducerTasks(int[] reducers, GridHadoopJob job) {
        UUID locNodeId = this.ctx.localNodeId();
        GridHadoopJobId jobId = job.id();
        JobLocalState state = (JobLocalState)this.activeJobs.get(jobId);
        ArrayList<GridHadoopTaskInfo> tasks = null;
        if (reducers != null) {
            if (state == null) {
                state = this.initState(job.id());
            }
            for (int rdc : reducers) {
                if (!state.addReducer(rdc)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Submitting REDUCE task for execution [locNodeId=" + locNodeId + ", rdc=" + rdc + ']');
                }
                GridHadoopTaskInfo taskInfo = new GridHadoopTaskInfo(locNodeId, GridHadoopTaskType.REDUCE, jobId, rdc, 0, null);
                if (tasks == null) {
                    tasks = new ArrayList<GridHadoopTaskInfo>();
                }
                tasks.add(taskInfo);
            }
        }
        return tasks;
    }

    private JobLocalState initState(GridHadoopJobId jobId) {
        return (JobLocalState)F.addIfAbsent(this.activeJobs, (Object)jobId, (Object)new JobLocalState());
    }

    @Nullable
    public GridHadoopJob job(GridHadoopJobId jobId, @Nullable GridHadoopJobInfo jobInfo) throws GridException {
        GridFutureAdapterEx fut = (GridFutureAdapterEx)this.jobs.get(jobId);
        if (fut != null || (fut = this.jobs.putIfAbsent(jobId, (GridFutureAdapterEx<GridHadoopJob>)new GridFutureAdapterEx())) != null) {
            return (GridHadoopJob)fut.get();
        }
        fut = (GridFutureAdapterEx)this.jobs.get(jobId);
        GridHadoopJob job = null;
        try {
            if (jobInfo == null) {
                GridHadoopJobMetadata meta = (GridHadoopJobMetadata)this.jobMetaCache().get((Object)jobId);
                if (meta == null) {
                    throw new GridException("Failed to find job metadata for ID: " + jobId);
                }
                jobInfo = meta.jobInfo();
            }
            job = jobInfo.createJob(jobId);
            job.initialize(false, this.ctx.localNodeId());
            fut.onDone((Object)job);
            return job;
        }
        catch (GridException e) {
            fut.onDone((Throwable)e);
            this.jobs.remove(jobId, fut);
            if (job != null) {
                try {
                    job.dispose(false);
                }
                catch (GridException e0) {
                    U.error((GridLogger)this.log, (Object)("Failed to dispose job: " + jobId), (Throwable)e0);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean killJob(GridHadoopJobId jobId) throws GridException {
        block9: {
            if (!this.busyLock.tryReadLock()) {
                return false;
            }
            try {
                GridHadoopJobMetadata meta = (GridHadoopJobMetadata)this.jobMetaCache().get((Object)jobId);
                if (meta != null && meta.phase() != GridHadoopJobPhase.PHASE_COMPLETE && meta.phase() != GridHadoopJobPhase.PHASE_CANCELLING) {
                    GridHadoopTaskCancelledException err = new GridHadoopTaskCancelledException("Job cancelled.");
                    this.jobMetaCache().transform((Object)jobId, (GridClosure)new CancelJobClosure((Throwable)((Object)err)));
                }
            }
            finally {
                this.busyLock.readUnlock();
            }
            GridFuture<?> fut = this.finishFuture(jobId);
            if (fut != null) {
                try {
                    fut.get();
                }
                catch (Throwable e) {
                    if (!(e.getCause() instanceof GridHadoopTaskCancelledException)) break block9;
                    return true;
                }
            }
        }
        return false;
    }

    private static class CancelJobClosure
    implements GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata> {
        private static final long serialVersionUID = 0L;
        private Collection<GridHadoopInputSplit> splits;
        private Collection<Integer> rdc;
        private Throwable err;

        private CancelJobClosure(Throwable err) {
            this(err, null, null);
        }

        private CancelJobClosure(Collection<GridHadoopInputSplit> splits, Collection<Integer> rdc) {
            this(null, splits, rdc);
        }

        private CancelJobClosure(Throwable err, Collection<GridHadoopInputSplit> splits, Collection<Integer> rdc) {
            this.splits = splits;
            this.rdc = rdc;
            this.err = err;
        }

        public GridHadoopJobMetadata apply(GridHadoopJobMetadata meta) {
            if (meta == null) {
                return null;
            }
            assert (meta.phase() == GridHadoopJobPhase.PHASE_CANCELLING || this.err != null) : "Invalid phase for cancel: " + meta;
            GridHadoopJobMetadata cp = new GridHadoopJobMetadata(meta);
            HashSet<Integer> rdcCp = new HashSet<Integer>(cp.pendingReducers());
            if (this.rdc != null) {
                rdcCp.removeAll(this.rdc);
            }
            cp.pendingReducers(rdcCp);
            HashSet<GridHadoopInputSplit> splitsCp = new HashSet<GridHadoopInputSplit>(cp.pendingSplits());
            if (this.splits != null) {
                splitsCp.removeAll(this.splits);
            }
            cp.pendingSplits(splitsCp);
            cp.phase(GridHadoopJobPhase.PHASE_CANCELLING);
            if (this.err != null) {
                cp.failCause(this.err);
            }
            return cp;
        }
    }

    private static class InitializeReducersClosure
    implements GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata> {
        private static final long serialVersionUID = 0L;
        private Collection<Integer> rdc;
        private GridHadoopProcessDescriptor desc;

        private InitializeReducersClosure(Collection<Integer> rdc, GridHadoopProcessDescriptor desc) {
            assert (!F.isEmpty(rdc));
            assert (desc != null);
            this.rdc = rdc;
            this.desc = desc;
        }

        public GridHadoopJobMetadata apply(GridHadoopJobMetadata meta) {
            GridHadoopJobMetadata cp = new GridHadoopJobMetadata(meta);
            Map<Integer, GridHadoopProcessDescriptor> oldMap = meta.reducersAddresses();
            HashMap<Integer, GridHadoopProcessDescriptor> rdcMap = oldMap == null ? new HashMap<Integer, GridHadoopProcessDescriptor>() : new HashMap<Integer, GridHadoopProcessDescriptor>(oldMap);
            for (Integer r : this.rdc) {
                rdcMap.put(r, this.desc);
            }
            cp.reducersAddresses(rdcMap);
            return cp;
        }
    }

    private static class RemoveReducerClosure
    implements GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata> {
        private static final long serialVersionUID = 0L;
        private int rdc;
        private Throwable err;

        private RemoveReducerClosure(int rdc) {
            this.rdc = rdc;
        }

        private RemoveReducerClosure(int rdc, Throwable err) {
            this.rdc = rdc;
            this.err = err;
        }

        public GridHadoopJobMetadata apply(GridHadoopJobMetadata meta) {
            GridHadoopJobMetadata cp = new GridHadoopJobMetadata(meta);
            HashSet<Integer> rdcCp = new HashSet<Integer>(cp.pendingReducers());
            rdcCp.remove(this.rdc);
            cp.pendingReducers(rdcCp);
            if (this.err != null) {
                cp.phase(GridHadoopJobPhase.PHASE_CANCELLING);
                cp.failCause(this.err);
            }
            return cp;
        }
    }

    private static class RemoveMappersClosure
    implements GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata> {
        private static final long serialVersionUID = 0L;
        private Collection<GridHadoopInputSplit> splits;
        private Throwable err;

        private RemoveMappersClosure(GridHadoopInputSplit split, Throwable err) {
            this(Collections.singletonList(split), err);
        }

        private RemoveMappersClosure(Collection<GridHadoopInputSplit> splits, Throwable err) {
            this.splits = splits;
            this.err = err;
        }

        public GridHadoopJobMetadata apply(GridHadoopJobMetadata meta) {
            GridHadoopJobMetadata cp = new GridHadoopJobMetadata(meta);
            HashSet<GridHadoopInputSplit> splitsCp = new HashSet<GridHadoopInputSplit>(cp.pendingSplits());
            splitsCp.removeAll(this.splits);
            cp.pendingSplits(splitsCp);
            if (cp.phase() != GridHadoopJobPhase.PHASE_CANCELLING && this.err != null) {
                cp.failCause(this.err);
            }
            if (this.err != null) {
                cp.phase(GridHadoopJobPhase.PHASE_CANCELLING);
            }
            if (splitsCp.isEmpty() && cp.phase() != GridHadoopJobPhase.PHASE_CANCELLING) {
                cp.phase(GridHadoopJobPhase.PHASE_REDUCE);
                cp.mapCompleteTimestamp(System.currentTimeMillis());
            }
            return cp;
        }
    }

    private static class UpdatePhaseClosure
    implements GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata> {
        private static final long serialVersionUID = 0L;
        private GridHadoopJobPhase phase;

        private UpdatePhaseClosure(GridHadoopJobPhase phase) {
            this.phase = phase;
        }

        public GridHadoopJobMetadata apply(GridHadoopJobMetadata meta) {
            GridHadoopJobMetadata cp = new GridHadoopJobMetadata(meta);
            cp.phase(this.phase);
            if (this.phase == GridHadoopJobPhase.PHASE_MAP) {
                cp.setupCompleteTimestamp(System.currentTimeMillis());
            } else if (this.phase == GridHadoopJobPhase.PHASE_COMPLETE) {
                cp.completeTimestamp(System.currentTimeMillis());
            }
            return cp;
        }
    }

    private class JobLocalState {
        private Collection<GridHadoopInputSplit> currMappers = new HashSet<GridHadoopInputSplit>();
        private Collection<Integer> currReducers = new HashSet<Integer>();
        private AtomicInteger completedMappersCnt = new AtomicInteger();
        private boolean cancelled;
        private boolean aborted;

        private JobLocalState() {
        }

        private boolean addMapper(GridHadoopInputSplit mapSplit) {
            return this.currMappers.add(mapSplit);
        }

        private boolean addReducer(int rdc) {
            return this.currReducers.add(rdc);
        }

        public boolean mapperScheduled(GridHadoopInputSplit mapSplit) {
            return this.currMappers.contains(mapSplit);
        }

        public boolean reducerScheduled(int rdc) {
            return this.currReducers.contains(rdc);
        }

        private void onSetupFinished(GridHadoopTaskInfo taskInfo, GridHadoopTaskStatus status) {
            GridHadoopJobId jobId = taskInfo.jobId();
            if (status.state() == GridHadoopTaskState.FAILED || status.state() == GridHadoopTaskState.CRASHED) {
                GridHadoopJobTracker.this.transform(jobId, (GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata>)new CancelJobClosure(status.failCause()));
            } else {
                GridHadoopJobTracker.this.transform(jobId, (GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata>)new UpdatePhaseClosure(GridHadoopJobPhase.PHASE_MAP));
            }
        }

        private void onMapFinished(final GridHadoopTaskInfo taskInfo, GridHadoopTaskStatus status) throws GridException {
            boolean lastMapperFinished;
            final GridHadoopJobId jobId = taskInfo.jobId();
            GridHadoopJob job = GridHadoopJobTracker.this.job(jobId, null);
            boolean bl = lastMapperFinished = this.completedMappersCnt.incrementAndGet() == this.currMappers.size();
            if (status.state() == GridHadoopTaskState.FAILED || status.state() == GridHadoopTaskState.CRASHED) {
                GridHadoopJobTracker.this.transform(jobId, (GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata>)new RemoveMappersClosure(taskInfo.inputSplit(), status.failCause()));
                return;
            }
            if (job.info().hasCombiner() && GridHadoopJobProperty.get((GridHadoopJobInfo)job.info(), (GridHadoopJobProperty)GridHadoopJobProperty.SINGLE_COMBINER_FOR_ALL_MAPPERS, (boolean)false) && status.state() != GridHadoopTaskState.CANCELED) {
                if (lastMapperFinished) {
                    GridHadoopTaskInfo info = new GridHadoopTaskInfo(GridHadoopJobTracker.this.ctx.localNodeId(), GridHadoopTaskType.COMBINE, jobId, ((GridHadoopJobMetadata)GridHadoopJobTracker.this.jobMetaCache().get((Object)jobId)).taskNumber(GridHadoopJobTracker.this.ctx.localNodeId()), taskInfo.attempt(), null);
                    GridHadoopJobTracker.this.ctx.taskExecutor().run(job, Collections.singletonList(info));
                }
            } else {
                CIX1 cacheUpdater = new CIX1<GridFuture<?>>(){

                    public void applyx(GridFuture<?> f) {
                        GridException err = null;
                        if (f != null) {
                            try {
                                f.get();
                            }
                            catch (GridException e) {
                                err = e;
                            }
                        }
                        GridHadoopJobTracker.this.transform(jobId, (GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata>)new RemoveMappersClosure(taskInfo.inputSplit(), (Throwable)err));
                    }
                };
                if (lastMapperFinished) {
                    GridHadoopJobTracker.this.ctx.shuffle().flush(jobId).listenAsync((GridInClosure)cacheUpdater);
                } else {
                    cacheUpdater.apply(null);
                }
            }
        }

        private void onReduceFinished(GridHadoopTaskInfo taskInfo, GridHadoopTaskStatus status) {
            GridHadoopJobId jobId = taskInfo.jobId();
            if (status.state() == GridHadoopTaskState.FAILED || status.state() == GridHadoopTaskState.CRASHED) {
                GridHadoopJobTracker.this.transform(jobId, (GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata>)new RemoveReducerClosure(taskInfo.taskNumber(), status.failCause()));
            } else {
                GridHadoopJobTracker.this.transform(jobId, (GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata>)new RemoveReducerClosure(taskInfo.taskNumber()));
            }
        }

        private void onCombineFinished(GridHadoopTaskInfo taskInfo, GridHadoopTaskStatus status) {
            final GridHadoopJobId jobId = taskInfo.jobId();
            if (status.state() == GridHadoopTaskState.FAILED || status.state() == GridHadoopTaskState.CRASHED) {
                GridHadoopJobTracker.this.transform(jobId, (GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata>)new RemoveMappersClosure(this.currMappers, status.failCause()));
            } else {
                GridHadoopJobTracker.this.ctx.shuffle().flush(jobId).listenAsync((GridInClosure)new CIX1<GridFuture<?>>(){

                    public void applyx(GridFuture<?> f) {
                        GridException err = null;
                        if (f != null) {
                            try {
                                f.get();
                            }
                            catch (GridException e) {
                                err = e;
                            }
                        }
                        GridHadoopJobTracker.this.transform(jobId, (GridClosure<GridHadoopJobMetadata, GridHadoopJobMetadata>)new RemoveMappersClosure(JobLocalState.this.currMappers, (Throwable)err));
                    }
                });
            }
        }

        public boolean onCancel() {
            if (!this.cancelled && !this.aborted) {
                this.cancelled = true;
                return true;
            }
            return false;
        }

        public boolean onAborted() {
            if (!this.aborted) {
                this.aborted = true;
                return true;
            }
            return false;
        }
    }

    private abstract class EventHandler
    implements Runnable {
        private EventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!GridHadoopJobTracker.this.busyLock.tryReadLock()) {
                return;
            }
            try {
                this.body();
            }
            catch (Throwable e) {
                U.error((GridLogger)GridHadoopJobTracker.this.log, (Object)"Unhandled exception while processing event.", (Throwable)e);
            }
            finally {
                GridHadoopJobTracker.this.busyLock.readUnlock();
            }
        }

        protected abstract void body() throws Exception;
    }
}

