/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.planner;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.gridgain.grid.hadoop.GridHadoopInputSplit;
import org.gridgain.grid.hadoop.GridHadoopMapReducePlan;
import org.jetbrains.annotations.Nullable;

public class GridHadoopDefaultMapReducePlan
implements GridHadoopMapReducePlan {
    private static final long serialVersionUID = 0L;
    private Map<UUID, Collection<GridHadoopInputSplit>> mappers;
    private Map<UUID, int[]> reducers;
    private int mappersCnt;
    private int reducersCnt;

    public GridHadoopDefaultMapReducePlan(Map<UUID, Collection<GridHadoopInputSplit>> mappers, Map<UUID, int[]> reducers) {
        this.mappers = mappers;
        this.reducers = reducers;
        if (mappers != null) {
            for (Collection<GridHadoopInputSplit> splits : mappers.values()) {
                this.mappersCnt += splits.size();
            }
        }
        if (reducers != null) {
            for (int[] rdcrs : reducers.values()) {
                this.reducersCnt += rdcrs.length;
            }
        }
    }

    public int mappers() {
        return this.mappersCnt;
    }

    public int reducers() {
        return this.reducersCnt;
    }

    public UUID nodeForReducer(int reducer) {
        assert (reducer >= 0 && reducer < this.reducersCnt) : reducer;
        for (Map.Entry<UUID, int[]> entry : this.reducers.entrySet()) {
            for (int r : entry.getValue()) {
                if (r != reducer) continue;
                return entry.getKey();
            }
        }
        throw new IllegalStateException("Not found reducer index: " + reducer);
    }

    @Nullable
    public Collection<GridHadoopInputSplit> mappers(UUID nodeId) {
        return this.mappers.get(nodeId);
    }

    @Nullable
    public int[] reducers(UUID nodeId) {
        return this.reducers.get(nodeId);
    }

    public Collection<UUID> mapperNodeIds() {
        return this.mappers.keySet();
    }

    public Collection<UUID> reducerNodeIds() {
        return this.reducers.keySet();
    }
}

