/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.proto;

import java.util.UUID;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.compute.GridComputeJobContext;
import org.gridgain.grid.hadoop.GridHadoop;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.hadoop.GridHadoopJobStatus;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolTaskAdapter;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolTaskArguments;
import org.gridgain.grid.lang.GridInClosure;
import org.gridgain.grid.util.typedef.F;

public class GridHadoopProtocolJobStatusTask
extends GridHadoopProtocolTaskAdapter<GridHadoopJobStatus> {
    private static final long serialVersionUID = 0L;
    private static final long DFLT_POLL_DELAY = 100L;
    private static final String ATTR_HELD = "held";

    @Override
    public GridHadoopJobStatus run(final GridComputeJobContext jobCtx, GridHadoop hadoop, GridHadoopProtocolTaskArguments args) throws GridException {
        UUID nodeId = UUID.fromString((String)args.get(0));
        Integer id = (Integer)args.get(1);
        Long pollDelay = (Long)args.get(2);
        assert (nodeId != null);
        assert (id != null);
        GridHadoopJobId jobId = new GridHadoopJobId(nodeId, id.intValue());
        if (pollDelay == null) {
            pollDelay = 100L;
        }
        if (pollDelay > 0L) {
            GridFuture fut = hadoop.finishFuture(jobId);
            if (fut != null) {
                if (fut.isDone() || F.eq((Object)jobCtx.getAttribute((Object)ATTR_HELD), (Object)true)) {
                    return hadoop.status(jobId);
                }
                fut.listenAsync(new GridInClosure<GridFuture<?>>(){

                    public void apply(GridFuture<?> fut0) {
                        jobCtx.callcc();
                    }
                });
                jobCtx.setAttribute((Object)ATTR_HELD, (Object)true);
                return (GridHadoopJobStatus)jobCtx.holdcc(pollDelay.longValue());
            }
            return null;
        }
        return hadoop.status(jobId);
    }
}

