/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.proto;

import java.util.UUID;
import org.gridgain.grid.GridException;
import org.gridgain.grid.compute.GridComputeJobContext;
import org.gridgain.grid.hadoop.GridHadoop;
import org.gridgain.grid.hadoop.GridHadoopDefaultJobInfo;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.hadoop.GridHadoopJobInfo;
import org.gridgain.grid.hadoop.GridHadoopJobPhase;
import org.gridgain.grid.hadoop.GridHadoopJobState;
import org.gridgain.grid.hadoop.GridHadoopJobStatus;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopUtils;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolConfigurationWrapper;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolTaskAdapter;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolTaskArguments;

public class GridHadoopProtocolSubmitJobTask
extends GridHadoopProtocolTaskAdapter<GridHadoopJobStatus> {
    private static final long serialVersionUID = 0L;

    @Override
    public GridHadoopJobStatus run(GridComputeJobContext jobCtx, GridHadoop hadoop, GridHadoopProtocolTaskArguments args) throws GridException {
        UUID nodeId = UUID.fromString((String)args.get(0));
        Integer id = (Integer)args.get(1);
        GridHadoopProtocolConfigurationWrapper conf = (GridHadoopProtocolConfigurationWrapper)args.get(2);
        assert (nodeId != null);
        assert (id != null);
        assert (conf != null);
        GridHadoopJobId jobId = new GridHadoopJobId(nodeId, id.intValue());
        GridHadoopDefaultJobInfo info = new GridHadoopDefaultJobInfo(conf.get());
        hadoop.submit(jobId, (GridHadoopJobInfo)info);
        GridHadoopJobStatus res = hadoop.status(jobId);
        if (res == null) {
            res = new GridHadoopJobStatus(jobId, GridHadoopJobState.STATE_FAILED, info.configuration().getJobName(), info.configuration().getUser(), 0, 0, 0, 0, 0L, -1L, -1L, GridHadoopJobPhase.PHASE_CANCELLING, GridHadoopUtils.SPECULATIVE_CONCURRENCY, 1L);
        }
        return res;
    }
}

