/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.shuffle;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.AtomicLong;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.kernal.processors.hadoop.message.GridHadoopMessage;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopShuffleMessage
implements GridHadoopMessage,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final AtomicLong ids = new AtomicLong();
    private static final byte MARKER_KEY = 17;
    private static final byte MARKER_VALUE = 31;
    private long msgId;
    private GridHadoopJobId jobId;
    private int reducer;
    private byte[] buf;
    private int off;

    public GridHadoopShuffleMessage() {
    }

    public GridHadoopShuffleMessage(GridHadoopJobId jobId, int reducer, int size) {
        assert (jobId != null);
        this.buf = new byte[size];
        this.jobId = jobId;
        this.reducer = reducer;
        this.msgId = ids.incrementAndGet();
    }

    public long id() {
        return this.msgId;
    }

    public GridHadoopJobId jobId() {
        return this.jobId;
    }

    public int reducer() {
        return this.reducer;
    }

    public byte[] buffer() {
        return this.buf;
    }

    public int offset() {
        return this.off;
    }

    public boolean available(int size, boolean valOnly) {
        if (this.off + (size += valOnly ? 5 : 10) > this.buf.length) {
            if (this.off == 0) {
                this.buf = new byte[size];
                return true;
            }
            return false;
        }
        return true;
    }

    public void addKey(long keyPtr, int keySize) {
        this.add((byte)17, keyPtr, keySize);
    }

    public void addValue(long valPtr, int valSize) {
        this.add((byte)31, valPtr, valSize);
    }

    private void add(byte marker, long ptr, int size) {
        this.buf[this.off++] = marker;
        GridUnsafeMemory.UNSAFE.putInt(this.buf, GridUnsafeMemory.BYTE_ARR_OFF + (long)this.off, size);
        this.off += 4;
        GridUnsafeMemory.UNSAFE.copyMemory(null, ptr, this.buf, GridUnsafeMemory.BYTE_ARR_OFF + (long)this.off, size);
        this.off += size;
    }

    public void visit(Visitor v) throws GridException {
        int size;
        for (int i = 0; i < this.off; i += size) {
            byte marker = this.buf[i++];
            size = GridUnsafeMemory.UNSAFE.getInt(this.buf, GridUnsafeMemory.BYTE_ARR_OFF + (long)i);
            i += 4;
            if (marker == 31) {
                v.onValue(this.buf, i, size);
                continue;
            }
            if (marker == 17) {
                v.onKey(this.buf, i, size);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.jobId.writeExternal(out);
        out.writeLong(this.msgId);
        out.writeInt(this.reducer);
        out.writeInt(this.off);
        U.writeByteArray((DataOutput)out, (byte[])this.buf);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobId = new GridHadoopJobId();
        this.jobId.readExternal(in);
        this.msgId = in.readLong();
        this.reducer = in.readInt();
        this.off = in.readInt();
        this.buf = U.readByteArray((DataInput)in);
    }

    public String toString() {
        return S.toString(GridHadoopShuffleMessage.class, (Object)this);
    }

    public static interface Visitor {
        public void onKey(byte[] var1, int var2, int var3) throws GridException;

        public void onValue(byte[] var1, int var2, int var3) throws GridException;
    }
}

