/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.shuffle.collections;

import java.io.DataInput;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopJob;
import org.gridgain.grid.hadoop.GridHadoopTaskInput;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopHashMultimapBase;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopMultimap;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopMultimapBase;
import org.gridgain.grid.util.GridLongList;
import org.gridgain.grid.util.GridRandom;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridHadoopConcurrentHashMultimap
extends GridHadoopHashMultimapBase {
    private final AtomicReference<State> state = new AtomicReference<State>(State.READING_WRITING);
    private volatile AtomicLongArray oldTbl;
    private volatile AtomicLongArray newTbl;
    private final AtomicInteger keys = new AtomicInteger();
    private final CopyOnWriteArrayList<AdderImpl> adders = new CopyOnWriteArrayList();
    private final AtomicInteger inputs = new AtomicInteger();

    public GridHadoopConcurrentHashMultimap(GridHadoopJob job, GridUnsafeMemory mem, int cap) {
        super(job, mem);
        assert (U.isPow2((int)cap));
        this.newTbl = this.oldTbl = new AtomicLongArray(cap);
    }

    public long keys() {
        int res = this.keys.get();
        for (AdderImpl adder : this.adders) {
            res += adder.localKeys.get();
        }
        return res;
    }

    @Override
    public int capacity() {
        return this.oldTbl.length();
    }

    @Override
    public GridHadoopMultimap.Adder startAdding() throws GridException {
        if (this.inputs.get() != 0) {
            throw new IllegalStateException("Active inputs.");
        }
        if (this.state.get() == State.CLOSING) {
            throw new IllegalStateException("Closed.");
        }
        return new AdderImpl();
    }

    @Override
    public void close() {
        assert (this.inputs.get() == 0) : this.inputs.get();
        assert (this.adders.isEmpty()) : this.adders.size();
        this.state(State.READING_WRITING, State.CLOSING);
        if (this.keys() == 0L) {
            return;
        }
        super.close();
    }

    @Override
    protected long meta(int idx) {
        return this.oldTbl.get(idx);
    }

    @Override
    public boolean visit(boolean ignoreLastVisited, GridHadoopMultimap.Visitor v) throws GridException {
        if (!this.state.compareAndSet(State.READING_WRITING, State.VISITING)) {
            assert (this.state.get() != State.CLOSING);
            return false;
        }
        AtomicLongArray tbl0 = this.oldTbl;
        for (int i = 0; i < tbl0.length(); ++i) {
            long meta = tbl0.get(i);
            while (meta != 0L) {
                long lastVisited;
                long valPtr = this.value(meta);
                long l = lastVisited = ignoreLastVisited ? 0L : this.lastVisitedValue(meta);
                if (valPtr != lastVisited) {
                    v.onKey(this.key(meta), this.keySize(meta));
                    this.lastVisitedValue(meta, valPtr);
                    do {
                        v.onValue(valPtr + 12L, this.valueSize(valPtr));
                    } while ((valPtr = this.nextValue(valPtr)) != lastVisited);
                }
                meta = this.collision(meta);
            }
        }
        this.state(State.VISITING, State.READING_WRITING);
        return true;
    }

    @Override
    public GridHadoopTaskInput input(Comparator<Object> ignore) throws GridException {
        this.inputs.incrementAndGet();
        if (!this.adders.isEmpty()) {
            throw new IllegalStateException("Active adders.");
        }
        State s = this.state.get();
        if (s == State.CLOSING) {
            throw new IllegalStateException("Closed.");
        }
        assert (s != State.REHASHING);
        return new GridHadoopHashMultimapBase.Input(){

            @Override
            public void close() throws GridException {
                if (GridHadoopConcurrentHashMultimap.this.inputs.decrementAndGet() < 0) {
                    throw new IllegalStateException();
                }
                super.close();
            }
        };
    }

    private void rehashIfNeeded(AtomicLongArray fromTbl) {
        AtomicLongArray toTbl;
        if (fromTbl.length() == Integer.MAX_VALUE) {
            return;
        }
        long keys0 = this.keys();
        if (keys0 < (long)(3 * (fromTbl.length() >>> 2))) {
            return;
        }
        if (fromTbl != this.newTbl) {
            return;
        }
        if (!this.state.compareAndSet(State.READING_WRITING, State.REHASHING)) {
            assert (this.state.get() != State.CLOSING);
            return;
        }
        if (fromTbl != this.newTbl) {
            this.state(State.REHASHING, State.READING_WRITING);
            return;
        }
        int newLen = fromTbl.length();
        while ((long)(newLen <<= 1) < keys0) {
        }
        if (keys0 >= (long)(3 * (newLen >>> 2))) {
            newLen <<= 1;
        }
        this.newTbl = toTbl = new AtomicLongArray(newLen);
        int newMask = newLen - 1;
        long failedMeta = 0L;
        GridLongList collisions = new GridLongList(16);
        for (int i = 0; i < fromTbl.length(); ++i) {
            long meta = fromTbl.get(i);
            assert (meta != -1L);
            if (meta == 0L) {
                failedMeta = 0L;
                if (fromTbl.compareAndSet(i, 0L, -1L)) continue;
                --i;
                continue;
            }
            do {
                collisions.add(meta);
            } while ((meta = this.collision(meta)) != failedMeta);
            do {
                long toCollision;
                meta = collisions.remove();
                int addr = this.keyHash(meta) & newMask;
                do {
                    toCollision = toTbl.get(addr);
                    this.collision(meta, toCollision);
                } while (!toTbl.compareAndSet(addr, toCollision, meta));
            } while (!collisions.isEmpty());
            if (!fromTbl.compareAndSet(i, meta, -1L)) {
                failedMeta = meta;
                --i;
                continue;
            }
            failedMeta = 0L;
        }
        this.oldTbl = toTbl;
        this.state(State.REHASHING, State.READING_WRITING);
    }

    private void state(State oldState, State newState) {
        if (!this.state.compareAndSet(oldState, newState)) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected long value(long meta) {
        return this.mem.readLongVolatile(meta + 16L);
    }

    private boolean casValue(long meta, long oldValPtr, long newValPtr) {
        return this.mem.casLong(meta + 16L, oldValPtr, newValPtr);
    }

    @Override
    protected long collision(long meta) {
        return this.mem.readLongVolatile(meta + 24L);
    }

    @Override
    protected void collision(long meta, long collision) {
        assert (meta != collision) : meta;
        this.mem.writeLongVolatile(meta + 24L, collision);
    }

    private long lastVisitedValue(long meta) {
        return this.mem.readLong(meta + 32L);
    }

    private void lastVisitedValue(long meta, long valPtr) {
        this.mem.writeLong(meta + 32L, valPtr);
    }

    private static enum State {
        REHASHING,
        VISITING,
        READING_WRITING,
        CLOSING;

    }

    public class AdderImpl
    extends GridHadoopMultimapBase.AdderBase {
        private final GridHadoopHashMultimapBase.Reader keyReader;
        private final AtomicInteger localKeys;
        private final Random rnd;

        public AdderImpl() throws GridException {
            super(GridHadoopConcurrentHashMultimap.this);
            this.localKeys = new AtomicInteger();
            this.rnd = new GridRandom();
            this.keyReader = new GridHadoopHashMultimapBase.Reader(GridHadoopConcurrentHashMultimap.this, this.keySer);
            GridHadoopConcurrentHashMultimap.this.rehashIfNeeded(GridHadoopConcurrentHashMultimap.this.oldTbl);
            GridHadoopConcurrentHashMultimap.this.adders.add(this);
        }

        @Override
        public GridHadoopMultimap.Key addKey(DataInput in, @Nullable GridHadoopMultimap.Key reuse) throws GridException {
            KeyImpl k = reuse == null ? new KeyImpl() : (KeyImpl)reuse;
            k.tmpKey = this.keySer.read(in, k.tmpKey);
            k.meta = this.add(k.tmpKey, null);
            return k;
        }

        public void write(Object key, Object val) throws GridException {
            A.notNull((Object)val, (String)"val");
            this.add(key, val);
        }

        private void incrementKeys(AtomicLongArray tbl) {
            this.localKeys.lazySet(this.localKeys.get() + 1);
            if (this.rnd.nextInt(tbl.length()) < 512) {
                GridHadoopConcurrentHashMultimap.this.rehashIfNeeded(tbl);
            }
        }

        private long createMeta(int keyHash, int keySize, long keyPtr, long valPtr, long collisionPtr, long lastVisitedVal) {
            long meta = this.allocate(40);
            GridHadoopConcurrentHashMultimap.this.mem.writeInt(meta, keyHash);
            GridHadoopConcurrentHashMultimap.this.mem.writeInt(meta + 4L, keySize);
            GridHadoopConcurrentHashMultimap.this.mem.writeLong(meta + 8L, keyPtr);
            GridHadoopConcurrentHashMultimap.this.mem.writeLong(meta + 16L, valPtr);
            GridHadoopConcurrentHashMultimap.this.mem.writeLong(meta + 24L, collisionPtr);
            GridHadoopConcurrentHashMultimap.this.mem.writeLong(meta + 32L, lastVisitedVal);
            return meta;
        }

        private long add(Object key, @Nullable Object val) throws GridException {
            AtomicLongArray tbl = GridHadoopConcurrentHashMultimap.this.oldTbl;
            int keyHash = U.hash((int)key.hashCode());
            long newMetaPtr = 0L;
            long valPtr = 0L;
            if (val != null) {
                valPtr = this.write(12, val, this.valSer);
                int valSize = this.writtenSize() - 12;
                GridHadoopConcurrentHashMultimap.this.valueSize(valPtr, valSize);
            }
            AtomicLongArray old = null;
            while (true) {
                int addr;
                long metaPtrRoot;
                if ((metaPtrRoot = tbl.get(addr = keyHash & tbl.length() - 1)) == -1L) {
                    AtomicLongArray n = GridHadoopConcurrentHashMultimap.this.newTbl;
                    AtomicLongArray o = GridHadoopConcurrentHashMultimap.this.oldTbl;
                    tbl = tbl == o ? n : o;
                    old = null;
                    continue;
                }
                if (metaPtrRoot != 0L) {
                    AtomicLongArray n;
                    long metaPtr = metaPtrRoot;
                    do {
                        if (GridHadoopConcurrentHashMultimap.this.keyHash(metaPtr) != keyHash || !key.equals(this.keyReader.readKey(metaPtr))) continue;
                        if (newMetaPtr != 0L) {
                            this.localDeallocate(GridHadoopConcurrentHashMultimap.this.key(newMetaPtr));
                        }
                        if (valPtr != 0L) {
                            long nextValPtr;
                            do {
                                nextValPtr = GridHadoopConcurrentHashMultimap.this.value(metaPtr);
                                GridHadoopConcurrentHashMultimap.this.nextValue(valPtr, nextValPtr);
                            } while (!GridHadoopConcurrentHashMultimap.this.casValue(metaPtr, nextValPtr, valPtr));
                        }
                        return metaPtr;
                    } while ((metaPtr = GridHadoopConcurrentHashMultimap.this.collision(metaPtr)) != 0L);
                    if (old == null && (n = GridHadoopConcurrentHashMultimap.this.newTbl) != tbl) {
                        old = tbl;
                        tbl = n;
                        continue;
                    }
                }
                if (old != null) {
                    tbl = old;
                    addr = keyHash & tbl.length() - 1;
                    old = null;
                }
                if (newMetaPtr == 0L) {
                    long keyPtr = this.write(0, key, this.keySer);
                    int keySize = this.writtenSize();
                    if (valPtr != 0L) {
                        GridHadoopConcurrentHashMultimap.this.nextValue(valPtr, 0L);
                    }
                    newMetaPtr = this.createMeta(keyHash, keySize, keyPtr, valPtr, metaPtrRoot, 0L);
                } else {
                    GridHadoopConcurrentHashMultimap.this.collision(newMetaPtr, metaPtrRoot);
                }
                if (tbl.compareAndSet(addr, metaPtrRoot, newMetaPtr)) break;
            }
            this.incrementKeys(tbl);
            return newMetaPtr;
        }

        @Override
        public void close() throws GridException {
            if (!GridHadoopConcurrentHashMultimap.this.adders.remove(this)) {
                throw new IllegalStateException();
            }
            GridHadoopConcurrentHashMultimap.this.keys.addAndGet(this.localKeys.get());
            super.close();
        }

        public class KeyImpl
        implements GridHadoopMultimap.Key {
            private long meta;
            private Object tmpKey;

            public long address() {
                return this.meta;
            }

            @Override
            public void add(GridHadoopMultimap.Value val) {
                long nextVal;
                int size = val.size();
                long valPtr = AdderImpl.this.allocate(size + 12);
                val.copyTo(valPtr + 12L);
                GridHadoopConcurrentHashMultimap.this.valueSize(valPtr, size);
                do {
                    nextVal = GridHadoopConcurrentHashMultimap.this.value(this.meta);
                    GridHadoopConcurrentHashMultimap.this.nextValue(valPtr, nextVal);
                } while (!GridHadoopConcurrentHashMultimap.this.casValue(this.meta, nextVal, valPtr));
            }
        }
    }
}

