/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.shuffle.collections;

import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopJob;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopHashMultimapBase;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopMultimap;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopMultimapBase;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopHashMultimap
extends GridHadoopHashMultimapBase {
    private long[] tbl;
    private int keys;

    public GridHadoopHashMultimap(GridHadoopJob job, GridUnsafeMemory mem, int cap) {
        super(job, mem);
        assert (U.isPow2((int)cap)) : cap;
        this.tbl = new long[cap];
    }

    @Override
    public GridHadoopMultimap.Adder startAdding() throws GridException {
        return new AdderImpl();
    }

    private void rehash() {
        long[] newTbl = new long[this.tbl.length << 1];
        int newMask = newTbl.length - 1;
        for (long meta : this.tbl) {
            while (meta != 0L) {
                long collision = this.collision(meta);
                int idx = this.keyHash(meta) & newMask;
                this.collision(meta, newTbl[idx]);
                newTbl[idx] = meta;
                meta = collision;
            }
        }
        this.tbl = newTbl;
    }

    public int keys() {
        return this.keys;
    }

    @Override
    public int capacity() {
        return this.tbl.length;
    }

    @Override
    protected long meta(int idx) {
        return this.tbl[idx];
    }

    private class AdderImpl
    extends GridHadoopMultimapBase.AdderBase {
        private final GridHadoopHashMultimapBase.Reader keyReader;

        protected AdderImpl() throws GridException {
            super(GridHadoopHashMultimap.this);
            this.keyReader = new GridHadoopHashMultimapBase.Reader(this.keySer);
        }

        private long createMeta(int keyHash, int keySize, long keyPtr, long valPtr, long collisionPtr) {
            long meta = this.allocate(32);
            GridHadoopHashMultimap.this.mem.writeInt(meta, keyHash);
            GridHadoopHashMultimap.this.mem.writeInt(meta + 4L, keySize);
            GridHadoopHashMultimap.this.mem.writeLong(meta + 8L, keyPtr);
            GridHadoopHashMultimap.this.mem.writeLong(meta + 16L, valPtr);
            GridHadoopHashMultimap.this.mem.writeLong(meta + 24L, collisionPtr);
            return meta;
        }

        public void write(Object key, Object val) throws GridException {
            A.notNull((Object)val, (String)"val");
            int keyHash = U.hash((int)key.hashCode());
            long valPtr = this.write(12, val, this.valSer);
            int valSize = this.writtenSize() - 12;
            GridHadoopHashMultimap.this.valueSize(valPtr, valSize);
            int idx = keyHash & GridHadoopHashMultimap.this.tbl.length - 1;
            long meta = GridHadoopHashMultimap.this.tbl[idx];
            while (meta != 0L) {
                if (GridHadoopHashMultimap.this.keyHash(meta) == keyHash && key.equals(this.keyReader.readKey(meta))) {
                    GridHadoopHashMultimap.this.nextValue(valPtr, GridHadoopHashMultimap.this.value(meta));
                    GridHadoopHashMultimap.this.value(meta, valPtr);
                    return;
                }
                meta = GridHadoopHashMultimap.this.collision(meta);
            }
            long keyPtr = this.write(0, key, this.keySer);
            int keySize = this.writtenSize();
            GridHadoopHashMultimap.this.nextValue(valPtr, 0L);
            ((GridHadoopHashMultimap)GridHadoopHashMultimap.this).tbl[idx] = this.createMeta(keyHash, keySize, keyPtr, valPtr, GridHadoopHashMultimap.this.tbl[idx]);
            if (++GridHadoopHashMultimap.this.keys > (GridHadoopHashMultimap.this.tbl.length >>> 2) * 3) {
                GridHadoopHashMultimap.this.rehash();
            }
        }
    }
}

