/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.shuffle.collections;

import java.util.Comparator;
import java.util.Iterator;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.hadoop.GridHadoopJob;
import org.gridgain.grid.hadoop.GridHadoopSerialization;
import org.gridgain.grid.hadoop.GridHadoopTaskInput;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopMultimap;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopMultimapBase;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;

public abstract class GridHadoopHashMultimapBase
extends GridHadoopMultimapBase {
    public GridHadoopHashMultimapBase(GridHadoopJob job, GridUnsafeMemory mem) {
        super(job, mem);
    }

    @Override
    public boolean visit(boolean ignoreLastVisited, GridHadoopMultimap.Visitor v) throws GridException {
        throw new UnsupportedOperationException("visit");
    }

    @Override
    public GridHadoopTaskInput input(Comparator<Object> ignore) throws GridException {
        return new Input();
    }

    public abstract int capacity();

    protected abstract long meta(int var1);

    protected int keyHash(long meta) {
        return this.mem.readInt(meta);
    }

    protected int keySize(long meta) {
        return this.mem.readInt(meta + 4L);
    }

    protected long key(long meta) {
        return this.mem.readLong(meta + 8L);
    }

    protected long value(long meta) {
        return this.mem.readLong(meta + 16L);
    }

    protected void value(long meta, long val) {
        this.mem.writeLong(meta + 16L, val);
    }

    protected long collision(long meta) {
        return this.mem.readLong(meta + 24L);
    }

    protected void collision(long meta, long collision) {
        assert (meta != collision) : meta;
        this.mem.writeLong(meta + 24L, collision);
    }

    protected class Input
    implements GridHadoopTaskInput {
        private int idx = -1;
        private long metaPtr;
        private final int cap;
        private Reader keyReader;
        private Reader valReader;

        public Input() throws GridException {
            this.cap = GridHadoopHashMultimapBase.this.capacity();
            this.keyReader = new Reader(GridHadoopHashMultimapBase.this.job.keySerialization());
            this.valReader = new Reader(GridHadoopHashMultimapBase.this.job.valueSerialization());
        }

        public boolean next() {
            if (this.metaPtr != 0L) {
                this.metaPtr = GridHadoopHashMultimapBase.this.collision(this.metaPtr);
                if (this.metaPtr != 0L) {
                    return true;
                }
            }
            while (++this.idx < this.cap) {
                this.metaPtr = GridHadoopHashMultimapBase.this.meta(this.idx);
                if (this.metaPtr == 0L) continue;
                return true;
            }
            return false;
        }

        public Object key() {
            return this.keyReader.readKey(this.metaPtr);
        }

        public Iterator<?> values() {
            return new GridHadoopMultimapBase.ValueIterator(GridHadoopHashMultimapBase.this, GridHadoopHashMultimapBase.this.value(this.metaPtr), this.valReader);
        }

        public void close() throws GridException {
            this.keyReader.close();
            this.valReader.close();
        }
    }

    protected class Reader
    extends GridHadoopMultimapBase.ReaderBase {
        protected Reader(GridHadoopSerialization ser) {
            super(GridHadoopHashMultimapBase.this, ser);
        }

        public Object readKey(long meta) {
            assert (meta > 0L) : meta;
            try {
                return this.read(GridHadoopHashMultimapBase.this.key(meta), GridHadoopHashMultimapBase.this.keySize(meta));
            }
            catch (GridException e) {
                throw new GridRuntimeException((Throwable)e);
            }
        }
    }
}

