/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.shuffle.collections;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.hadoop.GridHadoopJob;
import org.gridgain.grid.hadoop.GridHadoopJobInfo;
import org.gridgain.grid.hadoop.GridHadoopJobProperty;
import org.gridgain.grid.hadoop.GridHadoopSerialization;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopMultimap;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.streams.GridHadoopDataInStream;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.streams.GridHadoopDataOutStream;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.streams.GridHadoopOffheapBuffer;
import org.gridgain.grid.util.GridLongList;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.jetbrains.annotations.Nullable;

public abstract class GridHadoopMultimapBase
implements GridHadoopMultimap {
    protected final GridHadoopJob job;
    protected final GridUnsafeMemory mem;
    protected final int pageSize;
    private final Collection<GridLongList> allPages = new ConcurrentLinkedQueue<GridLongList>();

    public GridHadoopMultimapBase(GridHadoopJob job, GridUnsafeMemory mem) {
        assert (job != null);
        assert (mem != null);
        this.job = job;
        this.mem = mem;
        this.pageSize = GridHadoopJobProperty.get((GridHadoopJobInfo)job.info(), (GridHadoopJobProperty)GridHadoopJobProperty.SHUFFLE_OFFHEAP_PAGE_SIZE, (int)16384);
    }

    private void deallocate(GridLongList ptrs) {
        while (!ptrs.isEmpty()) {
            this.mem.release(ptrs.remove(), ptrs.remove());
        }
    }

    protected void nextValue(long valPtr, long nextValPtr) {
        this.mem.writeLong(valPtr, nextValPtr);
    }

    protected long nextValue(long valPtr) {
        return this.mem.readLong(valPtr);
    }

    protected void valueSize(long valPtr, int size) {
        this.mem.writeInt(valPtr + 8L, size);
    }

    protected int valueSize(long valPtr) {
        return this.mem.readInt(valPtr + 8L);
    }

    @Override
    public void close() {
        for (GridLongList list : this.allPages) {
            this.deallocate(list);
        }
    }

    protected class ValueIterator
    implements Iterator<Object> {
        private long valPtr;
        private ReaderBase valReader;

        protected ValueIterator(long valPtr, ReaderBase valReader) {
            this.valPtr = valPtr;
            this.valReader = valReader;
        }

        public void head(long valPtr) {
            this.valPtr = valPtr;
        }

        @Override
        public boolean hasNext() {
            return this.valPtr != 0L;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object res = this.valReader.readValue(this.valPtr);
            this.valPtr = GridHadoopMultimapBase.this.nextValue(this.valPtr);
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected abstract class AdderBase
    implements GridHadoopMultimap.Adder {
        protected final GridHadoopSerialization keySer;
        protected final GridHadoopSerialization valSer;
        private final GridHadoopDataOutStream out;
        private long writeStart;
        private final GridLongList pages = new GridLongList(16);

        protected AdderBase() throws GridException {
            this.valSer = GridHadoopMultimapBase.this.job.valueSerialization();
            this.keySer = GridHadoopMultimapBase.this.job.keySerialization();
            this.out = new GridHadoopDataOutStream(GridHadoopMultimapBase.this.mem){

                @Override
                public long move(long size) {
                    long ptr = super.move(size);
                    if (ptr == 0L) {
                        ptr = AdderBase.this.allocateNextPage(size);
                    }
                    assert (ptr != 0L);
                    return ptr;
                }
            };
        }

        private long allocateNextPage(long requestedSize) {
            int writtenSize = this.writtenSize();
            long newPageSize = Math.max((long)writtenSize + requestedSize, (long)GridHadoopMultimapBase.this.pageSize);
            long newPagePtr = GridHadoopMultimapBase.this.mem.allocate(newPageSize);
            this.pages.add(newPageSize);
            this.pages.add(newPagePtr);
            GridHadoopOffheapBuffer b = this.out.buffer();
            b.set(newPagePtr, newPageSize);
            if (writtenSize != 0) {
                GridHadoopMultimapBase.this.mem.copyMemory(this.writeStart, newPagePtr, (long)writtenSize);
                b.move(writtenSize);
            }
            this.writeStart = newPagePtr;
            return b.move(requestedSize);
        }

        private long fixAlignment() {
            GridHadoopOffheapBuffer b = this.out.buffer();
            long ptr = b.pointer();
            if ((ptr & 7L) != 0L) {
                ptr = ptr + 8L & 0xFFFFFFFFFFFFFFF8L;
                b.pointer(ptr);
            }
            return ptr;
        }

        protected long write(int off, Object o, GridHadoopSerialization ser) throws GridException {
            this.writeStart = this.fixAlignment();
            if (off != 0) {
                this.out.move(off);
            }
            ser.write((DataOutput)this.out, o);
            return this.writeStart;
        }

        protected long allocate(int size) {
            this.writeStart = this.fixAlignment();
            this.out.move(size);
            return this.writeStart;
        }

        protected void localDeallocate(long ptr) {
            GridHadoopOffheapBuffer b = this.out.buffer();
            if (b.isInside(ptr)) {
                b.pointer(ptr);
            } else {
                b.reset();
            }
        }

        protected int writtenSize() {
            return (int)(this.out.buffer().pointer() - this.writeStart);
        }

        @Override
        public GridHadoopMultimap.Key addKey(DataInput in, @Nullable GridHadoopMultimap.Key reuse) throws GridException {
            throw new UnsupportedOperationException();
        }

        public void close() throws GridException {
            GridHadoopMultimapBase.this.allPages.add(this.pages);
            this.keySer.close();
            this.valSer.close();
        }
    }

    protected class ReaderBase
    implements AutoCloseable {
        private Object tmp;
        private final GridHadoopSerialization ser;
        private final GridHadoopDataInStream in;

        protected ReaderBase(GridHadoopSerialization ser) {
            this.in = new GridHadoopDataInStream(GridHadoopMultimapBase.this.mem);
            assert (ser != null);
            this.ser = ser;
        }

        public Object readValue(long valPtr) {
            assert (valPtr > 0L) : valPtr;
            try {
                return this.read(valPtr + 12L, GridHadoopMultimapBase.this.valueSize(valPtr));
            }
            catch (GridException e) {
                throw new GridRuntimeException((Throwable)e);
            }
        }

        public void resetReusedObject(Object tmp) {
            this.tmp = tmp;
        }

        protected Object read(long ptr, long size) throws GridException {
            this.in.buffer().set(ptr, size);
            this.tmp = this.ser.read((DataInput)this.in, this.tmp);
            return this.tmp;
        }

        @Override
        public void close() throws GridException {
            this.ser.close();
        }
    }
}

