/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.shuffle.collections;

import java.io.DataInput;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.hadoop.GridHadoopJob;
import org.gridgain.grid.hadoop.GridHadoopSerialization;
import org.gridgain.grid.hadoop.GridHadoopTaskInput;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopMultimap;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopMultimapBase;
import org.gridgain.grid.util.GridLongList;
import org.gridgain.grid.util.GridRandom;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.gridgain.grid.util.typedef.internal.A;
import org.jetbrains.annotations.Nullable;

public class GridHadoopSkipList
extends GridHadoopMultimapBase {
    private final Comparator cmp;
    private final AtomicInteger topLevel = new AtomicInteger(-1);
    private final AtomicLongArray heads = new AtomicLongArray(33);
    private final AtomicBoolean visitGuard = new AtomicBoolean();

    public GridHadoopSkipList(GridHadoopJob job, GridUnsafeMemory mem, Comparator cmp) {
        super(job, mem);
        assert (cmp != null);
        this.cmp = cmp;
    }

    @Override
    public boolean visit(boolean ignoreLastVisited, GridHadoopMultimap.Visitor v) throws GridException {
        if (!this.visitGuard.compareAndSet(false, true)) {
            return false;
        }
        long meta = this.heads.get(0);
        while (meta != 0L) {
            long lastVisited;
            long valPtr = this.value(meta);
            long l = lastVisited = ignoreLastVisited ? 0L : this.lastVisitedValue(meta);
            if (valPtr != lastVisited) {
                long k = this.key(meta);
                v.onKey(k + 4L, this.keySize(k));
                this.lastVisitedValue(meta, valPtr);
                do {
                    v.onValue(valPtr + 12L, this.valueSize(valPtr));
                } while ((valPtr = this.nextValue(valPtr)) != lastVisited);
            }
            meta = this.nextMeta(meta, 0);
        }
        this.visitGuard.lazySet(false);
        return true;
    }

    @Override
    public GridHadoopMultimap.Adder startAdding() throws GridException {
        return new AdderImpl();
    }

    @Override
    public GridHadoopTaskInput input(Comparator<Object> groupCmp) throws GridException {
        Input in = new Input();
        if (groupCmp != null && groupCmp.getClass() != this.cmp.getClass()) {
            return new GroupedInput(groupCmp, in);
        }
        return in;
    }

    private long key(long meta) {
        return this.mem.readLong(meta);
    }

    private void key(long meta, long key) {
        this.mem.writeLong(meta, key);
    }

    private long value(long meta) {
        return this.mem.readLongVolatile(meta + 8L);
    }

    private void value(long meta, long valPtr) {
        this.mem.writeLongVolatile(meta + 8L, valPtr);
    }

    private boolean casValue(long meta, long oldValPtr, long newValPtr) {
        return this.mem.casLong(meta + 8L, oldValPtr, newValPtr);
    }

    private long lastVisitedValue(long meta) {
        return this.mem.readLong(meta + 16L);
    }

    private void lastVisitedValue(long meta, long valPtr) {
        this.mem.writeLong(meta + 16L, valPtr);
    }

    private long nextMeta(long meta, int level) {
        return meta == 0L ? this.heads.get(level) : this.mem.readLongVolatile(meta + 24L + (long)(8 * level));
    }

    private boolean casNextMeta(long meta, int level, long oldNext, long newNext) {
        return meta == 0L ? this.heads.compareAndSet(level, oldNext, newNext) : this.mem.casLong(meta + 24L + (long)(8 * level), oldNext, newNext);
    }

    private void nextMeta(long meta, int level, long nextMeta) {
        assert (meta != 0L);
        this.mem.writeLong(meta + 24L + (long)(8 * level), nextMeta);
    }

    private int keySize(long keyPtr) {
        return this.mem.readInt(keyPtr);
    }

    private void keySize(long keyPtr, int keySize) {
        this.mem.writeInt(keyPtr, keySize);
    }

    static int randomLevel(Random rnd) {
        int x = rnd.nextInt();
        int level = 0;
        while ((x & 1) != 0) {
            ++level;
            x >>>= 1;
        }
        return level;
    }

    private class GroupedInput
    implements GridHadoopTaskInput {
        private Comparator<Object> groupCmp;
        private Input in;
        private Object prevKey;
        private Object nextKey;
        private GridLongList vals = new GridLongList();

        private GroupedInput(Comparator<Object> groupCmp, Input in) {
            this.groupCmp = groupCmp;
            this.in = in;
        }

        public boolean next() {
            if (this.prevKey == null) {
                if (!this.in.next()) {
                    return false;
                }
                this.prevKey = this.in.key();
                assert (this.prevKey != null);
                this.in.keyReader.resetReusedObject(null);
                this.vals.add(GridHadoopSkipList.this.value(this.in.metaPtr));
            } else {
                if (this.in.metaPtr == 0L) {
                    return false;
                }
                this.vals.clear();
                this.vals.add(GridHadoopSkipList.this.value(this.in.metaPtr));
                this.in.keyReader.resetReusedObject(this.prevKey);
                this.prevKey = this.nextKey;
            }
            while (this.in.next() && this.groupCmp.compare(this.prevKey, this.nextKey = this.in.key()) == 0) {
                this.vals.add(GridHadoopSkipList.this.value(this.in.metaPtr));
            }
            assert (!this.vals.isEmpty());
            return true;
        }

        public Object key() {
            return this.prevKey;
        }

        public Iterator<?> values() {
            assert (!this.vals.isEmpty());
            final GridHadoopMultimapBase.ValueIterator valIter = new GridHadoopMultimapBase.ValueIterator(GridHadoopSkipList.this, this.vals.get(0), this.in.valReader);
            return new Iterator<Object>(){
                int idx;

                @Override
                public boolean hasNext() {
                    if (!valIter.hasNext()) {
                        if (++this.idx == GroupedInput.this.vals.size()) {
                            return false;
                        }
                        valIter.head(GroupedInput.this.vals.get(this.idx));
                        assert (valIter.hasNext());
                    }
                    return true;
                }

                @Override
                public Object next() {
                    return valIter.next();
                }

                @Override
                public void remove() {
                    valIter.remove();
                }
            };
        }

        public void close() throws GridException {
            this.in.close();
        }
    }

    private class Input
    implements GridHadoopTaskInput {
        private long metaPtr;
        private Reader keyReader;
        private Reader valReader;

        public Input() throws GridException {
            this.keyReader = new Reader(GridHadoopSkipList.this.job.keySerialization());
            this.valReader = new Reader(GridHadoopSkipList.this.job.valueSerialization());
        }

        public boolean next() {
            this.metaPtr = GridHadoopSkipList.this.nextMeta(this.metaPtr, 0);
            return this.metaPtr != 0L;
        }

        public Object key() {
            return this.keyReader.readKey(this.metaPtr);
        }

        public Iterator<?> values() {
            return new GridHadoopMultimapBase.ValueIterator(GridHadoopSkipList.this, GridHadoopSkipList.this.value(this.metaPtr), this.valReader);
        }

        public void close() throws GridException {
            this.keyReader.close();
            this.valReader.close();
        }
    }

    private class AdderImpl
    extends GridHadoopMultimapBase.AdderBase {
        private Random rnd;
        private GridLongList stack;
        private final Reader keyReader;

        protected AdderImpl() throws GridException {
            super(GridHadoopSkipList.this);
            this.rnd = new GridRandom();
            this.stack = new GridLongList(16);
            this.keyReader = new Reader(this.keySer);
        }

        public void write(Object key, Object val) throws GridException {
            A.notNull((Object)val, (String)"val");
            this.add(key, val);
        }

        @Override
        public GridHadoopMultimap.Key addKey(DataInput in, @Nullable GridHadoopMultimap.Key reuse) throws GridException {
            KeyImpl k = reuse == null ? new KeyImpl() : (KeyImpl)reuse;
            k.tmpKey = this.keySer.read(in, k.tmpKey);
            k.meta = this.add(k.tmpKey, null);
            return k;
        }

        private long createMeta(long key, long val, int level) {
            int size = 32 + 8 * level;
            long meta = this.allocate(size);
            GridHadoopSkipList.this.key(meta, key);
            GridHadoopSkipList.this.value(meta, val);
            GridHadoopSkipList.this.lastVisitedValue(meta, 0L);
            for (int i = 32; i < size; i += 8) {
                GridHadoopSkipList.this.mem.writeLong(meta + (long)i, 0L);
            }
            return meta;
        }

        private long writeKey(Object key) throws GridException {
            long keyPtr = this.write(4, key, this.keySer);
            int keySize = this.writtenSize() - 4;
            GridHadoopSkipList.this.keySize(keyPtr, keySize);
            return keyPtr;
        }

        private void stackPush(long prevMeta, long meta) {
            this.stack.add(prevMeta);
            this.stack.add(meta);
        }

        private void stackPop() {
            this.stack.pop(2);
        }

        private long add(Object key, @Nullable Object val) throws GridException {
            long meta;
            assert (key != null);
            this.stack.clear();
            long valPtr = 0L;
            if (val != null) {
                valPtr = this.write(12, val, this.valSer);
                int valSize = this.writtenSize() - 12;
                GridHadoopSkipList.this.nextValue(valPtr, 0L);
                GridHadoopSkipList.this.valueSize(valPtr, valSize);
            }
            long keyPtr = 0L;
            long newMeta = 0L;
            int newMetaLevel = -1;
            long prevMeta = 0L;
            int level = GridHadoopSkipList.this.topLevel.get();
            long l = meta = level < 0 ? 0L : GridHadoopSkipList.this.heads.get(level);
            block0: while (true) {
                long nextMeta;
                int cmpRes;
                if (level < 0) {
                    if (keyPtr == 0L) {
                        keyPtr = this.writeKey(key);
                        newMetaLevel = GridHadoopSkipList.randomLevel(this.rnd);
                        newMeta = this.createMeta(keyPtr, valPtr, newMetaLevel);
                    }
                    GridHadoopSkipList.this.nextMeta(newMeta, 0, meta);
                    if (GridHadoopSkipList.this.casNextMeta(prevMeta, 0, meta, newMeta)) {
                        this.laceUp(key, newMeta, newMetaLevel);
                        return newMeta;
                    }
                    level = 0;
                    meta = GridHadoopSkipList.this.nextMeta(prevMeta, 0);
                    this.stackPop();
                }
                if ((cmpRes = this.cmp(key, meta)) == 0) {
                    long nextVal;
                    if (newMeta != 0L) {
                        this.localDeallocate(keyPtr);
                    }
                    if (valPtr == 0L) {
                        return meta;
                    }
                    do {
                        nextVal = GridHadoopSkipList.this.value(meta);
                        GridHadoopSkipList.this.nextValue(valPtr, nextVal);
                    } while (!GridHadoopSkipList.this.casValue(meta, nextVal, valPtr));
                    return meta;
                }
                assert (cmpRes != 0);
                if (cmpRes > 0) {
                    prevMeta = meta;
                    if ((meta = GridHadoopSkipList.this.nextMeta(meta, level)) != 0L) continue;
                }
                do {
                    if (--level < 0) continue block0;
                    this.stackPush(prevMeta, meta);
                } while ((nextMeta = GridHadoopSkipList.this.nextMeta(prevMeta, level)) == meta);
                meta = nextMeta;
                if (!$assertionsDisabled && meta == 0L) break;
            }
            throw new AssertionError();
        }

        private int cmp(Object key, long meta) {
            assert (meta != 0L);
            return GridHadoopSkipList.this.cmp.compare(key, this.keyReader.readKey(meta));
        }

        private void laceUp(Object key, long newMeta, int newMetaLevel) {
            int top;
            block0: for (int level = 1; level <= newMetaLevel; ++level) {
                int cmpRes;
                long prevMeta = 0L;
                long meta = 0L;
                if (!this.stack.isEmpty()) {
                    meta = this.stack.remove();
                    prevMeta = this.stack.remove();
                }
                while (true) {
                    GridHadoopSkipList.this.nextMeta(newMeta, level, meta);
                    if (GridHadoopSkipList.this.casNextMeta(prevMeta, level, meta, newMeta)) continue block0;
                    long oldMeta = meta;
                    meta = GridHadoopSkipList.this.nextMeta(prevMeta, level);
                    while ((cmpRes = this.cmp(key, meta)) > 0 && (meta = GridHadoopSkipList.this.nextMeta(prevMeta = meta, level)) != oldMeta) {
                    }
                    assert (cmpRes != 0);
                }
            }
            if (!this.stack.isEmpty()) {
                return;
            }
            while (newMetaLevel > (top = GridHadoopSkipList.this.topLevel.get()) && !GridHadoopSkipList.this.topLevel.compareAndSet(top, newMetaLevel)) {
            }
        }

        public class KeyImpl
        implements GridHadoopMultimap.Key {
            private long meta;
            private Object tmpKey;

            public long address() {
                return this.meta;
            }

            @Override
            public void add(GridHadoopMultimap.Value val) {
                long nextVal;
                int size = val.size();
                long valPtr = AdderImpl.this.allocate(size + 12);
                val.copyTo(valPtr + 12L);
                GridHadoopSkipList.this.valueSize(valPtr, size);
                do {
                    nextVal = GridHadoopSkipList.this.value(this.meta);
                    GridHadoopSkipList.this.nextValue(valPtr, nextVal);
                } while (!GridHadoopSkipList.this.casValue(this.meta, nextVal, valPtr));
            }
        }
    }

    private class Reader
    extends GridHadoopMultimapBase.ReaderBase {
        protected Reader(GridHadoopSerialization ser) {
            super(GridHadoopSkipList.this, ser);
        }

        public Object readKey(long meta) {
            assert (meta > 0L) : meta;
            long k = GridHadoopSkipList.this.key(meta);
            try {
                return this.read(k + 4L, GridHadoopSkipList.this.keySize(k));
            }
            catch (GridException e) {
                throw new GridRuntimeException((Throwable)e);
            }
        }
    }
}

