/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.shuffle.streams;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.streams.GridHadoopOffheapBuffer;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;

public class GridHadoopDataInStream
extends InputStream
implements DataInput {
    private final GridHadoopOffheapBuffer buf = new GridHadoopOffheapBuffer(0L, 0L);
    private final GridUnsafeMemory mem;

    public GridHadoopDataInStream(GridUnsafeMemory mem) {
        assert (mem != null);
        this.mem = mem;
    }

    public GridHadoopOffheapBuffer buffer() {
        return this.buf;
    }

    protected long move(long size) throws IOException {
        long ptr = this.buf.move(size);
        assert (ptr != 0L);
        return ptr;
    }

    @Override
    public int read() throws IOException {
        return this.readUnsignedByte();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readFully(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        this.move(n);
        return n;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.mem.readBytes(this.move(len), b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.move(n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        byte res = this.readByte();
        if (res == 1) {
            return true;
        }
        assert (res == 0) : res;
        return false;
    }

    @Override
    public byte readByte() throws IOException {
        return this.mem.readByte(this.move(1L));
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return this.mem.readShort(this.move(2L));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.mem.readInt(this.move(4L));
    }

    @Override
    public long readLong() throws IOException {
        return this.mem.readLong(this.move(8L));
    }

    @Override
    public float readFloat() throws IOException {
        return this.mem.readFloat(this.move(4L));
    }

    @Override
    public double readDouble() throws IOException {
        return this.mem.readDouble(this.move(8L));
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        byte[] bytes = new byte[this.readInt()];
        if (bytes.length != 0) {
            this.readFully(bytes);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

