/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.shuffle.streams;

import java.io.DataOutput;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.streams.GridHadoopOffheapBuffer;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;

public class GridHadoopDataOutStream
extends OutputStream
implements DataOutput {
    private final GridHadoopOffheapBuffer buf = new GridHadoopOffheapBuffer(0L, 0L);
    private final GridUnsafeMemory mem;

    public GridHadoopDataOutStream(GridUnsafeMemory mem) {
        this.mem = mem;
    }

    public GridHadoopOffheapBuffer buffer() {
        return this.buf;
    }

    public long move(long size) {
        return this.buf.move(size);
    }

    @Override
    public void write(int b) {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        GridUnsafeMemory.UNSAFE.copyMemory(b, GridUnsafeMemory.BYTE_ARR_OFF + (long)off, null, this.move(len), len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.writeByte(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.mem.writeByte(this.move(1L), (byte)v);
    }

    @Override
    public void writeShort(int v) {
        this.mem.writeShort(this.move(2L), (short)v);
    }

    @Override
    public void writeChar(int v) {
        this.writeShort(v);
    }

    @Override
    public void writeInt(int v) {
        this.mem.writeInt(this.move(4L), v);
    }

    @Override
    public void writeLong(long v) {
        this.mem.writeLong(this.move(8L), v);
    }

    @Override
    public void writeFloat(float v) {
        this.mem.writeFloat(this.move(4L), v);
    }

    @Override
    public void writeDouble(double v) {
        this.mem.writeDouble(this.move(8L), v);
    }

    @Override
    public void writeBytes(String s) {
        this.writeUTF(s);
    }

    @Override
    public void writeChars(String s) {
        this.writeUTF(s);
    }

    @Override
    public void writeUTF(String s) {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        this.writeInt(b.length);
        this.write(b);
    }
}

