/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.shuffle.streams;

public class GridHadoopOffheapBuffer {
    private long bufPtr;
    private long bufEnd;
    private long posPtr;

    public GridHadoopOffheapBuffer(long bufPtr, long bufSize) {
        this.set(bufPtr, bufSize);
    }

    public void set(long bufPtr, long bufSize) {
        this.posPtr = bufPtr;
        this.bufPtr = bufPtr;
        this.bufEnd = bufPtr + bufSize;
    }

    public long begin() {
        return this.bufPtr;
    }

    public long capacity() {
        return this.bufEnd - this.bufPtr;
    }

    public long remaining() {
        return this.bufEnd - this.posPtr;
    }

    public long pointer() {
        return this.posPtr;
    }

    public void pointer(long ptr) {
        assert (ptr >= this.bufPtr) : this.bufPtr + " <= " + ptr;
        assert (ptr <= this.bufEnd) : this.bufEnd + " <= " + this.bufPtr;
        this.posPtr = ptr;
    }

    public long move(long size) {
        assert (size > 0L) : size;
        long oldPos = this.posPtr;
        long newPos = oldPos + size;
        if (newPos > this.bufEnd) {
            return 0L;
        }
        this.posPtr = newPos;
        return oldPos;
    }

    public boolean isInside(long ptr) {
        return ptr >= this.bufPtr && ptr <= this.bufEnd;
    }

    public void reset() {
        this.posPtr = this.bufPtr;
    }
}

