/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.taskexecutor;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopJob;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.hadoop.GridHadoopJobPhase;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.hadoop.GridHadoopTaskInput;
import org.gridgain.grid.hadoop.GridHadoopTaskOutput;
import org.gridgain.grid.kernal.processors.hadoop.jobtracker.GridHadoopJobMetadata;
import org.gridgain.grid.kernal.processors.hadoop.jobtracker.GridHadoopJobTracker;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.GridHadoopRunnableTask;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.GridHadoopTaskExecutorAdapter;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.GridHadoopTaskState;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.GridHadoopTaskStatus;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.GridConcurrentHashSet;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopEmbeddedTaskExecutor
extends GridHadoopTaskExecutorAdapter {
    private GridHadoopJobTracker jobTracker;
    private final ConcurrentMap<GridHadoopJobId, Collection<GridHadoopRunnableTask>> jobs = new ConcurrentHashMap<GridHadoopJobId, Collection<GridHadoopRunnableTask>>();
    private ExecutorService exec;

    @Override
    public void onKernalStart() throws GridException {
        super.onKernalStart();
        this.jobTracker = this.ctx.jobTracker();
        this.exec = this.ctx.configuration().getEmbeddedExecutor();
        if (this.exec == null) {
            this.exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        if (this.exec != null) {
            this.exec.shutdown();
            if (cancel) {
                for (GridHadoopJobId jobId : this.jobs.keySet()) {
                    this.cancelTasks(jobId);
                }
            }
        }
    }

    @Override
    public void stop(boolean cancel) {
        try {
            if (this.exec != null && !this.exec.awaitTermination(30L, TimeUnit.SECONDS)) {
                U.warn((GridLogger)this.log, (Object)"Failed to finish running tasks in 30 sec.");
            }
        }
        catch (InterruptedException e) {
            U.error((GridLogger)this.log, (Object)"Failed to finish running tasks.", (Throwable)e);
        }
    }

    @Override
    public void run(final GridHadoopJob job, Collection<GridHadoopTaskInfo> tasks) {
        Collection executedTasks;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Submitting tasks for local execution [locNodeId=" + this.ctx.localNodeId() + ", tasksCnt=" + tasks.size() + ']');
        }
        if ((executedTasks = (Collection)this.jobs.get(job.id())) == null) {
            executedTasks = new GridConcurrentHashSet();
            Collection<GridHadoopRunnableTask> extractedCol = this.jobs.put(job.id(), executedTasks);
            assert (extractedCol == null);
        }
        final Collection finalExecutedTasks = executedTasks;
        for (final GridHadoopTaskInfo info : tasks) {
            assert (info != null);
            GridHadoopRunnableTask task = new GridHadoopRunnableTask(this.log, job, this.ctx.shuffle().memory(), info){

                @Override
                protected void onTaskFinished(GridHadoopTaskState state, Throwable err) {
                    if (GridHadoopEmbeddedTaskExecutor.this.log.isDebugEnabled()) {
                        GridHadoopEmbeddedTaskExecutor.this.log.debug("Finished task execution [jobId=" + job.id() + ", taskInfo=" + info + ", " + "waitTime=" + this.waitTime() + ", execTime=" + this.executionTime() + ']');
                    }
                    finalExecutedTasks.remove(this);
                    GridHadoopEmbeddedTaskExecutor.this.jobTracker.onTaskFinished(info, new GridHadoopTaskStatus(state, err));
                }

                @Override
                protected GridHadoopTaskInput createInput(GridHadoopTaskInfo info2) throws GridException {
                    return GridHadoopEmbeddedTaskExecutor.this.ctx.shuffle().input(info2);
                }

                @Override
                protected GridHadoopTaskOutput createOutput(GridHadoopTaskInfo info2) throws GridException {
                    return GridHadoopEmbeddedTaskExecutor.this.ctx.shuffle().output(info2);
                }
            };
            executedTasks.add(task);
            this.exec.submit(task);
        }
    }

    @Override
    public void cancelTasks(GridHadoopJobId jobId) {
        Collection executedTasks = (Collection)this.jobs.get(jobId);
        if (executedTasks != null) {
            for (GridHadoopRunnableTask task : executedTasks) {
                task.cancel();
            }
        }
    }

    @Override
    public void onJobStateChanged(GridHadoopJobMetadata meta) throws GridException {
        if (meta.phase() == GridHadoopJobPhase.PHASE_COMPLETE) {
            Collection executedTasks = (Collection)this.jobs.remove(meta.jobId());
            assert (executedTasks == null || executedTasks.isEmpty());
        }
    }
}

