/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.taskexecutor;

import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopJob;
import org.gridgain.grid.hadoop.GridHadoopJobInfo;
import org.gridgain.grid.hadoop.GridHadoopJobProperty;
import org.gridgain.grid.hadoop.GridHadoopTask;
import org.gridgain.grid.hadoop.GridHadoopTaskContext;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.hadoop.GridHadoopTaskInput;
import org.gridgain.grid.hadoop.GridHadoopTaskOutput;
import org.gridgain.grid.hadoop.GridHadoopTaskType;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopTaskCancelledException;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopHashMultimap;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopMultimap;
import org.gridgain.grid.kernal.processors.hadoop.shuffle.collections.GridHadoopSkipList;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.GridHadoopTaskState;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.lang.GridPlainCallable;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.gridgain.grid.util.typedef.internal.U;

public abstract class GridHadoopRunnableTask
implements GridPlainCallable<Void> {
    private final GridUnsafeMemory mem;
    private GridLogger log;
    private final GridHadoopJob job;
    private final GridHadoopTaskInfo info;
    private long submitTs = System.currentTimeMillis();
    private long execStartTs;
    private long execEndTs;
    private GridHadoopMultimap local;
    private volatile GridHadoopTask task;
    private volatile boolean cancelled;

    public GridHadoopRunnableTask(GridLogger log, GridHadoopJob job, GridUnsafeMemory mem, GridHadoopTaskInfo info) {
        this.log = log;
        this.job = job;
        this.mem = mem;
        this.info = info;
    }

    public long waitTime() {
        return this.execStartTs - this.submitTs;
    }

    public long executionTime() {
        return this.execEndTs - this.execStartTs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void call() throws GridException {
        this.execStartTs = System.currentTimeMillis();
        boolean runCombiner = this.info.type() == GridHadoopTaskType.MAP && this.job.info().hasCombiner() && !GridHadoopJobProperty.get((GridHadoopJobInfo)this.job.info(), (GridHadoopJobProperty)GridHadoopJobProperty.SINGLE_COMBINER_FOR_ALL_MAPPERS, (boolean)false);
        GridHadoopTaskState state = GridHadoopTaskState.COMPLETED;
        Throwable err = null;
        try {
            this.job.beforeTaskRun(this.info);
            this.runTask(this.info, runCombiner);
            if (runCombiner) {
                this.runTask(new GridHadoopTaskInfo(this.info.nodeId(), GridHadoopTaskType.COMBINE, this.info.jobId(), this.info.taskNumber(), this.info.attempt(), null), runCombiner);
            }
        }
        catch (GridHadoopTaskCancelledException ignored) {
            state = GridHadoopTaskState.CANCELED;
        }
        catch (Throwable e) {
            state = GridHadoopTaskState.FAILED;
            err = e;
            U.error((GridLogger)this.log, (Object)"Task execution failed.", (Throwable)e);
        }
        finally {
            this.execEndTs = System.currentTimeMillis();
            this.onTaskFinished(state, err);
            if (runCombiner) {
                this.local.close();
            }
            this.job.afterTaskRun(this.info);
        }
        return null;
    }

    private void runTask(GridHadoopTaskInfo info, boolean localCombiner) throws GridException {
        if (this.cancelled) {
            throw new GridHadoopTaskCancelledException("Task cancelled.");
        }
        try (GridHadoopTaskOutput out = this.createOutput(info, localCombiner);
             GridHadoopTaskInput in = this.createInput(info, localCombiner);){
            GridHadoopTaskContext ctx = new GridHadoopTaskContext(info, this.job, in, out);
            this.task = this.job.createTask(info);
            if (this.cancelled) {
                throw new GridHadoopTaskCancelledException("Task cancelled.");
            }
            this.task.run(ctx);
        }
    }

    public void cancel() {
        this.cancelled = true;
        if (this.task != null) {
            this.task.cancel();
        }
    }

    protected abstract void onTaskFinished(GridHadoopTaskState var1, Throwable var2);

    private GridHadoopTaskInput createInput(GridHadoopTaskInfo info, boolean localCombiner) throws GridException {
        switch (info.type()) {
            case SETUP: 
            case MAP: 
            case COMMIT: 
            case ABORT: {
                return null;
            }
            case COMBINE: {
                if (!localCombiner) break;
                assert (this.local != null);
                return this.local.input(this.job.combineGroupComparator());
            }
        }
        return this.createInput(info);
    }

    protected abstract GridHadoopTaskInput createInput(GridHadoopTaskInfo var1) throws GridException;

    protected abstract GridHadoopTaskOutput createOutput(GridHadoopTaskInfo var1) throws GridException;

    private GridHadoopTaskOutput createOutput(GridHadoopTaskInfo info, boolean localCombiner) throws GridException {
        switch (info.type()) {
            case SETUP: 
            case COMMIT: 
            case ABORT: 
            case REDUCE: {
                return null;
            }
            case MAP: {
                if (!localCombiner) break;
                assert (this.local == null);
                this.local = GridHadoopJobProperty.get((GridHadoopJobInfo)this.job.info(), (GridHadoopJobProperty)GridHadoopJobProperty.SHUFFLE_COMBINER_NO_SORTING, (boolean)false) ? new GridHadoopHashMultimap(this.job, this.mem, GridHadoopJobProperty.get((GridHadoopJobInfo)this.job.info(), (GridHadoopJobProperty)GridHadoopJobProperty.COMBINER_HASHMAP_SIZE, (int)8192)) : new GridHadoopSkipList(this.job, this.mem, this.job.sortComparator());
                return this.local.startAdding();
            }
        }
        return this.createOutput(info);
    }

    public GridHadoopTaskInfo taskInfo() {
        return this.info;
    }
}

