/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.child;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.GridHadoopProcessDescriptor;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.child.GridHadoopChildProcessRunner;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.communication.GridHadoopExternalCommunication;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.logger.java.GridJavaLogger;
import org.gridgain.grid.marshaller.GridMarshaller;
import org.gridgain.grid.marshaller.optimized.GridOptimizedMarshaller;
import org.gridgain.grid.util.ipc.shmem.GridIpcSharedMemorySpace;
import org.gridgain.grid.util.typedef.internal.U;
import org.gridgain.grid.util.worker.GridWorker;

public class GridHadoopExternalProcessStarter {
    private Args args;
    private OutputStream out;
    private OutputStream err;

    public GridHadoopExternalProcessStarter(Args args) {
        this.args = args;
    }

    public static void main(String[] cmdArgs) {
        try {
            Args args = GridHadoopExternalProcessStarter.arguments(cmdArgs);
            new GridHadoopExternalProcessStarter(args).run();
        }
        catch (Exception e) {
            System.err.println("Failed");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public void run() throws Exception {
        U.setWorkDirectory((String)this.args.workDir, (String)U.getGridGainHome());
        this.initializeStreams();
        ExecutorService msgExecSvc = Executors.newFixedThreadPool(Integer.getInteger("MSG_THREAD_POOL_SIZE", Runtime.getRuntime().availableProcessors() * 2));
        GridLogger log = this.logger();
        GridHadoopExternalCommunication comm = new GridHadoopExternalCommunication(this.args.nodeId, this.args.childProcId, (GridMarshaller)new GridOptimizedMarshaller(), log, msgExecSvc, "external");
        comm.start();
        GridHadoopProcessDescriptor nodeDesc = new GridHadoopProcessDescriptor(this.args.nodeId, this.args.parentProcId);
        nodeDesc.address(this.args.addr);
        nodeDesc.tcpPort(this.args.tcpPort);
        nodeDesc.sharedMemoryPort(this.args.shmemPort);
        GridHadoopChildProcessRunner runner = new GridHadoopChildProcessRunner();
        runner.start(comm, nodeDesc, msgExecSvc, log);
        System.err.println("Started");
        System.err.flush();
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    private void initializeStreams() throws Exception {
        File f = new File(this.args.out);
        if (!f.exists()) {
            if (!f.mkdirs()) {
                throw new IOException("Failed to create output directory: " + this.args.out);
            }
        } else if (f.isFile()) {
            throw new IOException("Output directory is a file: " + this.args.out);
        }
        this.out = new FileOutputStream(new File(f, this.args.childProcId + ".out"));
        this.err = new FileOutputStream(new File(f, this.args.childProcId + ".err"));
    }

    private GridLogger logger() throws IOException {
        Logger log = Logger.getLogger("");
        log.setLevel(Level.FINE);
        for (Handler h : log.getHandlers()) {
            log.removeHandler(h);
        }
        FileHandler h = new FileHandler(this.args.out + File.separator + this.args.childProcId + ".log", true);
        h.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                StringBuffer sb = new StringBuffer();
                SimpleDateFormat df = new SimpleDateFormat("yy-MM-dd HH:mm:ss.SSS");
                sb.append("[");
                ((DateFormat)df).format(new Date(record.getMillis()), sb, new FieldPosition(0));
                sb.append("][").append(record.getLevel()).append("][").append(record.getLoggerName()).append("] ").append(record.getMessage()).append("\n");
                if (record.getThrown() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.flush();
                    sb.append(sw.toString());
                }
                return sb.toString();
            }
        });
        log.addHandler(h);
        Logger.getLogger(GridIpcSharedMemorySpace.class.toString()).setLevel(Level.WARNING);
        Logger.getLogger(GridIpcSharedMemorySpace.class.getName()).setLevel(Level.WARNING);
        Logger.getLogger(GridWorker.class.toString()).setLevel(Level.WARNING);
        Logger.getLogger(GridWorker.class.getName()).setLevel(Level.WARNING);
        return new GridJavaLogger(log);
    }

    private static Args arguments(String[] processArgs) throws Exception {
        Args args = new Args();
        block20: for (int i = 0; i < processArgs.length; ++i) {
            String arg;
            switch (arg = processArgs[i]) {
                case "-cpid": {
                    if (i == processArgs.length - 1) {
                        throw new Exception("Missing process ID for '-cpid' parameter");
                    }
                    String procIdStr = processArgs[++i];
                    args.childProcId = UUID.fromString(procIdStr);
                    continue block20;
                }
                case "-ppid": {
                    if (i == processArgs.length - 1) {
                        throw new Exception("Missing process ID for '-ppid' parameter");
                    }
                    String procIdStr = processArgs[++i];
                    args.parentProcId = UUID.fromString(procIdStr);
                    continue block20;
                }
                case "-nid": {
                    if (i == processArgs.length - 1) {
                        throw new Exception("Missing node ID for '-nid' parameter");
                    }
                    String nodeIdStr = processArgs[++i];
                    args.nodeId = UUID.fromString(nodeIdStr);
                    continue block20;
                }
                case "-addr": {
                    if (i == processArgs.length - 1) {
                        throw new Exception("Missing node address for '-addr' parameter");
                    }
                    args.addr = processArgs[++i];
                    continue block20;
                }
                case "-tport": {
                    if (i == processArgs.length - 1) {
                        throw new Exception("Missing tcp port for '-tport' parameter");
                    }
                    args.tcpPort = Integer.parseInt(processArgs[++i]);
                    continue block20;
                }
                case "-sport": {
                    if (i == processArgs.length - 1) {
                        throw new Exception("Missing shared memory port for '-sport' parameter");
                    }
                    args.shmemPort = Integer.parseInt(processArgs[++i]);
                    continue block20;
                }
                case "-out": {
                    if (i == processArgs.length - 1) {
                        throw new Exception("Missing output folder name for '-out' parameter");
                    }
                    args.out = processArgs[++i];
                    continue block20;
                }
                case "-wd": {
                    if (i == processArgs.length - 1) {
                        throw new Exception("Missing work folder name for '-wd' parameter");
                    }
                    args.workDir = processArgs[++i];
                }
            }
        }
        return args;
    }

    private static class Args {
        private UUID childProcId;
        private UUID parentProcId;
        private UUID nodeId;
        private String addr;
        private int tcpPort;
        private int shmemPort = -1;
        private String out;
        private String workDir;

        private Args() {
        }
    }
}

