/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.communication;

import java.util.concurrent.atomic.AtomicInteger;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.communication.GridHadoopCommunicationClient;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public abstract class GridHadoopAbstractCommunicationClient
implements GridHadoopCommunicationClient {
    private volatile long lastUsed = U.currentTimeMillis();
    private final AtomicInteger reserves = new AtomicInteger();

    @Override
    public boolean close() {
        return this.reserves.compareAndSet(0, -1);
    }

    @Override
    public void forceClose() {
        this.reserves.set(-1);
    }

    @Override
    public boolean closed() {
        return this.reserves.get() == -1;
    }

    @Override
    public boolean reserve() {
        int r;
        do {
            if ((r = this.reserves.get()) != -1) continue;
            return false;
        } while (!this.reserves.compareAndSet(r, r + 1));
        return true;
    }

    @Override
    public void release() {
        int r;
        do {
            if ((r = this.reserves.get()) != -1) continue;
            return;
        } while (!this.reserves.compareAndSet(r, r - 1));
    }

    @Override
    public boolean reserved() {
        return this.reserves.get() > 0;
    }

    @Override
    public long getIdleTime() {
        return U.currentTimeMillis() - this.lastUsed;
    }

    protected void markUsed() {
        this.lastUsed = U.currentTimeMillis();
    }

    public String toString() {
        return S.toString(GridHadoopAbstractCommunicationClient.class, (Object)this);
    }
}

