/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.communication;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.gridgain.grid.GridException;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.ipc.GridIpcEndpoint;
import org.gridgain.grid.util.nio.GridNioFilter;
import org.gridgain.grid.util.nio.GridNioFilterAdapter;
import org.gridgain.grid.util.nio.GridNioFilterChain;
import org.gridgain.grid.util.nio.GridNioFinishedFuture;
import org.gridgain.grid.util.nio.GridNioFuture;
import org.gridgain.grid.util.nio.GridNioServerListener;
import org.gridgain.grid.util.nio.GridNioSession;
import org.gridgain.grid.util.nio.GridNioSessionImpl;

public class GridHadoopIpcToNioAdapter<T> {
    private final GridIpcEndpoint endp;
    private final GridNioFilterChain<T> chain;
    private final GridNioSessionImpl ses;
    private final AtomicReference<CountDownLatch> latchRef = new AtomicReference();
    private final ByteBuffer writeBuf;

    public GridHadoopIpcToNioAdapter(GridLogger log, GridIpcEndpoint endp, boolean accepted, GridNioServerListener<T> lsnr, GridNioFilter ... filters) {
        this.endp = endp;
        this.chain = new GridNioFilterChain(log, lsnr, (GridNioFilter)new HeadFilter(), filters);
        this.ses = new GridNioSessionImpl(this.chain, null, null, accepted);
        this.writeBuf = ByteBuffer.allocate(8192);
        this.writeBuf.order(ByteOrder.nativeOrder());
    }

    public void serve() throws InterruptedException {
        try {
            this.chain.onSessionOpened((GridNioSession)this.ses);
            InputStream in = this.endp.inputStream();
            ByteBuffer readBuf = ByteBuffer.allocate(8192);
            readBuf.order(ByteOrder.nativeOrder());
            assert (readBuf.hasArray());
            while (!Thread.interrupted()) {
                int pos = readBuf.position();
                int read = in.read(readBuf.array(), pos, readBuf.remaining());
                if (read > 0) {
                    CountDownLatch latch;
                    readBuf.position(0);
                    readBuf.limit(pos + read);
                    this.chain.onMessageReceived((GridNioSession)this.ses, (Object)readBuf);
                    if (readBuf.hasRemaining()) {
                        readBuf.compact();
                    } else {
                        readBuf.clear();
                    }
                    if ((latch = this.latchRef.get()) == null) continue;
                    latch.await();
                    continue;
                }
                if (read >= 0) continue;
                this.endp.close();
                break;
            }
            this.chain.onSessionClosed((GridNioSession)this.ses);
        }
        catch (Exception e) {
            this.chain.onExceptionCaught((GridNioSession)this.ses, new GridException("Failed to read from IPC endpoint.", (Throwable)e));
        }
    }

    public GridNioSession session() {
        return this.ses;
    }

    private GridNioFuture<?> send(ByteBuffer msg) {
        assert (this.writeBuf.hasArray());
        try {
            while (msg.hasRemaining()) {
                this.writeBuf.clear();
                this.writeBuf.put(msg);
                this.endp.outputStream().write(this.writeBuf.array(), 0, this.writeBuf.position());
            }
        }
        catch (IOException | GridException e) {
            return new GridNioFinishedFuture(e);
        }
        return new GridNioFinishedFuture((Object)null);
    }

    private class HeadFilter
    extends GridNioFilterAdapter {
        protected HeadFilter() {
            super("HeadFilter");
        }

        public void onSessionOpened(GridNioSession ses) throws GridException {
            this.proceedSessionOpened(ses);
        }

        public void onSessionClosed(GridNioSession ses) throws GridException {
            this.proceedSessionClosed(ses);
        }

        public void onExceptionCaught(GridNioSession ses, GridException ex) throws GridException {
            this.proceedExceptionCaught(ses, ex);
        }

        public GridNioFuture<?> onSessionWrite(GridNioSession ses, Object msg) {
            assert (ses == GridHadoopIpcToNioAdapter.this.ses) : "ses=" + ses + ", this.ses=" + GridHadoopIpcToNioAdapter.access$000(GridHadoopIpcToNioAdapter.this);
            return GridHadoopIpcToNioAdapter.this.send((ByteBuffer)msg);
        }

        public void onMessageReceived(GridNioSession ses, Object msg) throws GridException {
            this.proceedMessageReceived(ses, msg);
        }

        public GridNioFuture<?> onPauseReads(GridNioSession ses) throws GridException {
            boolean b = GridHadoopIpcToNioAdapter.this.latchRef.compareAndSet(null, new CountDownLatch(1));
            assert (b);
            return new GridNioFinishedFuture((Object)b);
        }

        public GridNioFuture<?> onResumeReads(GridNioSession ses) throws GridException {
            CountDownLatch latch = GridHadoopIpcToNioAdapter.this.latchRef.getAndSet(null);
            if (latch != null) {
                latch.countDown();
            }
            return new GridNioFinishedFuture((Object)(latch != null ? 1 : 0));
        }

        public GridNioFuture<Boolean> onSessionClose(GridNioSession ses) {
            assert (ses == GridHadoopIpcToNioAdapter.this.ses);
            boolean closed = GridHadoopIpcToNioAdapter.this.ses.setClosed();
            if (closed) {
                GridHadoopIpcToNioAdapter.this.endp.close();
            }
            return new GridNioFinishedFuture((Object)closed);
        }

        public void onSessionIdleTimeout(GridNioSession ses) throws GridException {
            this.proceedSessionIdleTimeout(ses);
        }

        public void onSessionWriteTimeout(GridNioSession ses) throws GridException {
            this.proceedSessionWriteTimeout(ses);
        }
    }
}

