/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.communication;

import org.gridgain.grid.GridException;
import org.gridgain.grid.kernal.processors.hadoop.message.GridHadoopMessage;
import org.gridgain.grid.marshaller.GridMarshaller;
import org.gridgain.grid.util.nio.GridNioFilterAdapter;
import org.gridgain.grid.util.nio.GridNioFuture;
import org.gridgain.grid.util.nio.GridNioSession;

public class GridHadoopMarshallerFilter
extends GridNioFilterAdapter {
    private GridMarshaller marshaller;

    public GridHadoopMarshallerFilter(GridMarshaller marshaller) {
        super("GridHadoopMarshallerFilter");
        this.marshaller = marshaller;
    }

    public void onSessionOpened(GridNioSession ses) throws GridException {
        this.proceedSessionOpened(ses);
    }

    public void onSessionClosed(GridNioSession ses) throws GridException {
        this.proceedSessionClosed(ses);
    }

    public void onExceptionCaught(GridNioSession ses, GridException ex) throws GridException {
        this.proceedExceptionCaught(ses, ex);
    }

    public GridNioFuture<?> onSessionWrite(GridNioSession ses, Object msg) throws GridException {
        assert (msg instanceof GridHadoopMessage) : "Invalid message type: " + msg;
        return this.proceedSessionWrite(ses, this.marshaller.marshal(msg));
    }

    public void onMessageReceived(GridNioSession ses, Object msg) throws GridException {
        assert (msg instanceof byte[]);
        this.proceedMessageReceived(ses, this.marshaller.unmarshal((byte[])msg, null));
    }

    public GridNioFuture<Boolean> onSessionClose(GridNioSession ses) throws GridException {
        return this.proceedSessionClose(ses);
    }

    public void onSessionIdleTimeout(GridNioSession ses) throws GridException {
        this.proceedSessionIdleTimeout(ses);
    }

    public void onSessionWriteTimeout(GridNioSession ses) throws GridException {
        this.proceedSessionWriteTimeout(ses);
    }
}

