/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.communication;

import java.io.IOException;
import org.gridgain.grid.GridException;
import org.gridgain.grid.kernal.processors.hadoop.message.GridHadoopMessage;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.GridHadoopProcessDescriptor;
import org.gridgain.grid.kernal.processors.hadoop.taskexecutor.external.communication.GridHadoopAbstractCommunicationClient;
import org.gridgain.grid.util.nio.GridNioFuture;
import org.gridgain.grid.util.nio.GridNioSession;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopTcpNioCommunicationClient
extends GridHadoopAbstractCommunicationClient {
    private final GridNioSession ses;

    public GridHadoopTcpNioCommunicationClient() {
        this.ses = null;
    }

    public GridHadoopTcpNioCommunicationClient(GridNioSession ses) {
        assert (ses != null);
        this.ses = ses;
    }

    @Override
    public boolean close() {
        boolean res = super.close();
        if (res) {
            this.ses.close();
        }
        return res;
    }

    @Override
    public void forceClose() {
        super.forceClose();
        this.ses.close();
    }

    @Override
    public void sendMessage(GridHadoopProcessDescriptor desc, GridHadoopMessage msg) throws GridException {
        if (this.closed()) {
            throw new GridException("Client was closed: " + this);
        }
        GridNioFuture fut = this.ses.send((Object)msg);
        if (fut.isDone()) {
            try {
                fut.get();
            }
            catch (IOException e) {
                throw new GridException("Failed to send message [client=" + this + ']', (Throwable)e);
            }
        }
    }

    @Override
    public long getIdleTime() {
        long now = U.currentTimeMillis();
        return Math.min(Math.min(now - this.ses.lastReceiveTime(), now - this.ses.lastSendScheduleTime()), now - this.ses.lastSendTime());
    }

    @Override
    public String toString() {
        return S.toString(GridHadoopTcpNioCommunicationClient.class, (Object)this, (String)super.toString());
    }
}

