/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v1;

import java.io.IOException;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopTaskContext;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1Task;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Job;

public class GridHadoopV1CleanupTask
extends GridHadoopV1Task {
    private boolean abort;

    public GridHadoopV1CleanupTask(GridHadoopTaskInfo taskInfo, boolean abort) {
        super(taskInfo);
        this.abort = abort;
    }

    public void run(GridHadoopTaskContext taskCtx) throws GridException {
        GridHadoopV2Job jobImpl = (GridHadoopV2Job)taskCtx.job();
        org.apache.hadoop.mapred.JobContext jobCtx = jobImpl.hadoopJobContext();
        try {
            OutputCommitter committer = jobCtx.getJobConf().getOutputCommitter();
            if (this.abort) {
                committer.abortJob((JobContext)jobCtx, JobStatus.State.FAILED);
            } else {
                committer.commitJob(jobCtx);
            }
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
    }
}

