/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v1;

import java.io.Closeable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopFileBlock;
import org.gridgain.grid.hadoop.GridHadoopInputSplit;
import org.gridgain.grid.hadoop.GridHadoopTaskContext;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopTaskCancelledException;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1OutputCollector;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1Task;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Job;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopV1MapTask
extends GridHadoopV1Task {
    private static final String[] EMPTY_HOSTS = new String[0];

    public GridHadoopV1MapTask(GridHadoopTaskInfo taskInfo) {
        super(taskInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(GridHadoopTaskContext taskCtx) throws GridException {
        InputSplit nativeSplit;
        GridHadoopV2Job jobImpl = (GridHadoopV2Job)taskCtx.job();
        JobConf jobConf = new JobConf((Configuration)jobImpl.hadoopJobContext().getJobConf());
        Mapper mapper = (Mapper)ReflectionUtils.newInstance((Class)jobConf.getMapperClass(), (Configuration)jobConf);
        InputFormat inFormat = jobConf.getInputFormat();
        GridHadoopInputSplit split = this.info().inputSplit();
        if (split instanceof GridHadoopFileBlock) {
            GridHadoopFileBlock block = (GridHadoopFileBlock)split;
            nativeSplit = new FileSplit(new Path(block.file().toString()), block.start(), block.length(), EMPTY_HOSTS);
        } else {
            nativeSplit = (InputSplit)jobImpl.getNativeSplit(split);
        }
        assert (nativeSplit != null);
        Reporter reporter = Reporter.NULL;
        GridHadoopV1OutputCollector collector = null;
        try {
            collector = this.collector(jobConf, taskCtx, !jobImpl.info().hasCombiner() && !jobImpl.info().hasReducer(), this.fileName(), jobImpl.attemptId(this.info()));
            RecordReader reader = inFormat.getRecordReader(nativeSplit, jobConf, reporter);
            Object key = reader.createKey();
            Object val = reader.createValue();
            assert (mapper != null);
            try {
                while (reader.next(key, val)) {
                    if (this.isCancelled()) {
                        throw new GridHadoopTaskCancelledException("Map task cancelled.");
                    }
                    mapper.map(key, val, (OutputCollector)collector, reporter);
                }
            }
            finally {
                U.closeQuiet((Closeable)mapper);
                collector.closeWriter();
            }
            collector.commit();
        }
        catch (Exception e) {
            if (collector != null) {
                collector.abort();
            }
            throw new GridException((Throwable)e);
        }
    }
}

