/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v1;

import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopTaskContext;
import org.jetbrains.annotations.Nullable;

public class GridHadoopV1OutputCollector
implements OutputCollector {
    private final JobConf jobConf;
    private final GridHadoopTaskContext taskCtx;
    private final RecordWriter writer;
    private final TaskAttemptID attempt;

    GridHadoopV1OutputCollector(JobConf jobConf, GridHadoopTaskContext taskCtx, boolean directWrite, @Nullable String fileName, TaskAttemptID attempt) throws IOException {
        this.jobConf = jobConf;
        this.taskCtx = taskCtx;
        this.attempt = attempt;
        if (directWrite) {
            jobConf.set("mapreduce.task.attempt.id", attempt.toString());
            OutputFormat outFormat = jobConf.getOutputFormat();
            this.writer = outFormat.getRecordWriter(null, jobConf, fileName, (Progressable)Reporter.NULL);
        } else {
            this.writer = null;
        }
    }

    public void collect(Object key, Object val) throws IOException {
        if (this.writer != null) {
            this.writer.write(key, val);
        } else {
            try {
                this.taskCtx.output().write(key, val);
            }
            catch (GridException e) {
                throw new IOException(e);
            }
        }
    }

    public void closeWriter() throws IOException {
        if (this.writer != null) {
            this.writer.close(Reporter.NULL);
        }
    }

    public void setup() throws IOException {
        if (this.writer != null) {
            this.jobConf.getOutputCommitter().setupTask((TaskAttemptContext)new TaskAttemptContextImpl(this.jobConf, this.attempt));
        }
    }

    public void commit() throws IOException {
        TaskAttemptContextImpl taskCtx;
        OutputCommitter outputCommitter;
        if (this.writer != null && (outputCommitter = this.jobConf.getOutputCommitter()).needsTaskCommit((TaskAttemptContext)(taskCtx = new TaskAttemptContextImpl(this.jobConf, this.attempt)))) {
            outputCommitter.commitTask((TaskAttemptContext)taskCtx);
        }
    }

    public void abort() {
        try {
            if (this.writer != null) {
                this.jobConf.getOutputCommitter().abortTask((TaskAttemptContext)new TaskAttemptContextImpl(this.jobConf, this.attempt));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

