/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v1;

import java.io.Closeable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopTaskContext;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.hadoop.GridHadoopTaskInput;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopTaskCancelledException;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1OutputCollector;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1Task;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Job;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopV1ReduceTask
extends GridHadoopV1Task {
    private final boolean reduce;

    public GridHadoopV1ReduceTask(GridHadoopTaskInfo taskInfo, boolean reduce) {
        super(taskInfo);
        this.reduce = reduce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(GridHadoopTaskContext taskCtx) throws GridException {
        GridHadoopV2Job jobImpl = (GridHadoopV2Job)taskCtx.job();
        JobConf jobConf = new JobConf((Configuration)jobImpl.hadoopJobContext().getJobConf());
        Reducer reducer = (Reducer)ReflectionUtils.newInstance((Class)(this.reduce ? jobConf.getReducerClass() : jobConf.getCombinerClass()), (Configuration)jobConf);
        assert (reducer != null);
        GridHadoopTaskInput input = taskCtx.input();
        GridHadoopV1OutputCollector collector = null;
        try {
            collector = this.collector(jobConf, taskCtx, this.reduce || !jobImpl.info().hasReducer(), this.fileName(), jobImpl.attemptId(this.info()));
            try {
                while (input.next()) {
                    if (this.isCancelled()) {
                        throw new GridHadoopTaskCancelledException("Reduce task cancelled.");
                    }
                    reducer.reduce(input.key(), input.values(), (OutputCollector)collector, Reporter.NULL);
                }
            }
            finally {
                U.closeQuiet((Closeable)reducer);
                collector.closeWriter();
            }
            collector.commit();
        }
        catch (Exception e) {
            if (collector != null) {
                collector.abort();
            }
            throw new GridException((Throwable)e);
        }
    }
}

