/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v1;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopFileBlock;
import org.gridgain.grid.hadoop.GridHadoopInputSplit;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopSplitWrapper;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridHadoopV1Splitter {
    private static final String[] EMPTY_HOSTS = new String[0];

    public static Collection<GridHadoopInputSplit> splitJob(JobConf jobConf) throws GridException {
        try {
            InputFormat format = jobConf.getInputFormat();
            assert (format != null);
            InputSplit[] splits = format.getSplits(jobConf, 0);
            ArrayList<GridHadoopInputSplit> res = new ArrayList<GridHadoopInputSplit>(splits.length);
            for (int i = 0; i < splits.length; ++i) {
                InputSplit nativeSplit = splits[i];
                if (nativeSplit instanceof FileSplit) {
                    FileSplit s = (FileSplit)nativeSplit;
                    res.add((GridHadoopInputSplit)new GridHadoopFileBlock(s.getLocations(), s.getPath().toUri(), s.getStart(), s.getLength()));
                    continue;
                }
                res.add(new GridHadoopSplitWrapper(i, nativeSplit, nativeSplit.getLocations()));
            }
            return res;
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
    }

    @Nullable
    public static GridHadoopFileBlock readFileBlock(Class<?> cls, FSDataInputStream in, @Nullable String[] hosts) throws GridException {
        if (FileSplit.class != cls) {
            return null;
        }
        FileSplit split = (FileSplit)U.newInstance(FileSplit.class);
        try {
            split.readFields((DataInput)in);
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
        if (hosts == null) {
            hosts = EMPTY_HOSTS;
        }
        return new GridHadoopFileBlock(hosts, split.getPath().toUri(), split.getStart(), split.getLength());
    }
}

