/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v1;

import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.gridgain.grid.hadoop.GridHadoopTask;
import org.gridgain.grid.hadoop.GridHadoopTaskContext;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopTaskCancelledException;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1OutputCollector;
import org.jetbrains.annotations.Nullable;

public abstract class GridHadoopV1Task
extends GridHadoopTask {
    private volatile boolean cancelled;

    protected GridHadoopV1Task(GridHadoopTaskInfo taskInfo) {
        super(taskInfo);
    }

    public String fileName() {
        NumberFormat numFormat = NumberFormat.getInstance();
        numFormat.setMinimumIntegerDigits(5);
        numFormat.setGroupingUsed(false);
        return "part-" + numFormat.format(this.info().taskNumber());
    }

    protected GridHadoopV1OutputCollector collector(JobConf jobConf, GridHadoopTaskContext taskCtx, boolean directWrite, @Nullable String fileName, TaskAttemptID attempt) throws IOException {
        GridHadoopV1OutputCollector collector = new GridHadoopV1OutputCollector(jobConf, taskCtx, directWrite, fileName, attempt){

            @Override
            public void collect(Object key, Object val) throws IOException {
                if (GridHadoopV1Task.this.cancelled) {
                    throw new GridHadoopTaskCancelledException("Task cancelled.");
                }
                super.collect(key, val);
            }
        };
        collector.setup();
        return collector;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

