/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopSerialization;
import org.jetbrains.annotations.Nullable;

public class GridHadoopSerializationWrapper<T>
implements GridHadoopSerialization {
    private final Serializer<T> serializer;
    private final Deserializer<T> deserializer;
    private OutputStream currOut;
    private InputStream currIn;
    private final OutputStream outStream = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            GridHadoopSerializationWrapper.this.currOut.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            GridHadoopSerializationWrapper.this.currOut.write(b, off, len);
        }
    };
    private final InputStream inStream = new InputStream(){

        @Override
        public int read() throws IOException {
            return GridHadoopSerializationWrapper.this.currIn.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return GridHadoopSerializationWrapper.this.currIn.read(b, off, len);
        }
    };

    public GridHadoopSerializationWrapper(Serialization<T> serialization, Class<T> cls) throws GridException {
        assert (cls != null);
        this.serializer = serialization.getSerializer(cls);
        this.deserializer = serialization.getDeserializer(cls);
        try {
            this.serializer.open(this.outStream);
            this.deserializer.open(this.inStream);
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
    }

    public void write(DataOutput out, Object obj) throws GridException {
        assert (out != null);
        assert (obj != null);
        try {
            this.currOut = (OutputStream)((Object)out);
            this.serializer.serialize(obj);
            this.currOut = null;
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
    }

    public Object read(DataInput in, @Nullable Object obj) throws GridException {
        assert (in != null);
        try {
            this.currIn = (InputStream)((Object)in);
            Object res = this.deserializer.deserialize(obj);
            this.currIn = null;
            return res;
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
    }

    public void close() throws GridException {
        try {
            this.serializer.close();
            this.deserializer.close();
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
    }
}

