/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.hadoop.io.Writable;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopInputSplit;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridHadoopSplitWrapper
extends GridHadoopInputSplit {
    private static final long serialVersionUID = 0L;
    private Object innerSplit;
    private int id;

    public GridHadoopSplitWrapper() {
    }

    public GridHadoopSplitWrapper(int id, @Nullable Object innerSplit, String[] hosts) {
        assert (hosts != null);
        this.innerSplit = innerSplit;
        this.hosts = hosts;
        this.id = id;
    }

    public Object innerSplit() {
        return this.innerSplit;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        boolean writable = this.innerSplit instanceof Writable;
        out.writeUTF(writable ? this.innerSplit.getClass().getName() : null);
        if (writable) {
            ((Writable)this.innerSplit).write((DataOutput)out);
        } else {
            out.writeObject(this.innerSplit);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        String clsName = in.readUTF();
        if (clsName == null) {
            this.innerSplit = in.readObject();
        } else {
            Class<?> cls = Class.forName(clsName);
            try {
                this.innerSplit = U.newInstance(cls);
            }
            catch (GridException e) {
                throw new IOException(e);
            }
            ((Writable)this.innerSplit).readFields((DataInput)in);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GridHadoopSplitWrapper that = (GridHadoopSplitWrapper)((Object)o);
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

