/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v2;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.counters.GenericCounter;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopFileBlock;
import org.gridgain.grid.hadoop.GridHadoopInputSplit;
import org.gridgain.grid.hadoop.GridHadoopTaskContext;
import org.gridgain.grid.hadoop.GridHadoopTaskInput;
import org.gridgain.grid.hadoop.GridHadoopTaskOutput;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopTaskCancelledException;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopExternalSplit;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopSplitWrapper;

public class GridHadoopV2Context
extends JobContextImpl
implements MapContext,
ReduceContext {
    private RecordReader reader;
    private RecordWriter writer;
    private final GridHadoopTaskOutput output;
    private final GridHadoopTaskInput input;
    private final TaskAttemptID taskAttemptID;
    private volatile boolean cancelled;
    private InputSplit inputSplit;
    private GridHadoopTaskContext ctx;
    private String status;

    public GridHadoopV2Context(Configuration cfg, GridHadoopTaskContext ctx, TaskAttemptID taskAttemptID) {
        super((Configuration)new JobConf(cfg), taskAttemptID.getJobID());
        this.taskAttemptID = taskAttemptID;
        this.conf.set("mapreduce.job.id", taskAttemptID.getJobID().toString());
        this.conf.set("mapreduce.task.id", taskAttemptID.getTaskID().toString());
        this.output = ctx.output();
        this.input = ctx.input();
        this.ctx = ctx;
    }

    public InputSplit getInputSplit() {
        if (this.inputSplit == null) {
            GridHadoopInputSplit split = this.ctx.taskInfo().inputSplit();
            if (split == null) {
                return null;
            }
            if (split instanceof GridHadoopFileBlock) {
                GridHadoopFileBlock fileBlock = (GridHadoopFileBlock)split;
                this.inputSplit = new FileSplit(new Path(fileBlock.file()), fileBlock.start(), fileBlock.length(), null);
            } else {
                if (split instanceof GridHadoopExternalSplit) {
                    throw new UnsupportedOperationException();
                }
                if (split instanceof GridHadoopSplitWrapper) {
                    this.inputSplit = (InputSplit)((GridHadoopSplitWrapper)split).innerSplit();
                } else {
                    throw new IllegalStateException();
                }
            }
        }
        return this.inputSplit;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.cancelled) {
            throw new GridHadoopTaskCancelledException("Task cancelled.");
        }
        return this.reader.nextKeyValue();
    }

    public Object getCurrentKey() throws IOException, InterruptedException {
        if (this.reader != null) {
            return this.reader.getCurrentKey();
        }
        return this.input.key();
    }

    public Object getCurrentValue() throws IOException, InterruptedException {
        return this.reader.getCurrentValue();
    }

    public void write(Object key, Object val) throws IOException, InterruptedException {
        if (this.cancelled) {
            throw new GridHadoopTaskCancelledException("Task cancelled.");
        }
        if (this.writer != null) {
            this.writer.write(key, val);
        } else {
            try {
                this.output.write(key, val);
            }
            catch (GridException e) {
                throw new IOException(e);
            }
        }
    }

    public OutputCommitter getOutputCommitter() {
        throw new UnsupportedOperationException();
    }

    public TaskAttemptID getTaskAttemptID() {
        return this.taskAttemptID;
    }

    public void setStatus(String msg) {
        this.status = msg;
    }

    public String getStatus() {
        return this.status;
    }

    public float getProgress() {
        return 0.5f;
    }

    public Counter getCounter(Enum<?> cntrName) {
        return new GenericCounter(cntrName.name(), cntrName.name());
    }

    public Counter getCounter(String grpName, String cntrName) {
        return new GenericCounter(cntrName, cntrName);
    }

    public void progress() {
    }

    public void reader(RecordReader reader) {
        this.reader = reader;
    }

    public boolean nextKey() throws IOException, InterruptedException {
        if (this.cancelled) {
            throw new GridHadoopTaskCancelledException("Task cancelled.");
        }
        return this.input.next();
    }

    public Iterable getValues() throws IOException, InterruptedException {
        return new Iterable(){

            public Iterator iterator() {
                return GridHadoopV2Context.this.input.values();
            }
        };
    }

    public RecordWriter writer() {
        return this.writer;
    }

    public void writer(RecordWriter writer) {
        this.writer = writer;
    }

    public void cancel() {
        this.cancelled = true;
    }
}

