/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v2;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopDefaultJobInfo;
import org.gridgain.grid.hadoop.GridHadoopFileBlock;
import org.gridgain.grid.hadoop.GridHadoopInputSplit;
import org.gridgain.grid.hadoop.GridHadoopJob;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.hadoop.GridHadoopJobInfo;
import org.gridgain.grid.hadoop.GridHadoopPartitioner;
import org.gridgain.grid.hadoop.GridHadoopSerialization;
import org.gridgain.grid.hadoop.GridHadoopTask;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.hadoop.GridHadoopTaskType;
import org.gridgain.grid.kernal.processors.hadoop.fs.GridHadoopLocalFileSystemV1;
import org.gridgain.grid.kernal.processors.hadoop.fs.GridHadoopLocalFileSystemV2;
import org.gridgain.grid.kernal.processors.hadoop.fs.GridHadoopRawLocalFileSystem;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1CleanupTask;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1MapTask;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1Partitioner;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1ReduceTask;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1SetupTask;
import org.gridgain.grid.kernal.processors.hadoop.v1.GridHadoopV1Splitter;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopExternalSplit;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopSerializationWrapper;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopSplitWrapper;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2CleanupTask;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2JobResourceManager;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2MapTask;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Partitioner;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2ReduceTask;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2SetupTask;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Splitter;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopWritableSerialization;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridHadoopV2Job
implements GridHadoopJob {
    private static final String LOCAL_FS_V1;
    private static final String LOCAL_FS_V2;
    private static final boolean COMBINE_KEY_GROUPING_SUPPORTED;
    private final boolean useNewMapper;
    private final boolean useNewReducer;
    private final boolean useNewCombiner;
    private GridHadoopJobId jobId;
    protected GridHadoopDefaultJobInfo jobInfo;
    protected JobContextImpl ctx;
    private JobID hadoopJobID;
    private File jobLocDir;
    private ClassLoaderWrapper jobLdr;

    public GridHadoopV2Job(GridHadoopJobId jobId, GridHadoopDefaultJobInfo jobInfo) {
        assert (jobId != null);
        assert (jobInfo != null);
        this.jobId = jobId;
        this.jobInfo = jobInfo;
        this.hadoopJobID = new JobID(jobId.globalId().toString(), jobId.localId());
        JobConf cfg = jobInfo.configuration();
        this.ctx = new JobContextImpl(cfg, (org.apache.hadoop.mapreduce.JobID)this.hadoopJobID);
        cfg.set(LOCAL_FS_V1, GridHadoopLocalFileSystemV1.class.getName());
        cfg.set(LOCAL_FS_V2, GridHadoopLocalFileSystemV2.class.getName());
        this.useNewMapper = cfg.getUseNewMapper();
        this.useNewReducer = cfg.getUseNewReducer();
        this.useNewCombiner = cfg.getCombinerClass() == null;
    }

    public GridHadoopJobId id() {
        return this.jobId;
    }

    public GridHadoopJobInfo info() {
        return this.jobInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<GridHadoopInputSplit> input() throws GridException {
        String jobDirPath = this.ctx.getConfiguration().get("mapreduce.job.dir");
        if (jobDirPath == null) {
            if (!this.useNewMapper) return GridHadoopV1Splitter.splitJob(this.ctx.getJobConf());
            return GridHadoopV2Splitter.splitJob((org.apache.hadoop.mapreduce.JobContext)this.ctx);
        }
        Path jobDir = new Path(jobDirPath);
        try {
            FileSystem fs = FileSystem.get((URI)jobDir.toUri(), (Configuration)this.ctx.getConfiguration());
            Object[] metaInfos = SplitMetaInfoReader.readSplitMetaInfo((org.apache.hadoop.mapreduce.JobID)this.hadoopJobID, (FileSystem)fs, (Configuration)this.ctx.getConfiguration(), (Path)jobDir);
            if (F.isEmpty((Object[])metaInfos)) {
                throw new GridException("No input splits found.");
            }
            Path splitsFile = JobSubmissionFiles.getJobSplitFile((Path)jobDir);
            try (FSDataInputStream in = fs.open(splitsFile);){
                ArrayList<GridHadoopInputSplit> res = new ArrayList<GridHadoopInputSplit>(metaInfos.length);
                for (Object metaInfo : metaInfos) {
                    long off = metaInfo.getStartOffset();
                    String[] hosts = metaInfo.getLocations();
                    Class<?> cls = this.readSplitClass(in, off);
                    GridHadoopFileBlock block = null;
                    if (cls != null && (block = GridHadoopV1Splitter.readFileBlock(cls, in, hosts)) == null) {
                        block = GridHadoopV2Splitter.readFileBlock(cls, in, hosts);
                    }
                    res.add((GridHadoopInputSplit)(block != null ? block : new GridHadoopExternalSplit(hosts, off)));
                }
                ArrayList<GridHadoopInputSplit> arrayList = res;
                return arrayList;
            }
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
    }

    @Nullable
    private Class<?> readSplitClass(FSDataInputStream in, long off) throws IOException {
        in.seek(off);
        String clsName = Text.readString((DataInput)in);
        try {
            return this.ctx.getConfiguration().getClassByName(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readExternalSplit(GridHadoopExternalSplit split) throws GridException {
        Path jobDir = new Path(this.ctx.getConfiguration().get("mapreduce.job.dir"));
        try {
            FileSystem fs = FileSystem.get((URI)jobDir.toUri(), (Configuration)this.ctx.getConfiguration());
            try (FSDataInputStream in = fs.open(JobSubmissionFiles.getJobSplitFile((Path)jobDir));){
                Class<?> cls = this.readSplitClass(in, split.offset());
                assert (cls != null);
                Serialization serialization = new SerializationFactory((Configuration)this.ctx.getJobConf()).getSerialization(cls);
                Deserializer deserializer = serialization.getDeserializer(cls);
                deserializer.open((InputStream)in);
                Object res = deserializer.deserialize(null);
                deserializer.close();
                assert (res != null);
                Object object = res;
                return object;
            }
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
    }

    public GridHadoopPartitioner partitioner() throws GridException {
        Class partClsOld = this.ctx.getConfiguration().getClass("mapred.partitioner.class", null);
        if (partClsOld != null) {
            return new GridHadoopV1Partitioner(this.ctx.getJobConf().getPartitionerClass(), this.ctx.getConfiguration());
        }
        try {
            return new GridHadoopV2Partitioner(this.ctx.getPartitionerClass(), this.ctx.getConfiguration());
        }
        catch (ClassNotFoundException e) {
            throw new GridException((Throwable)e);
        }
    }

    public GridHadoopTask createTask(GridHadoopTaskInfo taskInfo) {
        boolean isAbort = taskInfo.type() == GridHadoopTaskType.ABORT;
        switch (taskInfo.type()) {
            case SETUP: {
                return this.useNewMapper ? new GridHadoopV2SetupTask(taskInfo) : new GridHadoopV1SetupTask(taskInfo);
            }
            case MAP: {
                return this.useNewMapper ? new GridHadoopV2MapTask(taskInfo) : new GridHadoopV1MapTask(taskInfo);
            }
            case REDUCE: {
                return this.useNewReducer ? new GridHadoopV2ReduceTask(taskInfo, true) : new GridHadoopV1ReduceTask(taskInfo, true);
            }
            case COMBINE: {
                return this.useNewCombiner ? new GridHadoopV2ReduceTask(taskInfo, false) : new GridHadoopV1ReduceTask(taskInfo, false);
            }
            case COMMIT: 
            case ABORT: {
                return this.useNewReducer ? new GridHadoopV2CleanupTask(taskInfo, isAbort) : new GridHadoopV1CleanupTask(taskInfo, isAbort);
            }
        }
        return null;
    }

    private GridHadoopSerialization getSerialization(Class<?> cls) throws GridException {
        A.notNull(cls, (String)"cls");
        SerializationFactory factory = new SerializationFactory((Configuration)this.ctx.getJobConf());
        Serialization serialization = factory.getSerialization(cls);
        if (serialization == null) {
            throw new GridException("Failed to find serialization for: " + cls.getName());
        }
        if (serialization.getClass() == WritableSerialization.class) {
            return new GridHadoopWritableSerialization(cls);
        }
        return new GridHadoopSerializationWrapper(serialization, cls);
    }

    public GridHadoopSerialization keySerialization() throws GridException {
        return this.getSerialization(this.ctx.getMapOutputKeyClass());
    }

    public GridHadoopSerialization valueSerialization() throws GridException {
        return this.getSerialization(this.ctx.getMapOutputValueClass());
    }

    public Comparator<?> sortComparator() {
        return this.ctx.getSortComparator();
    }

    public Comparator<?> reduceGroupComparator() {
        return this.ctx.getGroupingComparator();
    }

    public Comparator<?> combineGroupComparator() {
        return COMBINE_KEY_GROUPING_SUPPORTED ? this.ctx.getCombinerKeyGroupingComparator() : null;
    }

    private TaskType taskType(GridHadoopTaskType type) {
        switch (type) {
            case SETUP: {
                return TaskType.JOB_SETUP;
            }
            case MAP: 
            case COMBINE: {
                return TaskType.MAP;
            }
            case REDUCE: {
                return TaskType.REDUCE;
            }
            case COMMIT: 
            case ABORT: {
                return TaskType.JOB_CLEANUP;
            }
        }
        return null;
    }

    public TaskAttemptID attemptId(GridHadoopTaskInfo taskInfo) {
        TaskID tid = new TaskID(this.ctx.getJobID(), this.taskType(taskInfo.type()), taskInfo.taskNumber());
        return new TaskAttemptID(tid, taskInfo.attempt());
    }

    public JobContext hadoopJobContext() {
        return this.ctx;
    }

    public Object getNativeSplit(GridHadoopInputSplit split) throws GridException {
        if (split instanceof GridHadoopExternalSplit) {
            return this.readExternalSplit((GridHadoopExternalSplit)split);
        }
        if (split instanceof GridHadoopSplitWrapper) {
            return ((GridHadoopSplitWrapper)split).innerSplit();
        }
        throw new IllegalStateException("Unknown split: " + split);
    }

    public void initialize(boolean external, UUID locNodeId) throws GridException {
        this.jobLocDir = new File(new File(U.resolveWorkDirectory((String)"hadoop", (boolean)false), "node-" + locNodeId), "job_" + this.jobId);
        GridHadoopV2JobResourceManager rsrcMgr = new GridHadoopV2JobResourceManager(this.jobId, this.ctx, this.jobLocDir);
        rsrcMgr.processJobResources(!external);
        this.initializeClassLoader(rsrcMgr.getClassPath());
        if (this.jobLdr != null) {
            this.ctx.getJobConf().setClassLoader((ClassLoader)this.jobLdr);
        }
    }

    public void dispose(boolean external) throws GridException {
        if (this.jobLdr != null) {
            this.jobLdr.destroy();
        }
        if (!external && this.jobLocDir.exists()) {
            U.delete((File)this.jobLocDir);
        }
    }

    public void beforeTaskRun(GridHadoopTaskInfo info) throws GridException {
        try {
            FileSystem.getLocal((Configuration)this.ctx.getJobConf()).setWorkingDirectory(new Path(this.jobLocDir.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
    }

    public void afterTaskRun(GridHadoopTaskInfo info) throws GridException {
        GridHadoopRawLocalFileSystem fs;
        try {
            fs = (GridHadoopRawLocalFileSystem)FileSystem.getLocal((Configuration)this.ctx.getJobConf()).getRaw();
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
        fs.setWorkingDirectory(fs.getInitialWorkingDirectory());
    }

    private void initializeClassLoader(List<URL> clsPath) {
        if (!this.jobLocDir.exists()) {
            return;
        }
        URL[] urls = new URL[clsPath.size()];
        clsPath.toArray(urls);
        URLClassLoader urlLdr = new URLClassLoader(urls);
        this.jobLdr = new ClassLoaderWrapper(urlLdr, this.getClass().getClassLoader());
    }

    static {
        boolean ok;
        LOCAL_FS_V1 = "fs." + FsConstants.LOCAL_FS_URI.getScheme() + ".impl";
        LOCAL_FS_V2 = "fs.AbstractFileSystem." + FsConstants.LOCAL_FS_URI.getScheme() + ".impl";
        try {
            org.apache.hadoop.mapreduce.JobContext.class.getDeclaredMethod("getCombinerKeyGroupingComparator", new Class[0]);
            ok = true;
        }
        catch (NoSuchMethodException ignore) {
            ok = false;
        }
        COMBINE_KEY_GROUPING_SUPPORTED = ok;
    }

    private static class ClassLoaderWrapper
    extends ClassLoader {
        private URLClassLoader delegate;

        public void destroy() {
            this.delegate = null;
        }

        private ClassLoaderWrapper(URLClassLoader delegate, ClassLoader parent) {
            super(parent);
            this.delegate = delegate;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.delegate.loadClass(name);
            }
            catch (ClassNotFoundException ignore) {
                return super.loadClass(name);
            }
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return this.delegate.getResourceAsStream(name);
        }

        @Override
        public URL findResource(String name) {
            return this.delegate.findResource(name);
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            return this.delegate.findResources(name);
        }
    }
}

