/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v2;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.util.RunJar;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class GridHadoopV2JobResourceManager {
    private JobContextImpl ctx;
    private GridHadoopJobId jobId;
    private File jobLocDir;
    private List<URL> clsPath = new ArrayList<URL>();

    public GridHadoopV2JobResourceManager(GridHadoopJobId jobId, JobContextImpl ctx, File jobLocDir) {
        this.jobId = jobId;
        this.ctx = ctx;
        this.jobLocDir = jobLocDir;
    }

    public void processJobResources(boolean download) throws GridException {
        try {
            JobConf cfg = this.ctx.getJobConf();
            String mrDir = cfg.get("mapreduce.job.dir");
            if (mrDir != null) {
                if (download) {
                    Path path = new Path(new URI(mrDir));
                    FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)cfg);
                    if (!fs.exists(path)) {
                        throw new GridException("Failed to find map-reduce submission directory (does not exist): " + path);
                    }
                    if (this.jobLocDir.exists()) {
                        throw new GridException("Local job directory already exists: " + this.jobLocDir.getAbsolutePath());
                    }
                    if (!FileUtil.copy((FileSystem)fs, (Path)path, (File)this.jobLocDir, (boolean)false, (Configuration)cfg)) {
                        throw new GridException("Failed to copy job submission directory contents to local file system [path=" + path + ", locDir=" + this.jobLocDir.getAbsolutePath() + ", jobId=" + this.jobId + ']');
                    }
                }
                this.clsPath.add(new File(this.jobLocDir, "job.jar").toURI().toURL());
                this.processFiles(this.ctx.getCacheFiles(), download, false, false);
                this.processFiles(this.ctx.getCacheArchives(), download, true, false);
                this.processFiles(this.ctx.getFileClassPaths(), download, false, true);
                this.processFiles(this.ctx.getArchiveClassPaths(), download, true, true);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new GridException((Throwable)e);
        }
    }

    private void processFiles(@Nullable Object[] files, boolean download, boolean extract, boolean addToClsPath) throws IOException {
        if (F.isEmptyOrNulls((Object[])files)) {
            return;
        }
        for (Object pathObj : files) {
            Path srcPath;
            String locName = null;
            if (pathObj instanceof URI) {
                URI uri = (URI)pathObj;
                locName = uri.getFragment();
                srcPath = new Path(uri);
            } else {
                srcPath = (Path)pathObj;
            }
            if (locName == null) {
                locName = srcPath.getName();
            }
            File dstPath = new File(this.jobLocDir.getAbsolutePath(), locName);
            if (addToClsPath) {
                this.clsPath.add(dstPath.toURI().toURL());
            }
            if (!download) {
                return;
            }
            JobConf cfg = this.ctx.getJobConf();
            LocalFileSystem dstFs = FileSystem.getLocal((Configuration)cfg);
            FileSystem srcFs = srcPath.getFileSystem((Configuration)cfg);
            if (extract) {
                File archivesPath = new File(this.jobLocDir.getAbsolutePath(), ".cached-archives");
                if (!archivesPath.exists() && !archivesPath.mkdir()) {
                    throw new IOException("Failed to create directory [path=" + archivesPath + ", jobId=" + this.jobId + ']');
                }
                File archiveFile = new File(archivesPath, locName);
                FileUtil.copy((FileSystem)srcFs, (Path)srcPath, (FileSystem)dstFs, (Path)new Path(archiveFile.toString()), (boolean)false, (Configuration)cfg);
                String archiveNameLC = archiveFile.getName().toLowerCase();
                if (archiveNameLC.endsWith(".jar")) {
                    RunJar.unJar((File)archiveFile, (File)dstPath);
                    continue;
                }
                if (archiveNameLC.endsWith(".zip")) {
                    FileUtil.unZip((File)archiveFile, (File)dstPath);
                    continue;
                }
                if (archiveNameLC.endsWith(".tar.gz") || archiveNameLC.endsWith(".tgz") || archiveNameLC.endsWith(".tar")) {
                    FileUtil.unTar((File)archiveFile, (File)dstPath);
                    continue;
                }
                throw new IOException("Cannot unpack archive [path=" + srcPath + ", jobId=" + this.jobId + ']');
            }
            FileUtil.copy((FileSystem)srcFs, (Path)srcPath, (FileSystem)dstFs, (Path)new Path(dstPath.toString()), (boolean)false, (Configuration)cfg);
        }
    }

    public List<URL> getClassPath() {
        return this.clsPath;
    }
}

