/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v2;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.map.WrappedMapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridInterruptedException;
import org.gridgain.grid.hadoop.GridHadoopFileBlock;
import org.gridgain.grid.hadoop.GridHadoopInputSplit;
import org.gridgain.grid.hadoop.GridHadoopTaskContext;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Job;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Task;

public class GridHadoopV2MapTask
extends GridHadoopV2Task {
    public GridHadoopV2MapTask(GridHadoopTaskInfo taskInfo) {
        super(taskInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run0(GridHadoopV2Job jobImpl, JobContext jobCtx, GridHadoopTaskContext taskCtx) throws GridException {
        InputSplit nativeSplit;
        InputFormat inFormat;
        Mapper mapper;
        try {
            mapper = (Mapper)ReflectionUtils.newInstance((Class)jobCtx.getMapperClass(), (Configuration)jobCtx.getConfiguration());
            inFormat = (InputFormat)ReflectionUtils.newInstance((Class)jobCtx.getInputFormatClass(), (Configuration)jobCtx.getConfiguration());
        }
        catch (ClassNotFoundException e) {
            throw new GridException((Throwable)e);
        }
        GridHadoopInputSplit split = this.info().inputSplit();
        if (split instanceof GridHadoopFileBlock) {
            GridHadoopFileBlock block = (GridHadoopFileBlock)split;
            nativeSplit = new FileSplit(new Path(block.file().toString()), block.start(), block.length(), null);
        } else {
            nativeSplit = (InputSplit)jobImpl.getNativeSplit(split);
        }
        assert (nativeSplit != null);
        OutputFormat outputFormat = null;
        Exception err = null;
        try {
            RecordReader reader = inFormat.createRecordReader(nativeSplit, (TaskAttemptContext)this.hadoopContext());
            reader.initialize(nativeSplit, (TaskAttemptContext)this.hadoopContext());
            this.hadoopContext().reader(reader);
            outputFormat = jobImpl.info().hasCombiner() || jobImpl.info().hasReducer() ? null : this.prepareWriter(jobCtx);
            try {
                mapper.run(new WrappedMapper().getMapContext((MapContext)this.hadoopContext()));
            }
            finally {
                this.closeWriter();
            }
            this.commit(outputFormat);
            if (err == null) return;
        }
        catch (InterruptedException e) {
            try {
                err = e;
                Thread.currentThread().interrupt();
                throw new GridInterruptedException(e);
                catch (Exception e2) {
                    err = e2;
                    throw new GridException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (err == null) throw throwable;
                this.abort(outputFormat);
                throw throwable;
            }
        }
        this.abort(outputFormat);
    }
}

