/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v2;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.reduce.WrappedReducer;
import org.apache.hadoop.util.ReflectionUtils;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridInterruptedException;
import org.gridgain.grid.hadoop.GridHadoopTaskContext;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Job;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Task;

public class GridHadoopV2ReduceTask
extends GridHadoopV2Task {
    private final boolean reduce;

    public GridHadoopV2ReduceTask(GridHadoopTaskInfo taskInfo, boolean reduce) {
        super(taskInfo);
        this.reduce = reduce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run0(GridHadoopV2Job jobImpl, JobContext jobCtx, GridHadoopTaskContext taskCtx) throws GridException {
        OutputFormat outputFormat = null;
        Exception err = null;
        try {
            Reducer reducer = (Reducer)ReflectionUtils.newInstance((Class)(this.reduce ? jobCtx.getReducerClass() : jobCtx.getCombinerClass()), (Configuration)jobCtx.getConfiguration());
            outputFormat = this.reduce || !jobImpl.info().hasReducer() ? this.prepareWriter(jobCtx) : null;
            try {
                reducer.run(new WrappedReducer().getReducerContext((ReduceContext)this.hadoopContext()));
            }
            finally {
                this.closeWriter();
            }
            this.commit(outputFormat);
            if (err == null) return;
        }
        catch (InterruptedException e) {
            try {
                err = e;
                Thread.currentThread().interrupt();
                throw new GridInterruptedException(e);
                catch (Exception e2) {
                    err = e2;
                    throw new GridException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (err == null) throw throwable;
                this.abort(outputFormat);
                throw throwable;
            }
        }
        this.abort(outputFormat);
    }
}

