/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v2;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridInterruptedException;
import org.gridgain.grid.hadoop.GridHadoopFileBlock;
import org.gridgain.grid.hadoop.GridHadoopInputSplit;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopSplitWrapper;
import org.jetbrains.annotations.Nullable;

public class GridHadoopV2Splitter {
    private static final String[] EMPTY_HOSTS = new String[0];

    public static Collection<GridHadoopInputSplit> splitJob(JobContext ctx) throws GridException {
        try {
            InputFormat format = (InputFormat)ReflectionUtils.newInstance((Class)ctx.getInputFormatClass(), (Configuration)ctx.getConfiguration());
            assert (format != null);
            List splits = format.getSplits(ctx);
            ArrayList<GridHadoopInputSplit> res = new ArrayList<GridHadoopInputSplit>(splits.size());
            int id = 0;
            for (InputSplit nativeSplit : splits) {
                if (nativeSplit instanceof FileSplit) {
                    FileSplit s = (FileSplit)nativeSplit;
                    res.add((GridHadoopInputSplit)new GridHadoopFileBlock(s.getLocations(), s.getPath().toUri(), s.getStart(), s.getLength()));
                } else {
                    res.add(new GridHadoopSplitWrapper(id, nativeSplit, nativeSplit.getLocations()));
                }
                ++id;
            }
            return res;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new GridException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GridInterruptedException(e);
        }
    }

    public static GridHadoopFileBlock readFileBlock(Class<?> cls, FSDataInputStream in, @Nullable String[] hosts) throws GridException {
        if (FileSplit.class != cls) {
            return null;
        }
        FileSplit split = new FileSplit();
        try {
            split.readFields((DataInput)in);
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
        if (hosts == null) {
            hosts = EMPTY_HOSTS;
        }
        return new GridHadoopFileBlock(hosts, split.getPath().toUri(), split.getStart(), split.getLength());
    }
}

